/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400BasicAuthenticationCredential;
import com.ibm.as400.security.auth.AS400BasicAuthenticationPrincipal;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.UserProfilePrincipal;
import java.beans.PropertyVetoException;
import java.util.Random;

public final class ProfileTokenCredential
extends AS400Credential
implements AS400BasicAuthenticationCredential {
    static final long serialVersionUID = 4L;
    private byte[] addr_ = new byte[9];
    private byte[] mask_ = new byte[7];
    private byte[] token_ = null;
    private int type_ = 1;
    private int timeoutInterval_ = 3600;
    private static final int MAX_USERPROFILE_LENGTH = 10;
    static final int MAX_PASSWORD_LENGTH = 128;
    public static final int TYPE_SINGLE_USE = 1;
    public static final int TYPE_MULTIPLE_USE_NON_RENEWABLE = 2;
    public static final int TYPE_MULTIPLE_USE_RENEWABLE = 3;
    public static final int TOKEN_LENGTH = 32;
    public static final int PW_NOPWD = 1;
    public static final int PW_NOPWDCHK = 2;
    private boolean noRefresh = false;

    public ProfileTokenCredential() {
        new Random().nextBytes(this.addr_);
        new Random().nextBytes(this.mask_);
    }

    public ProfileTokenCredential(AS400 system, byte[] token, int tokenType, int timeoutInterval) {
        this();
        try {
            this.setSystem(system);
            this.setToken(token);
            this.setTokenType(tokenType);
            this.setTimeoutInterval(timeoutInterval);
        }
        catch (PropertyVetoException pve) {
            AuthenticationSystem.handleUnexpectedException(pve);
        }
    }

    private static byte[] decode(byte[] adder, byte[] mask, byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = (byte)((mask[i % mask.length] ^ bytes[i]) - adder[i % adder.length]);
        }
        return buf;
    }

    private static byte[] encode(byte[] adder, byte[] mask, byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = (byte)(bytes[i] + adder[i % adder.length] ^ mask[i % mask.length]);
        }
        return buf;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileTokenCredential)) {
            return false;
        }
        return this.hashCode() == ((ProfileTokenCredential)o).hashCode();
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval_;
    }

    public synchronized byte[] getToken() {
        if (this.token_ != null) {
            return this.primitiveGetToken();
        }
        return null;
    }

    public int getTokenType() {
        return this.type_;
    }

    public int superHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        int hash = 104473;
        if (this.token_ != null) {
            byte[] tkn = this.getToken();
            for (int i = 0; i < tkn.length; ++i) {
                hash ^= tkn[i];
            }
        }
        hash ^= this.type_ ^ 0x3841;
        hash ^= this.timeoutInterval_ ^ 0x534F;
        hash ^= this.isPrivate() ? 15501 : 12003;
        if (this.getPrincipal() != null) {
            hash ^= this.getPrincipal().hashCode();
        }
        if (this.getSystem() != null) {
            hash ^= this.getSystem().getSystemName().hashCode();
        }
        return hash;
    }

    @Override
    String implClassNameNative() {
        return "com.ibm.as400.access.ProfileTokenImplNative";
    }

    @Override
    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.ProfileTokenImplRemote";
    }

    @Override
    public void initialize(AS400BasicAuthenticationPrincipal principal, String password, boolean isPrivate, boolean isReusable, boolean isRenewable, int timeoutInterval) throws Exception {
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Initializing credential >> ").append(this.toString()).append(", for principal >> ").append(principal.toString()).append(", isPrivate == ").append(isPrivate).append(", isReusable == ").append(isReusable).append(", isRenewable == ").append(isRenewable).append(", timeoutInterval == ").append(timeoutInterval).toString());
        }
        if (isRenewable && !isReusable) {
            Trace.log(2, "Profile tokens must be multi-use if declared as regenerable.");
            throw new ExtendedIllegalArgumentException("isReusable", 2);
        }
        AS400 sys = AuthenticationSystem.localHost();
        this.setSystem(sys);
        AS400Principal pr = AS400Principal.class.isAssignableFrom(principal.getClass()) ? (AS400Principal)((Object)principal) : new UserProfilePrincipal(sys, principal.getUserProfileName());
        this.setPrincipal(pr);
        this.private_ = isPrivate;
        this.setTimeoutInterval(timeoutInterval);
        if (isRenewable) {
            this.setTokenType(3);
        } else if (isReusable) {
            this.setTokenType(2);
        } else {
            this.setTokenType(1);
        }
        this.setTokenExtended(pr, password);
    }

    @Override
    public void initialize(AS400BasicAuthenticationPrincipal principal, char[] password, boolean isPrivate, boolean isReusable, boolean isRenewable, int timeoutInterval) throws Exception {
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Initializing credential >> ").append(this.toString()).append(", for principal >> ").append(principal.toString()).append(", isPrivate == ").append(isPrivate).append(", isReusable == ").append(isReusable).append(", isRenewable == ").append(isRenewable).append(", timeoutInterval == ").append(timeoutInterval).toString());
        }
        if (isRenewable && !isReusable) {
            Trace.log(2, "Profile tokens must be multi-use if declared as regenerable.");
            throw new ExtendedIllegalArgumentException("isReusable", 2);
        }
        AS400 sys = AuthenticationSystem.localHost();
        this.setSystem(sys);
        AS400Principal pr = AS400Principal.class.isAssignableFrom(principal.getClass()) ? (AS400Principal)((Object)principal) : new UserProfilePrincipal(sys, principal.getUserProfileName());
        this.setPrincipal(pr);
        this.private_ = isPrivate;
        this.setTimeoutInterval(timeoutInterval);
        if (isRenewable) {
            this.setTokenType(3);
        } else if (isReusable) {
            this.setTokenType(2);
        } else {
            this.setTokenType(1);
        }
        this.setTokenExtended(pr, password);
    }

    @Override
    void invalidateProperties() {
        super.invalidateProperties();
        this.token_ = null;
    }

    @Override
    public boolean isRenewable() {
        return this.type_ == 3;
    }

    public boolean isReusable() {
        return this.type_ == 2 || this.type_ == 3;
    }

    private byte[] primitiveGetToken() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.superHashCode()) + " getPrimitiveToken called");
            if (!this.noRefresh) {
                // empty if block
            }
        }
        return ProfileTokenCredential.decode(this.addr_, this.mask_, this.token_);
    }

    private void primitiveSetToken(byte[] bytes) {
        this.token_ = ProfileTokenCredential.encode(this.addr_, this.mask_, bytes);
    }

    @Override
    public void refresh() throws AS400SecurityException {
        this.refresh(this.getTokenType(), this.getTimeoutInterval());
    }

    public synchronized void refresh(int type, int timeoutInterval) throws AS400SecurityException {
        while (this.noRefresh) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " refresh stuck because of noRefresh");
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " refresh called");
        }
        this.checkAuthenticationPermission("refreshCredential");
        if (!this.isRenewable()) {
            return;
        }
        if (type < 1 || type > 3) {
            Trace.log(2, "Token type " + type + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        if (timeoutInterval < 1 || timeoutInterval > 3600) {
            Trace.log(2, "Timeout interval " + timeoutInterval + " out of range");
            throw new ExtendedIllegalArgumentException("timeoutInterval", 4);
        }
        byte[] old = this.getToken();
        byte[] bytes = ((ProfileTokenImpl)this.getImpl()).refresh(type, timeoutInterval);
        this.primitiveSetToken(bytes);
        this.type_ = type;
        this.timeoutInterval_ = timeoutInterval;
        this.fireRefreshed();
        this.firePropertyChange("token", old, bytes);
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " Credential refreshed with type ").append(type).append(" and timeoutInterval = ").append(timeoutInterval).append(" >> ").append(this.toString()).toString());
        }
    }

    public void setTimeoutInterval(int seconds) throws PropertyVetoException {
        this.validatePropertyChange("timeoutInterval");
        if (seconds < 1 || seconds > 3600) {
            Trace.log(2, "Number of seconds " + seconds + " out of range");
            throw new ExtendedIllegalArgumentException("seconds", 4);
        }
        Integer old = this.timeoutInterval_;
        Integer sec = seconds;
        this.fireVetoableChange("timeoutInterval", old, sec);
        this.timeoutInterval_ = seconds;
        this.firePropertyChange("timeoutInterval", old, sec);
    }

    public synchronized void setToken(byte[] bytes) throws PropertyVetoException {
        this.validatePropertyChange("token");
        if (bytes == null) {
            Trace.log(2, "Token byte array is null");
            throw new ExtendedIllegalArgumentException("bytes", 2);
        }
        if (bytes.length != 32) {
            Trace.log(2, "Token of length " + bytes.length + " not valid ");
            throw new ExtendedIllegalArgumentException("bytes", 1);
        }
        byte[] old = this.getToken();
        this.fireVetoableChange("token", old, bytes);
        this.primitiveSetToken(bytes);
        this.firePropertyChange("token", old, bytes);
    }

    public void setToken(AS400Principal principal, String password) throws PropertyVetoException, AS400SecurityException {
        this.setToken(principal.getUserProfileName(), password);
    }

    public void setToken(String name, String password) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(impl.generateToken(name, password, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setToken(AS400Principal principal, int passwordSpecialValue) throws PropertyVetoException, AS400SecurityException {
        this.setToken(principal.getUserProfileName(), passwordSpecialValue);
    }

    public void setToken(String name, int passwordSpecialValue) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        switch (passwordSpecialValue) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                Trace.log(2, "Special value for password is not valid");
                throw new ExtendedIllegalArgumentException("password", 2);
            }
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(impl.generateToken(name, passwordSpecialValue, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setTokenExtended(AS400Principal principal, String password) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(principal.getUserProfileName(), password);
    }

    public void setTokenExtended(AS400Principal principal, char[] password) throws PropertyVetoException, AS400SecurityException {
        this.setTokenExtended(principal.getUserProfileName(), password);
    }

    public void setTokenExtended(String name, String password) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        char[] passwordChars = password.toCharArray();
        this.setToken(impl.generateTokenExtended(name, passwordChars, this.getTokenType(), this.getTimeoutInterval()));
        for (int i = 0; i < passwordChars.length; ++i) {
            passwordChars[i] = (char)i;
        }
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setTokenExtended(String name, char[] password) throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        if (name == null) {
            Trace.log(2, "User profile name is null");
            throw new ExtendedIllegalArgumentException("name", 2);
        }
        if (name.length() > 10) {
            Trace.log(2, "User profile name exceeds maximum allowed length");
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        if (password == null) {
            Trace.log(2, "User profile password is null");
            throw new ExtendedIllegalArgumentException("password", 2);
        }
        ProfileTokenImpl impl = (ProfileTokenImpl)this.getImplPrimitive();
        this.setToken(impl.generateTokenExtended(name, password, this.getTokenType(), this.getTimeoutInterval()));
        this.setImpl(impl);
        this.fireCreated();
    }

    public void setTokenType(int type) throws PropertyVetoException {
        this.validatePropertyChange("tokenType");
        if (type < 1 || type > 3) {
            Trace.log(2, "Token type " + type + " out of range");
            throw new ExtendedIllegalArgumentException("type", 4);
        }
        Integer old = this.type_;
        Integer typ = type;
        this.fireVetoableChange("tokenType", old, typ);
        this.type_ = type;
        this.firePropertyChange("tokenType", old, typ);
    }

    public String toString() {
        return new StringBuffer(256).append(super.toString()).append('[').append(this.getTokenType()).append(',').append(this.getTimeoutInterval()).append(']').toString();
    }

    @Override
    boolean typeIsStandalone() {
        return true;
    }

    @Override
    boolean typeIsTimed() {
        return true;
    }

    @Override
    void validateProperties() {
        super.validateProperties();
        this.validatePropertySet("token", this.getToken());
    }

    public synchronized void preventRefresh() throws InterruptedException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " preventRefresh");
        }
        this.noRefresh = true;
    }

    public synchronized void allowRefresh() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "ProfileTokenCredential@" + Integer.toHexString(this.hashCode()) + " allowRefresh");
        }
        this.noRefresh = false;
        this.notify();
    }
}

