/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class FormInput
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8967841585682519631L;
    private String name_;
    private String value_;
    private int size_ = 0;
    private String lang_;
    private String dir_;
    transient VetoableChangeSupport vetos_;

    public FormInput() {
    }

    public FormInput(String name) {
        this();
        try {
            this.setName(name);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public FormInput(String name, String value) {
        this(name);
        try {
            this.setValue(value);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public int getSize() {
        return this.size_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    String getNameAttributeTag() {
        if (this.name_ != null && this.name_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" name=\"");
            buffer.append(this.name_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    String getSizeAttributeTag() {
        if (this.size_ > 0) {
            StringBuffer buffer = new StringBuffer(" size=\"");
            buffer.append(this.size_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    String getValueAttributeTag(boolean encode) {
        if (this.value_ != null) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "   URL value needs Encoding: " + encode);
            }
            if (encode) {
                this.value_ = URLEncoder.encode(this.value_);
            }
            StringBuffer buffer = new StringBuffer(" value=\"");
            buffer.append(this.value_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name);
        }
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setSize(int size) throws PropertyVetoException {
        if (size < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int old = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", (Object)old, (Object)size);
        }
        this.size_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", (Object)old, (Object)size);
        }
    }

    public void setValue(String value) throws PropertyVetoException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String old = this.value_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("value", old, value);
        }
        this.value_ = value;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", old, value);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

