/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLAlign
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7673670119386729128L;
    private String align_ = "left";
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public HTMLAlign() {
    }

    public HTMLAlign(HTMLTagElement data) {
        this.addItem(data);
    }

    public HTMLAlign(HTMLTagElement data, String align) {
        this.addItem(data);
        this.setAlign(align);
    }

    public void addItem(HTMLTagElement data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.list_.addElement(data);
        this.fireElementEvent(0);
    }

    public void addItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getAlign() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer s = new StringBuffer("");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                s.append("<div align=\"left\"");
            } else if (this.align_.equals("right")) {
                s.append("<div align=\"right\"");
            } else if (this.align_.equals("center")) {
                s.append("<div align=\"center\"");
            }
        }
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement data = (HTMLTagElement)this.list_.elementAt(i);
            s.append(data.getTag());
        }
        s.append("\n</div>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before adding items to list.");
            throw new ExtendedIllegalStateException("data", 4);
        }
        StringBuffer s = new StringBuffer("");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                s.append("<fo:block text-align='start'");
            } else if (this.align_.equals("right")) {
                s.append("<fo:block text-align='end'");
            } else if (this.align_.equals("center")) {
                s.append("<fo:block text-align='center'");
            }
        }
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement data = (HTMLTagElement)this.list_.elementAt(i);
            s.append(data.getFOTag());
            s.append("\n");
        }
        s.append("</fo:block>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    public void removeItemElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeItem(HTMLTagElement data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.list_.removeElement(data)) {
            this.fireElementEvent(2);
        }
    }

    public void setAlign(String align) {
        if (align == null) {
            throw new NullPointerException("align");
        }
        if (!(align.equals("left") || align.equals("right") || align.equals("center"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting alignment for <div>.");
        }
        String old = this.align_;
        this.align_ = align;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", old, align);
        }
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

