/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLParameter;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLApplet
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 3578237003243756490L;
    private String archive_;
    private String code_;
    private String codebase_;
    private int width_;
    private int height_;
    private String text_ = ResourceBundleLoader_h.getText("PROP_DESC_APPLET_ALTTEXT");
    private Vector list_;
    private static ResourceBundleLoader_h loader_;
    private transient Vector elementListeners;

    public HTMLApplet() {
        this.list_ = new Vector();
    }

    public HTMLApplet(String code) {
        this.setCode(code);
        this.list_ = new Vector();
    }

    public HTMLApplet(String code, int width, int height) {
        this.setCode(code);
        this.setWidth(width);
        this.setHeight(height);
        this.list_ = new Vector();
    }

    public HTMLApplet(String code, String codebase, int width, int height) {
        this.setCode(code);
        this.setCodebase(codebase);
        this.setWidth(width);
        this.setHeight(height);
        this.list_ = new Vector();
    }

    public HTMLApplet(String archive, String code, String codebase, int width, int height) {
        this.setArchive(archive);
        this.setCode(code);
        this.setCodebase(codebase);
        this.setWidth(width);
        this.setHeight(height);
        this.list_ = new Vector();
    }

    public void addParameter(HTMLParameter param) {
        if (param == null) {
            throw new NullPointerException("param");
        }
        this.list_.addElement(param);
        this.fireElementEvent(0);
    }

    public HTMLParameter addParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HTMLParameter param = new HTMLParameter(name, value);
        this.list_.addElement(param);
        this.fireElementEvent(0);
        return param;
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getArchive() {
        return this.archive_;
    }

    public String getCode() {
        return this.code_;
    }

    public String getCodebase() {
        return this.codebase_;
    }

    public int getHeight() {
        return this.height_;
    }

    public String getText() {
        return this.text_;
    }

    public int getWidth() {
        return this.width_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLApplet was here -->";
    }

    @Override
    public String getTag() {
        if (this.code_ == null) {
            Trace.log(2, "Attempting to get tag before setting applet code.");
            throw new ExtendedIllegalStateException("code", 4);
        }
        if (this.width_ <= 0) {
            Trace.log(2, "Attempting to get tag before setting applet width.");
            throw new ExtendedIllegalStateException("width", 4);
        }
        if (this.height_ <= 0) {
            Trace.log(2, "Attempting to get tag before setting applet height.");
            throw new ExtendedIllegalStateException("height", 4);
        }
        StringBuffer s = new StringBuffer("<applet");
        if (this.codebase_ != null) {
            s.append(" codebase=\"" + this.getCodebase() + "\"");
        }
        s.append(" code=\"" + this.getCode() + "\"");
        s.append(" width=\"" + this.getWidth() + "\"");
        s.append(" height=\"" + this.getHeight() + "\"");
        if (this.archive_ != null) {
            s.append(" archive=\"" + this.getArchive() + "\"");
        }
        s.append(this.getAttributeString());
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLParameter p = (HTMLParameter)this.list_.elementAt(i);
            s.append(p.getTag());
        }
        s.append(this.getText() + "\n");
        s.append("</applet>\n");
        return s.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeParameter(HTMLParameter param) {
        if (param == null) {
            throw new NullPointerException("param");
        }
        if (this.list_.removeElement(param)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void setCodebase(String codebase) {
        if (codebase == null) {
            throw new NullPointerException("codebase");
        }
        if (codebase.length() == 0) {
            throw new ExtendedIllegalArgumentException("codebase", 1);
        }
        String old = this.codebase_;
        this.codebase_ = codebase;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("codebase", old, codebase);
        }
    }

    public void setArchive(String archive) {
        if (archive == null) {
            throw new NullPointerException("archive");
        }
        if (archive.length() == 0) {
            throw new ExtendedIllegalArgumentException("archive", 1);
        }
        String old = this.archive_;
        this.archive_ = archive;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("archive", old, archive);
        }
    }

    public void setCode(String code) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (code.length() == 0) {
            throw new ExtendedIllegalArgumentException("code", 1);
        }
        String old = this.code_;
        this.code_ = code;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("code", old, code);
        }
    }

    public void setHeight(int height) {
        if (height <= 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int old = this.height_;
        this.height_ = height;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", (Object)old, (Object)height);
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String old = this.text_;
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public void setWidth(int width) {
        if (width <= 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int old = this.width_;
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", (Object)old, (Object)width);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

