/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLParameter;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLServlet
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3782566892366981877L;
    private String name_;
    private String text_ = ResourceBundleLoader_h.getText("PROP_DESC_SERVLET_ALTTEXT");
    private String location_;
    private Vector list_;
    private static ResourceBundleLoader_h loader_;
    private transient Vector elementListeners;

    public HTMLServlet() {
        this.list_ = new Vector();
    }

    public HTMLServlet(String name) {
        this.setName(name);
        this.list_ = new Vector();
    }

    public HTMLServlet(String name, String location) {
        this.setName(name);
        this.setLocation(location);
        this.list_ = new Vector();
    }

    public void addParameter(HTMLParameter param) {
        if (param == null) {
            throw new NullPointerException("param");
        }
        this.list_.addElement(param);
        this.fireElementEvent(0);
    }

    public HTMLParameter addParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        HTMLParameter param = new HTMLParameter(name, value);
        this.list_.addElement(param);
        this.fireElementEvent(0);
        return param;
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getLocation() {
        return this.location_;
    }

    public String getName() {
        return this.name_;
    }

    public String getText() {
        return this.text_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLServlet was here -->";
    }

    @Override
    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting servlet name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("<servlet");
        s.append(" name=\"" + this.getName() + "\"");
        if (this.location_ != null) {
            s.append(" codebase=\"");
            s.append(this.getLocation());
            s.append("\"");
            s.append(this.getAttributeString());
            s.append(">\n");
        } else {
            s.append(this.getAttributeString());
            s.append(">\n");
        }
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLParameter p = (HTMLParameter)this.list_.elementAt(i);
            s.append(p.getTag());
        }
        s.append(this.getText() + "\n");
        s.append("</servlet>\n");
        return s.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeParameter(HTMLParameter param) {
        if (param == null) {
            throw new NullPointerException("param");
        }
        if (this.list_.removeElement(param)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void setLocation(String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (location.length() == 0) {
            throw new ExtendedIllegalArgumentException("location", 1);
        }
        String old = this.location_;
        this.location_ = location;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("location", old, location);
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new ExtendedIllegalArgumentException("name", 1);
        }
        String old = this.name_;
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() == 0) {
            throw new ExtendedIllegalArgumentException("text", 1);
        }
        String old = this.text_;
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

