/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLListItem;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;

public class OrderedListItem
extends HTMLListItem {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -5825465966031878506L;
    private String type_;
    private int value_ = -1;

    public OrderedListItem() {
    }

    public OrderedListItem(HTMLTagElement data) {
        this.setItemData(data);
    }

    public String getType() {
        return this.type_;
    }

    public int getValue() {
        return this.value_;
    }

    @Override
    String getTypeAttribute() {
        StringBuffer s = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("numbers")) {
                s.append(" type=\"1\"");
            } else if (this.type_.equals("capitals")) {
                s.append(" type=\"A\"");
            } else if (this.type_.equals("lower_case")) {
                s.append(" type=\"a\"");
            } else if (this.type_.equals("large_roman")) {
                s.append(" type=\"I\"");
            } else if (this.type_.equals("small_roman")) {
                s.append(" type=\"i\"");
            }
        }
        if (this.value_ > 0) {
            s.append(" value=\"");
            s.append(Integer.toString(this.value_));
            s.append("\"");
        }
        return s.toString();
    }

    @Override
    String getTypeAttributeFO(String type, int label) {
        if (this.value_ > 0) {
            label = this.value_;
        }
        StringBuffer s = new StringBuffer("");
        if (type != null) {
            if (type.equals("numbers")) {
                s.append(String.valueOf(label));
                s.append(".");
            } else if (type.equals("capitals")) {
                char c = (char)(64 + label);
                s.append(c);
                s.append(".");
            } else if (type.equals("lower_case")) {
                char c = (char)(96 + label);
                s.append(c);
                s.append(".");
            } else if (type.equals("large_roman")) {
                s.append(this.toRoman(label));
                s.append(".");
            } else if (type.equals("small_roman")) {
                s.append(this.toRoman(label).toLowerCase());
                s.append(".");
            }
        }
        return s.toString();
    }

    String toRoman(int n) {
        StringBuffer numeral = new StringBuffer(20);
        while (n >= 1000) {
            numeral.append("M");
            n -= 1000;
        }
        if (n >= 900) {
            numeral.append("CM");
            n -= 900;
        }
        if (n >= 500) {
            numeral.append("D");
            n -= 500;
        }
        if (n >= 400) {
            numeral.append("CD");
            n -= 400;
        }
        while (n >= 100) {
            numeral.append("C");
            n -= 100;
        }
        if (n >= 90) {
            numeral.append("XC");
            n -= 90;
        }
        if (n >= 50) {
            numeral.append("L");
            n -= 50;
        }
        if (n >= 40) {
            numeral.append("XL");
            n -= 40;
        }
        while (n >= 10) {
            numeral.append("X");
            n -= 10;
        }
        if (n >= 9) {
            numeral.append("IX");
            n -= 9;
        }
        if (n >= 5) {
            numeral.append("V");
            n -= 5;
        }
        if (n >= 4) {
            numeral.append("IV");
            n -= 4;
        }
        while (n >= 1) {
            numeral.append("I");
            --n;
        }
        return numeral.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!(type.equals("numbers") || type.equals("capitals") || type.equals("lower_case") || type.equals("large_roman") || type.equals("small_roman"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting order labeling type for <ol>.");
        }
        String old = this.type_;
        this.type_ = type;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", old, type);
        }
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new ExtendedIllegalArgumentException("value", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting current <li> number for <ol>.");
        }
        int old = this.value_;
        this.value_ = value;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", (Object)old, (Object)value);
        }
    }
}

