/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;

public class ServletHyperlink
extends HTMLHyperlink {
    static final long serialVersionUID = 6349134986210346587L;
    private HttpServletResponse response_;
    private String pathInfo_;
    transient PropertyChangeSupport changes_;

    public ServletHyperlink() {
    }

    public ServletHyperlink(String link) {
        super(link);
    }

    public ServletHyperlink(String link, String text) {
        super(link, text);
    }

    public ServletHyperlink(String link, String text, String target) {
        super(link, text, target);
    }

    public ServletHyperlink(String link, String text, String target, String path, HttpServletResponse response) {
        super(link, text, target);
        this.setPathInfo(path);
        this.setHttpServletResponse(response);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    @Override
    public Object clone() {
        ServletHyperlink l = new ServletHyperlink();
        try {
            if (this.getHttpServletResponse() != null) {
                l.setHttpServletResponse(this.getHttpServletResponse());
            }
            if (this.getProperties() != null) {
                l.setProperties(this.getProperties());
            }
            if (this.getLocation() != null) {
                l.setLocation(this.getLocation());
            }
            if (this.getPathInfo() != null) {
                l.setPathInfo(this.getPathInfo());
            }
            if (this.getAttributes() != null) {
                l.setAttributes(this.getAttributes());
            }
            if (this.getLink() != null) {
                l.setLink(this.getLink());
            }
            if (this.getTarget() != null) {
                l.setTarget(this.getTarget());
            }
            if (this.getText() != null) {
                l.setText(this.getText());
            }
            if (this.getTitle() != null) {
                l.setTitle(this.getTitle());
            }
            if (this.getDirection() != null) {
                l.setDirection(this.getDirection());
            }
            if (this.getLanguage() != null) {
                l.setLanguage(this.getLanguage());
            }
            if (this.getName() != null) {
                l.setName(this.getName());
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return l;
    }

    String getDirectionTag() {
        if (this.getDirection() != null && this.getDirection().length() > 0) {
            return " dir=\"" + this.getDirection() + "\"";
        }
        return "";
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response_;
    }

    String getLanguageTag() {
        if (this.getLanguage() != null && this.getLanguage().length() > 0) {
            return " lang=\"" + this.getLanguage() + "\"";
        }
        return "";
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    @Override
    public String getTag() {
        return this.getTag(this.getText(), this.getProperties());
    }

    @Override
    public String getTag(String text, Properties properties) {
        String target;
        String title;
        if (this.getLink() == null) {
            Trace.log(2, "Attempting to get tag before setting the link.");
            throw new ExtendedIllegalStateException("link", 4);
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        StringBuffer link = new StringBuffer(this.getLink());
        if (this.pathInfo_ != null) {
            if (this.getLink().endsWith("/")) {
                if (this.pathInfo_.startsWith("/")) {
                    this.pathInfo_ = this.pathInfo_.substring(1);
                }
            } else if (!this.pathInfo_.startsWith("/")) {
                this.pathInfo_ = "/" + this.pathInfo_;
            }
            link.append(URLEncoder.encode(this.pathInfo_, false));
        }
        if (properties != null) {
            String parmStart = "?";
            Enumeration<?> propertyList = properties.propertyNames();
            while (propertyList.hasMoreElements()) {
                String name = (String)propertyList.nextElement();
                link.append(parmStart);
                link.append(URLEncoder.encode(name));
                link.append("=");
                link.append(URLEncoder.encode(properties.getProperty(name)));
                parmStart = "&";
            }
        }
        StringBuffer url = new StringBuffer();
        if (this.response_ != null) {
            url.append(this.response_.encodeURL(link.toString()));
        } else {
            url.append(link.toString());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<a href=\"");
        buffer.append(url.toString());
        String location = this.getLocation();
        if (location != null) {
            buffer.append("#");
            buffer.append(location);
        }
        buffer.append("\"");
        String name = this.getName();
        if (name != null) {
            buffer.append(" name=\"");
            buffer.append(name);
            buffer.append("\"");
        }
        if ((title = this.getTitle()) != null) {
            buffer.append(" title=\"");
            buffer.append(title);
            buffer.append("\"");
        }
        if ((target = this.getTarget()) != null) {
            buffer.append(" target=\"");
            buffer.append(target);
            buffer.append("\"");
        }
        buffer.append(this.getLanguageTag());
        buffer.append(this.getDirectionTag());
        buffer.append(this.getAttributeString());
        buffer.append(">");
        buffer.append(text);
        buffer.append("</a>");
        return buffer.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
        super.removePropertyChangeListener(listener);
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        HttpServletResponse old = this.response_;
        this.response_ = response;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("response", old, response);
        }
    }

    public void setPathInfo(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        String old = this.pathInfo_;
        this.pathInfo_ = path;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("path", old, path);
        }
    }
}

