/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import org.apache.hop.metadata.api.IEnumHasCode;

public enum NodeMappingType implements IEnumHasCode
{
    All("all", "Select all defined labels (default)"),
    UsingValue("using-value", "Use a field value to select a specific label"),
    AddLabel("add-label", "Add the specified label if a field contains a specific value"),
    First("first", "Select the first label");

    private String code;
    private String description;

    private NodeMappingType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String[] getDescriptions() {
        String[] descriptions = new String[NodeMappingType.values().length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = NodeMappingType.values()[i].getDescription();
        }
        return descriptions;
    }

    public static NodeMappingType getTypeFromDescription(String description) {
        for (NodeMappingType type : NodeMappingType.values()) {
            if (!type.getDescription().equals(description)) continue;
            return type;
        }
        return All;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

