/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.CloudMonitoringMetricsRecorder;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageGrpcTracingInterceptor;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import com.google.cloud.hadoop.gcsio.GrpcRequestTracingInfo;
import com.google.cloud.hadoop.gcsio.MetricsRecorder;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.gcsio.Watchdog;
import com.google.cloud.hadoop.gcsio.ZeroCopyMessageMarshaller;
import com.google.cloud.hadoop.gcsio.ZeroCopyReadinessChecker;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StorageGrpc;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.opencensus.stats.Measure;
import io.opencensus.tags.TagKey;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class GoogleCloudStorageGrpcReadChannel
implements SeekableByteChannel {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    protected static final String METADATA_FIELDS = "contentEncoding,generation,size";
    static final String STATUS_OK = "OK";
    static final String METHOD_GET_OBJECT_METADATA = "getObjectMetadata";
    static final String METHOD_GET_OBJECT_MEDIA = "getObjectMedia";
    static final String PROTOCOL_GRPC = "grpc";
    static final String PROTOCOL_JSON = "json";
    private final Gson gson = new Gson();
    private final ZeroCopyMessageMarshaller<ReadObjectResponse> getObjectMediaResponseMarshaller = new ZeroCopyMessageMarshaller<ReadObjectResponse>(ReadObjectResponse.getDefaultInstance());
    private final MethodDescriptor<ReadObjectRequest, ReadObjectResponse> getObjectMediaMethod = StorageGrpc.getReadObjectMethod().toBuilder().setResponseMarshaller(this.getObjectMediaResponseMarshaller).build();
    private final boolean useZeroCopyMarshaller;
    private final StorageGrpc.StorageBlockingStub stub;
    private final StorageResourceId resourceId;
    private final long objectGeneration;
    private final long objectSize;
    private final MetricsRecorder metricsRecorder;
    private final GoogleCloudStorageOptions storageOptions;
    private boolean channelIsOpen = true;
    private long positionInGrpcStream;
    private long positionForNextRead;
    @Nullable
    private ByteString bufferedContent;
    private int bufferedContentReadOffset;
    @Nullable
    private InputStream streamForBufferedContent;
    @Nullable
    private Iterator<ReadObjectResponse> resIterator;
    private final GoogleCloudStorageReadOptions readOptions;
    private final GoogleCloudStorageImpl.BackOffFactory backOffFactory;
    @Nullable
    Context.CancellableContext requestContext;
    GoogleCloudStorageReadOptions.Fadvise readStrategy;
    private byte[] footerBuffer;
    private final long footerStartOffsetInBytes;
    private long contentChannelEndOffset = -1L;
    private final Watchdog watchdog;
    private final long gRPCReadMessageTimeout;
    private final ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;

    @VisibleForTesting
    GoogleCloudStorageGrpcReadChannel(StorageStubProvider stubProvider, Storage storage, StorageResourceId resourceId, Watchdog watchdog, MetricsRecorder metricsRecorder, GoogleCloudStorageReadOptions readOptions, GoogleCloudStorageImpl.BackOffFactory backOffFactory, GoogleCloudStorageOptions storageOptions) throws IOException {
        Preconditions.checkArgument((storage != null ? 1 : 0) != 0, (Object)"GCS json client cannot be null");
        this.useZeroCopyMarshaller = ZeroCopyReadinessChecker.isReady() && readOptions.isGrpcReadZeroCopyEnabled();
        this.metricsRecorder = metricsRecorder;
        this.storageOptions = storageOptions;
        this.stub = stubProvider.newBlockingStub(resourceId.getBucketName());
        this.backOffFactory = backOffFactory;
        GoogleCloudStorageItemInfo itemInfo = this.getObjectMetadata(resourceId, storage);
        this.validate(itemInfo);
        this.resourceId = itemInfo.getResourceId();
        this.objectGeneration = itemInfo.getContentGeneration();
        this.objectSize = itemInfo.getSize();
        this.watchdog = watchdog;
        this.readOptions = readOptions;
        this.readStrategy = readOptions.getFadvise();
        int prefetchSizeInBytes = readOptions.getMinRangeRequestSize() / 2;
        this.gRPCReadMessageTimeout = readOptions.getGrpcReadMessageTimeoutMillis();
        this.footerStartOffsetInBytes = Math.max(0L, this.objectSize - (long)prefetchSizeInBytes);
    }

    private void validate(GoogleCloudStorageItemInfo itemInfo) throws IOException {
        Preconditions.checkArgument((itemInfo != null ? 1 : 0) != 0, (Object)"object metadata cannot be null");
        StorageResourceId resourceId = itemInfo.getResourceId();
        if (!itemInfo.exists()) {
            throw new FileNotFoundException(String.format("%s not found: %s", itemInfo.isDirectory() ? "Directory" : "File", resourceId));
        }
        String contentEncoding = itemInfo.getContentEncoding();
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            throw new IOException("Cannot read GZIP encoded files - content encoding support is disabled.");
        }
    }

    GoogleCloudStorageGrpcReadChannel(StorageStubProvider stubProvider, GoogleCloudStorageItemInfo itemInfo, Watchdog watchdog, MetricsRecorder metricsRecorder, GoogleCloudStorageReadOptions readOptions, GoogleCloudStorageImpl.BackOffFactory backOffFactory, GoogleCloudStorageOptions storageOptions) throws IOException {
        this.validate(itemInfo);
        this.useZeroCopyMarshaller = ZeroCopyReadinessChecker.isReady() && readOptions.isGrpcReadZeroCopyEnabled();
        this.metricsRecorder = metricsRecorder;
        this.storageOptions = storageOptions;
        this.resourceId = itemInfo.getResourceId();
        this.stub = stubProvider.newBlockingStub(this.resourceId.getBucketName());
        this.objectGeneration = itemInfo.getContentGeneration();
        this.objectSize = itemInfo.getSize();
        this.watchdog = watchdog;
        this.readOptions = readOptions;
        this.backOffFactory = backOffFactory;
        this.readStrategy = readOptions.getFadvise();
        int prefetchSizeInBytes = readOptions.getMinRangeRequestSize() / 2;
        this.gRPCReadMessageTimeout = readOptions.getGrpcReadMessageTimeoutMillis();
        this.footerStartOffsetInBytes = Math.max(0L, this.objectSize - (long)prefetchSizeInBytes);
    }

    private GoogleCloudStorageItemInfo getObjectMetadata(StorageResourceId resourceId, Storage gcs) throws IOException {
        IOException exception;
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = this.backOffFactory.newBackOff();
        do {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                Storage.Objects.Get metadataRequest = GoogleCloudStorageGrpcReadChannel.getMetadataRequest(gcs, resourceId).setFields(METADATA_FIELDS);
                StorageObject object = (StorageObject)metadataRequest.execute();
                this.recordSuccessMetric(CloudMonitoringMetricsRecorder.LATENCY_MS, stopwatch, METHOD_GET_OBJECT_METADATA, PROTOCOL_JSON);
                return GoogleCloudStorageItemInfo.createObject(resourceId, 0L, 0L, ((BigInteger)Preconditions.checkNotNull((Object)object.getSize(), (String)"size can not be null for '%s'", (Object)resourceId)).longValue(), null, object.getContentEncoding(), null, (Long)Preconditions.checkNotNull((Object)object.getGeneration(), (String)"generation can not be null for '%s'", (Object)resourceId), 0L, null);
            }
            catch (IOException ex) {
                this.recordErrorMetric(CloudMonitoringMetricsRecorder.LATENCY_MS, stopwatch, METHOD_GET_OBJECT_METADATA, PROTOCOL_JSON, ex);
                if (RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)ex)) {
                    exception = ex;
                    continue;
                }
                throw this.errorExtractor.itemNotFound(ex) ? GoogleCloudStorageExceptions.createFileNotFoundException(resourceId, ex) : new IOException("Error reading " + resourceId, ex);
            }
            catch (Exception ex) {
                this.recordErrorMetric(CloudMonitoringMetricsRecorder.LATENCY_MS, stopwatch, METHOD_GET_OBJECT_METADATA, PROTOCOL_JSON, ex);
                throw ex;
            }
        } while (this.nextSleep(METHOD_GET_OBJECT_METADATA, sleeper, backoff, exception));
        throw this.errorExtractor.itemNotFound(exception) ? GoogleCloudStorageExceptions.createFileNotFoundException(resourceId, exception) : new IOException("Error reading " + resourceId, exception);
    }

    private void recordGCSAPIDuration(Measure.MeasureLong measure, long time, String status, String method, String protocol) {
        if (this.storageOptions.isTraceLogEnabled()) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("method", method);
            jsonMap.put("status", status);
            jsonMap.put("protocol", protocol);
            jsonMap.put("duration", time);
            jsonMap.put("measure", measure);
            ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)LazyArgs.lazy(() -> this.gson.toJson((Object)jsonMap)));
        }
    }

    private void recordSuccessMetric(Measure.MeasureLong measure, Stopwatch stopwatch, String method, String protocol) {
        long time = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        TagKey[] keys = new TagKey[]{CloudMonitoringMetricsRecorder.METHOD, CloudMonitoringMetricsRecorder.STATUS, CloudMonitoringMetricsRecorder.PROTOCOL};
        String[] values = new String[]{method, STATUS_OK, protocol};
        this.recordGCSAPIDuration(measure, time, STATUS_OK, method, protocol);
        this.metricsRecorder.recordLong(keys, values, measure, time);
    }

    private void recordErrorMetric(Measure.MeasureLong measure, Stopwatch stopwatch, String method, String protocol, Exception e) {
        long time = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        String error = e instanceof StatusRuntimeException ? ((StatusRuntimeException)e).getStatus().toString() : e.getClass().getSimpleName();
        TagKey[] keys = new TagKey[]{CloudMonitoringMetricsRecorder.METHOD, CloudMonitoringMetricsRecorder.STATUS, CloudMonitoringMetricsRecorder.PROTOCOL};
        String[] values = new String[]{method, error, protocol};
        this.recordGCSAPIDuration(measure, time, error, method, protocol);
        this.metricsRecorder.recordLong(keys, values, measure, time);
    }

    private static Storage.Objects.Get getMetadataRequest(Storage gcs, StorageResourceId resourceId) throws IOException {
        Storage.Objects.Get getObject = gcs.objects().get(resourceId.getBucketName(), resourceId.getObjectName());
        if (resourceId.hasGenerationId()) {
            getObject.setGeneration(Long.valueOf(resourceId.getGenerationId()));
        }
        return getObject;
    }

    private byte[] getFooterContent() throws IOException {
        int footerSize = Math.toIntExact(this.objectSize - this.footerStartOffsetInBytes);
        ByteBuffer buffer = ByteBuffer.allocate(footerSize);
        long oldPositionForNextRead = this.positionForNextRead;
        this.positionForNextRead = this.footerStartOffsetInBytes;
        this.readFromGCS(buffer, OptionalLong.empty());
        this.positionForNextRead = oldPositionForNextRead;
        this.cancelCurrentRequest();
        return buffer.array();
    }

    private boolean nextSleep(String method, Sleeper sleeper, BackOff backoff, Exception exception) throws IOException {
        try {
            this.metricsRecorder.recordTaggedStat(CloudMonitoringMetricsRecorder.METHOD, method, CloudMonitoringMetricsRecorder.REQUEST_RETRIES, 1L);
            return ResilientOperation.nextSleep((BackOff)backoff, (Sleeper)sleeper, (Exception)exception);
        }
        catch (InterruptedException e) {
            this.cancelCurrentRequest();
            throw new IOException(e);
        }
    }

    private static IOException convertError(StatusRuntimeException error, StorageResourceId resourceId) {
        String msg = String.format("Error reading '%s'", resourceId);
        switch (Status.fromThrowable((Throwable)error).getCode()) {
            case NOT_FOUND: {
                return GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), new IOException(msg, error));
            }
            case OUT_OF_RANGE: {
                return (IOException)new EOFException(msg).initCause(error);
            }
        }
        return new IOException(msg, error);
    }

    private static void put(ByteString source, int offset, int size, ByteBuffer dest) {
        ByteString croppedSource = source.substring(offset, offset + size);
        for (ByteBuffer sourcePiece : croppedSource.asReadOnlyByteBufferList()) {
            dest.put(sourcePiece);
        }
    }

    private int readBufferedContentInto(ByteBuffer byteBuffer) {
        long bytesToSkip = this.positionForNextRead - this.positionInGrpcStream;
        long bufferSkip = Math.min((long)(this.bufferedContent.size() - this.bufferedContentReadOffset), bytesToSkip);
        bufferSkip = Math.max(0L, bufferSkip);
        this.bufferedContentReadOffset = (int)((long)this.bufferedContentReadOffset + bufferSkip);
        this.positionInGrpcStream += bufferSkip;
        int remainingBufferedBytes = this.bufferedContent.size() - this.bufferedContentReadOffset;
        boolean remainingBufferedContentLargerThanByteBuffer = remainingBufferedBytes > byteBuffer.remaining();
        int bytesToWrite = remainingBufferedContentLargerThanByteBuffer ? byteBuffer.remaining() : remainingBufferedBytes;
        GoogleCloudStorageGrpcReadChannel.put(this.bufferedContent, this.bufferedContentReadOffset, bytesToWrite, byteBuffer);
        this.positionInGrpcStream += (long)bytesToWrite;
        this.positionForNextRead += (long)bytesToWrite;
        if (remainingBufferedContentLargerThanByteBuffer) {
            this.bufferedContentReadOffset += bytesToWrite;
        } else {
            this.invalidateBufferedContent();
        }
        return bytesToWrite;
    }

    private boolean canReadFromExistingRequest(ByteBuffer byteBuffer) {
        if (this.resIterator == null) {
            return false;
        }
        if (this.positionForNextRead < this.positionInGrpcStream) {
            return false;
        }
        if (this.positionForNextRead - this.positionInGrpcStream > this.readOptions.getInplaceSeekLimit()) {
            return false;
        }
        return this.isByteBufferWithinCurrentRequestRange(byteBuffer);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GCS gRPC read request for up to %d bytes at offset %d from object '%s'", (Object)byteBuffer.remaining(), (Object)this.position(), (Object)this.resourceId);
        this.metricsRecorder.recordTaggedStat(CloudMonitoringMetricsRecorder.METHOD, "read", CloudMonitoringMetricsRecorder.REQUESTS, 1L);
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesRead = 0;
        this.updateReadStrategy();
        if (!this.canReadFromExistingRequest(byteBuffer)) {
            this.positionInGrpcStream = this.positionForNextRead;
            this.cancelCurrentRequest();
            this.invalidateBufferedContent();
        }
        if (this.bufferedContent != null) {
            bytesRead += this.readBufferedContentInto(byteBuffer);
            ((GoogleLogger.Api)logger.atFinest()).log("Read with buffered data for %s object, current pos : %d ", (Object)this.resourceId, this.positionInGrpcStream);
        }
        if (!byteBuffer.hasRemaining()) {
            return bytesRead;
        }
        if (this.positionInGrpcStream == this.objectSize) {
            return bytesRead > 0 ? bytesRead : -1;
        }
        if (this.resIterator == null && this.footerBuffer == null && this.positionForNextRead >= this.footerStartOffsetInBytes) {
            this.footerBuffer = this.getFooterContent();
        }
        if (this.footerBuffer == null || this.positionForNextRead < this.footerStartOffsetInBytes) {
            OptionalLong bytesToRead = this.getBytesToRead(byteBuffer);
            bytesRead += this.readFromGCS(byteBuffer, bytesToRead);
            ((GoogleLogger.Api)logger.atFinest()).log("Read from GCS for %s object, current pos : %d ", (Object)this.resourceId, this.positionInGrpcStream);
        }
        if (this.hasMoreFooterContentToRead(byteBuffer)) {
            bytesRead += this.readFooterContentIntoBuffer(byteBuffer);
            ((GoogleLogger.Api)logger.atFinest()).log("Read from footerContent for %s object, current pos : %d ", (Object)this.resourceId, this.positionInGrpcStream);
        }
        return bytesRead;
    }

    private int readFromGCS(ByteBuffer byteBuffer, OptionalLong bytesToRead) throws IOException {
        int read = 0;
        BackOff backoff = this.backOffFactory.newBackOff();
        Sleeper sleeper = Sleeper.DEFAULT;
        while (true) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                if (this.resIterator == null) {
                    this.positionInGrpcStream = this.positionForNextRead;
                    this.resIterator = this.requestObjectMedia(this.resourceId.getObjectName(), this.objectGeneration, this.positionInGrpcStream, bytesToRead);
                    if (bytesToRead.isPresent()) {
                        this.contentChannelEndOffset = this.positionInGrpcStream + bytesToRead.getAsLong();
                    }
                }
                while (byteBuffer.hasRemaining() && this.moreServerContent()) {
                    read += this.readObjectContentFromGCS(byteBuffer);
                }
                this.recordSuccessMetric(CloudMonitoringMetricsRecorder.LATENCY_MS, stopwatch, METHOD_GET_OBJECT_MEDIA, PROTOCOL_GRPC);
                return read;
            }
            catch (StatusRuntimeException e) {
                StatusRuntimeException statusRuntimeException;
                this.cancelCurrentRequest();
                this.recordErrorMetric(CloudMonitoringMetricsRecorder.LATENCY_MS, stopwatch, METHOD_GET_OBJECT_MEDIA, PROTOCOL_GRPC, (Exception)((Object)e));
                if (this.nextSleep(METHOD_GET_OBJECT_MEDIA, sleeper, backoff, (Exception)((Object)(statusRuntimeException = e)))) continue;
                throw GoogleCloudStorageGrpcReadChannel.convertError(statusRuntimeException, this.resourceId);
            }
            break;
        }
    }

    private boolean isByteBufferWithinCurrentRequestRange(ByteBuffer byteBuffer) {
        if (this.contentChannelEndOffset == -1L) {
            return true;
        }
        return this.positionForNextRead + (long)byteBuffer.remaining() <= this.contentChannelEndOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readObjectContentFromGCS(ByteBuffer byteBuffer) throws IOException {
        ReadObjectResponse res = this.resIterator.next();
        try (InputStream stream = this.getObjectMediaResponseMarshaller.popStream(res);){
            ByteString content = res.getChecksummedData().getContent();
            int skipBytes = Math.toIntExact(this.positionForNextRead - this.positionInGrpcStream);
            if (skipBytes >= 0 && skipBytes < content.size()) {
                content = content.substring(skipBytes);
                this.positionInGrpcStream += (long)skipBytes;
            } else if (skipBytes >= content.size()) {
                this.positionInGrpcStream += (long)content.size();
                int n = 0;
                return n;
            }
            if (this.readOptions.isGrpcChecksumsEnabled() && res.getChecksummedData().hasCrc32C()) {
                this.validateChecksum(res);
            }
            boolean responseSizeLargerThanRemainingBuffer = content.size() > byteBuffer.remaining();
            int bytesToWrite = responseSizeLargerThanRemainingBuffer ? byteBuffer.remaining() : content.size();
            GoogleCloudStorageGrpcReadChannel.put(content, 0, bytesToWrite, byteBuffer);
            this.positionInGrpcStream += (long)bytesToWrite;
            this.positionForNextRead += (long)bytesToWrite;
            if (responseSizeLargerThanRemainingBuffer) {
                this.invalidateBufferedContent();
                this.bufferedContent = content;
                this.bufferedContentReadOffset = bytesToWrite;
                this.streamForBufferedContent = stream;
                stream = null;
            }
            int n = bytesToWrite;
            return n;
        }
    }

    private void validateChecksum(ReadObjectResponse res) throws IOException {
        int expectedChecksum;
        int calculatedChecksum = Hashing.crc32c().hashBytes(res.getChecksummedData().getContent().toByteArray()).asInt();
        if (calculatedChecksum != (expectedChecksum = res.getChecksummedData().getCrc32C())) {
            throw new IOException(String.format("Message checksum (%s) didn't match expected checksum (%s) for '%s'", expectedChecksum, calculatedChecksum, this.resourceId));
        }
    }

    private boolean hasMoreFooterContentToRead(ByteBuffer byteBuffer) {
        return this.footerBuffer != null && this.positionForNextRead >= this.footerStartOffsetInBytes && byteBuffer.hasRemaining();
    }

    private OptionalLong getBytesToRead(ByteBuffer byteBuffer) {
        OptionalLong optionalBytesToRead = OptionalLong.empty();
        if (this.readStrategy == GoogleCloudStorageReadOptions.Fadvise.RANDOM) {
            long rangeRequestSize = Math.max(this.readOptions.getInplaceSeekLimit(), (long)this.readOptions.getMinRangeRequestSize());
            optionalBytesToRead = OptionalLong.of(Math.max((long)byteBuffer.remaining(), rangeRequestSize));
        }
        if (this.footerBuffer == null) {
            return optionalBytesToRead;
        }
        long bytesToFooterOffset = this.footerStartOffsetInBytes - this.positionInGrpcStream;
        if (optionalBytesToRead.isPresent()) {
            return OptionalLong.of(Math.min(optionalBytesToRead.getAsLong(), bytesToFooterOffset));
        }
        return OptionalLong.of(bytesToFooterOffset);
    }

    private int readFooterContentIntoBuffer(ByteBuffer byteBuffer) {
        int bytesToSkipFromFooter = Math.toIntExact(this.positionForNextRead - this.footerStartOffsetInBytes);
        int bytesToWriteFromFooter = this.footerBuffer.length - bytesToSkipFromFooter;
        int bytesToWrite = Math.toIntExact(Math.min(byteBuffer.remaining(), bytesToWriteFromFooter));
        byteBuffer.put(this.footerBuffer, bytesToSkipFromFooter, bytesToWrite);
        this.positionForNextRead = this.positionInGrpcStream = this.positionForNextRead + (long)bytesToWrite;
        return bytesToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ReadObjectResponse> requestObjectMedia(String objectName, long objectGeneration, long offset, OptionalLong bytesToRead) throws StatusRuntimeException {
        Iterator<ReadObjectResponse> readObjectResponseIterator;
        ReadObjectRequest.Builder requestBuilder = ReadObjectRequest.newBuilder().setBucket(GrpcChannelUtils.toV2BucketName(this.resourceId.getBucketName())).setObject(objectName).setGeneration(objectGeneration).setReadOffset(offset);
        bytesToRead.ifPresent(arg_0 -> ((ReadObjectRequest.Builder)requestBuilder).setReadLimit(arg_0));
        ReadObjectRequest request = requestBuilder.build();
        this.requestContext = Context.current().withCancellation();
        Context toReattach = this.requestContext.attach();
        StorageGrpc.StorageBlockingStub blockingStub = this.getStubWithDeadlineAndTracing(objectName, objectGeneration, offset, bytesToRead);
        try {
            if (this.useZeroCopyMarshaller) {
                Iterator responseIterator = ClientCalls.blockingServerStreamingCall((Channel)blockingStub.getChannel(), this.getObjectMediaMethod, (CallOptions)blockingStub.getCallOptions(), (Object)request);
                readObjectResponseIterator = this.watchdog.watch(this.requestContext, responseIterator, Duration.ofMillis(this.gRPCReadMessageTimeout));
            } else {
                readObjectResponseIterator = this.watchdog.watch(this.requestContext, blockingStub.readObject(request), Duration.ofMillis(this.gRPCReadMessageTimeout));
            }
        }
        finally {
            this.requestContext.detach(toReattach);
        }
        return readObjectResponseIterator;
    }

    private StorageGrpc.StorageBlockingStub getStubWithDeadlineAndTracing(String objectName, long objectGeneration, long offset, OptionalLong bytesToRead) {
        StorageGrpc.StorageBlockingStub blockingStub = (StorageGrpc.StorageBlockingStub)this.stub.withDeadlineAfter(this.readOptions.getGrpcReadTimeoutMillis(), TimeUnit.MILLISECONDS);
        if (!this.storageOptions.isTraceLogEnabled()) {
            return blockingStub;
        }
        return (StorageGrpc.StorageBlockingStub)blockingStub.withInterceptors(new ClientInterceptor[]{new GoogleCloudStorageGrpcTracingInterceptor(GrpcRequestTracingInfo.getReadRequestTraceInfo(objectName, objectGeneration, offset, bytesToRead))});
    }

    private void cancelCurrentRequest() {
        if (this.requestContext != null) {
            this.requestContext.close();
            this.requestContext = null;
        }
        this.drainIterator();
        this.resIterator = null;
        List<InputStream> unclosedStreams = this.getObjectMediaResponseMarshaller.popAllStreams();
        for (InputStream stream : unclosedStreams) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.contentChannelEndOffset = -1L;
    }

    private void drainIterator() {
        if (this.resIterator == null) {
            return;
        }
        try {
            while (this.resIterator.hasNext()) {
                this.resIterator.next();
            }
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause((Throwable)e)).log("Exception while draining the iteration on cancellation");
        }
    }

    private boolean moreServerContent() {
        boolean moreDataAvailable;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (this.resIterator == null) {
                return false;
            }
            moreDataAvailable = this.resIterator.hasNext();
            this.recordSuccessMetric(CloudMonitoringMetricsRecorder.MESSAGE_LATENCY_MS, stopwatch, METHOD_GET_OBJECT_MEDIA, PROTOCOL_GRPC);
        }
        catch (Exception e) {
            this.recordErrorMetric(CloudMonitoringMetricsRecorder.MESSAGE_LATENCY_MS, stopwatch, METHOD_GET_OBJECT_MEDIA, PROTOCOL_GRPC, e);
            throw e;
        }
        if (!moreDataAvailable) {
            this.cancelCurrentRequest();
        }
        return moreDataAvailable;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Cannot mutate read-only channel: " + this);
    }

    @Override
    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.positionForNextRead;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.metricsRecorder.recordTaggedStat(CloudMonitoringMetricsRecorder.METHOD, "seek", CloudMonitoringMetricsRecorder.REQUESTS, 1L);
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (String)"Read position must be non-negative, but was %s", (long)newPosition);
        Preconditions.checkArgument((newPosition < this.size() ? 1 : 0) != 0, (String)"Read position must be before end of file (%s), but was %s", (long)this.size(), (long)newPosition);
        this.positionForNextRead = newPosition;
        return this;
    }

    private void updateReadStrategy() {
        if (this.readStrategy == GoogleCloudStorageReadOptions.Fadvise.AUTO && (this.positionForNextRead < this.positionInGrpcStream || this.positionForNextRead - this.positionInGrpcStream > this.readOptions.getInplaceSeekLimit())) {
            this.readStrategy = GoogleCloudStorageReadOptions.Fadvise.RANDOM;
        }
    }

    @Override
    public long size() throws IOException {
        this.metricsRecorder.recordTaggedStat(CloudMonitoringMetricsRecorder.METHOD, "size", CloudMonitoringMetricsRecorder.REQUESTS, 1L);
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.objectSize;
    }

    @Override
    public SeekableByteChannel truncate(long l) {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public boolean isOpen() {
        return this.channelIsOpen;
    }

    @Override
    public void close() {
        this.metricsRecorder.recordTaggedStat(CloudMonitoringMetricsRecorder.METHOD, "read_close", CloudMonitoringMetricsRecorder.REQUESTS, 1L);
        this.cancelCurrentRequest();
        this.invalidateBufferedContent();
        this.channelIsOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resourceId", (Object)this.resourceId).add("generation", this.objectGeneration).toString();
    }

    private void invalidateBufferedContent() {
        this.bufferedContent = null;
        this.bufferedContentReadOffset = 0;
        if (this.streamForBufferedContent != null) {
            try {
                this.streamForBufferedContent.close();
                this.streamForBufferedContent = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

