/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.script;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.script.Script;
import org.apache.hop.pipeline.transforms.script.ScriptData;

@Transform(id="SuperScript", image="script.svg", name="Script", description="Executes scripts for JSR-223 Script Engines", categoryDescription="Scripting", keywords={"script,scripting,groovy,python,javascript,ecmascript,ruby"}, documentationUrl="/pipeline/transforms/script.html")
public class ScriptMeta
extends BaseTransformMeta<Script, ScriptData>
implements ITransformMeta {
    private static final Class<?> PKG = ScriptMeta.class;
    @HopMetadataProperty(key="scriptLanguage")
    private String languageName;
    @HopMetadataProperty(groupKey="scripts", key="script")
    private List<SScript> scripts = new ArrayList<SScript>();
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<SField> fields = new ArrayList<SField>();

    public ScriptMeta() {
    }

    public ScriptMeta(ScriptMeta m) {
        this();
        this.languageName = m.languageName;
        m.scripts.forEach(s -> this.scripts.add(new SScript((SScript)s)));
        m.fields.forEach(f -> this.fields.add(new SField((SField)f)));
    }

    public ScriptMeta clone() {
        return new ScriptMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (SField field : this.fields) {
            String fieldName;
            int replaceIndex;
            if (StringUtils.isEmpty((String)field.getName())) continue;
            int fieldType = field.getHopType();
            if (field.isReplace()) {
                if (rowMeta.searchValueMeta(field.getName()) == null && StringUtils.isEmpty((String)field.getRename())) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptMeta.Exception.FieldToReplaceNotFound", (String[])new String[]{field.getName()}));
                }
                replaceIndex = rowMeta.indexOfValue(field.getRename());
                fieldName = field.getRename();
            } else {
                replaceIndex = -1;
                fieldName = StringUtils.isNotEmpty((String)field.getRename()) ? field.getName() : field.getRename();
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)fieldName, (int)fieldType);
                v.setLength(field.getLength());
                v.setPrecision(field.getPrecision());
                v.setOrigin(name);
                if (field.isReplace() && replaceIndex >= 0) {
                    rowMeta.setValueMeta(replaceIndex, v);
                    continue;
                }
                rowMeta.addValueMeta(v);
            }
            catch (HopPluginException e) {
                throw new HopTransformException("Error handling field " + field.getName() + " with Hop data type: " + field.getType(), (Throwable)e);
            }
        }
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public List<SScript> getScripts() {
        return this.scripts;
    }

    public void setScripts(List<SScript> scripts) {
        this.scripts = scripts;
    }

    public List<SField> getFields() {
        return this.fields;
    }

    public void setFields(List<SField> fields) {
        this.fields = fields;
    }

    public static final class SScript {
        @HopMetadataProperty(key="scriptType", storeWithCode=true)
        private ScriptType scriptType;
        @HopMetadataProperty(key="scriptName")
        private String scriptName;
        @HopMetadataProperty(key="scriptBody")
        private String script;

        public SScript() {
            this.scriptType = ScriptType.TRANSFORM_SCRIPT;
            this.scriptName = "script";
        }

        public SScript(ScriptType scriptType, String scriptName, String script) {
            this.scriptType = scriptType;
            this.scriptName = scriptName;
            this.script = script;
        }

        public SScript(SScript s) {
            this();
            this.scriptType = s.scriptType;
            this.scriptName = s.scriptName;
            this.script = s.script;
        }

        public boolean isTransformScript() {
            return this.scriptType == ScriptType.TRANSFORM_SCRIPT;
        }

        public boolean isStartScript() {
            return this.scriptType == ScriptType.START_SCRIPT;
        }

        public boolean isEndScript() {
            return this.scriptType == ScriptType.END_SCRIPT;
        }

        public ScriptType getScriptType() {
            return this.scriptType;
        }

        public void setScriptType(ScriptType scriptType) {
            this.scriptType = scriptType;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }

    public static enum ScriptType implements IEnumHasCodeAndDescription
    {
        NORMAL_SCRIPT("-1", "Normal script"),
        TRANSFORM_SCRIPT("0", "Transform script"),
        START_SCRIPT("1", "Start script"),
        END_SCRIPT("2", "End script");

        private String code;
        private String description;

        private ScriptType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static final class SField {
        @HopMetadataProperty
        private String name;
        @HopMetadataProperty
        private String rename;
        @HopMetadataProperty
        private String type;
        @HopMetadataProperty
        private int length;
        @HopMetadataProperty
        private int precision;
        @HopMetadataProperty
        private boolean replace;
        @HopMetadataProperty
        private boolean scriptResult;

        public SField() {
        }

        public SField(SField f) {
            this();
            this.name = f.name;
            this.rename = f.rename;
            this.type = f.type;
            this.length = f.length;
            this.precision = f.precision;
            this.replace = f.replace;
            this.scriptResult = f.scriptResult;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.type);
        }

        public IValueMeta createHopValue() throws HopPluginException {
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)Const.NVL((String)this.name, (String)this.rename), (int)this.getHopType());
            valueMeta.setLength(this.length);
            valueMeta.setPrecision(this.precision);
            return valueMeta;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRename() {
            return this.rename;
        }

        public void setRename(String rename) {
            this.rename = rename;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public void setReplace(boolean replace) {
            this.replace = replace;
        }

        public boolean isScriptResult() {
            return this.scriptResult;
        }

        public void setScriptResult(boolean scriptResult) {
            this.scriptResult = scriptResult;
        }
    }
}

