/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Shell;

public class CheckPipelineProgressDialog {
    private static final Class<?> PKG = CheckPipelineProgressDialog.class;
    private Shell shell;
    private PipelineMeta pipelineMeta;
    private List<ICheckResult> remarks;
    private boolean onlySelected;
    private IVariables variables;
    private IHopMetadataProvider metadataProvider;

    public CheckPipelineProgressDialog(Shell shell, IVariables variables, PipelineMeta pipelineMeta, List<ICheckResult> remarks, boolean onlySelected) {
        this(shell, pipelineMeta, remarks, onlySelected, variables, (IHopMetadataProvider)HopGui.getInstance().getMetadataProvider());
    }

    public CheckPipelineProgressDialog(Shell shell, PipelineMeta pipelineMeta, List<ICheckResult> remarks, boolean onlySelected, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.shell = shell;
        this.pipelineMeta = pipelineMeta;
        this.onlySelected = onlySelected;
        this.remarks = remarks;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
    }

    public void open() {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
        IRunnableWithProgress op = monitor -> {
            try {
                this.pipelineMeta.checkTransforms(this.remarks, this.onlySelected, (IProgressMonitor)new ProgressMonitorAdapter(monitor), this.variables, this.metadataProvider);
                monitor.done();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.RuntimeError.ErrorCheckingPipeline.Exception", (String[])new String[]{e.toString()}));
            }
        };
        try {
            Runnable run = () -> {
                IProgressMonitor monitor = pmd.getProgressMonitor();
                while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        this.pipelineMeta.cancelQueries();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckPipelineProgressDialog.Dialog.ErrorCheckingPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckPipelineProgressDialog.Dialog.ErrorCheckingPipeline.Message", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckPipelineProgressDialog.Dialog.ErrorCheckingPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckPipelineProgressDialog.Dialog.ErrorCheckingPipeline.Message", (String[])new String[0]), e);
        }
    }
}

