/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transforms.missing;

import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.missing.Missing;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MissingPipelineDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MissingPipelineDialog.class;
    private Shell shell;
    private Shell shellParent;
    private List<Missing> missingPipeline;
    private int mode;
    private String transformResult;
    public static final int MISSING_PIPELINE_TRANSFORMS = 1;
    public static final int MISSING_PIPELINE_TRANSFORM_ID = 2;

    public MissingPipelineDialog(Shell parent, IVariables variables, List<Missing> missingPipeline, ITransformMeta baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, baseTransformMeta, pipelineMeta, transformName);
        this.shellParent = parent;
        this.missingPipeline = missingPipeline;
        this.mode = 1;
    }

    public MissingPipelineDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, transformName);
        this.shellParent = parent;
        this.mode = 2;
    }

    private String getErrorMessage(List<Missing> missingPipeline, int mode) {
        String message = "";
        if (mode == 1) {
            StringBuilder entries = new StringBuilder();
            for (Missing entry : missingPipeline) {
                if (missingPipeline.indexOf(entry) == missingPipeline.size() - 1) {
                    entries.append("- " + entry.getTransformName() + " - " + entry.getMissingPluginId() + "\n\n");
                    continue;
                }
                entries.append("- " + entry.getTransformName() + " - " + entry.getMissingPluginId() + "\n");
            }
            message = BaseMessages.getString(PKG, (String)"MissingPipelineDialog.MissingPipelineTransforms", (String[])new String[]{entries.toString()});
        }
        if (mode == 2) {
            message = BaseMessages.getString(PKG, (String)"MissingPipelineDialog.MissingPipelineTransformId", (String[])new String[]{this.transformName + " - " + ((Missing)this.baseTransformMeta).getMissingPluginId()});
        }
        return message;
    }

    public String open() {
        PropsUi props = PropsUi.getInstance();
        Display display = this.shellParent.getDisplay();
        this.shell = new Shell(this.shellParent, 67681);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginLeft = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setText(BaseMessages.getString(PKG, (String)"MissingPipelineDialog.MissingPlugins", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label image = new Label((Composite)this.shell, 0);
        PropsUi.setLook((Widget)image);
        Image icon = display.getSystemImage(4);
        image.setImage(icon);
        FormData imageData = new FormData();
        imageData.left = new FormAttachment(0, 5);
        imageData.right = new FormAttachment(11, 0);
        imageData.top = new FormAttachment(0, 10);
        image.setLayoutData((Object)imageData);
        Label error = new Label((Composite)this.shell, 64);
        PropsUi.setLook((Widget)error);
        error.setText(this.getErrorMessage(this.missingPipeline, this.mode));
        FormData errorData = new FormData();
        errorData.left = new FormAttachment((Control)image, 5);
        errorData.right = new FormAttachment(100, -5);
        errorData.top = new FormAttachment(0, 10);
        error.setLayoutData((Object)errorData);
        Label separator = new Label((Composite)this.shell, 64);
        PropsUi.setLook((Widget)separator);
        FormData separatorData = new FormData();
        separatorData.top = new FormAttachment((Control)error, 10);
        separator.setLayoutData((Object)separatorData);
        Button closeButton = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)closeButton);
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(98);
        fdClose.top = new FormAttachment((Control)separator);
        closeButton.setLayoutData((Object)fdClose);
        closeButton.setText(BaseMessages.getString(PKG, (String)"MissingPipelineDialog.Close", (String[])new String[0]));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingPipelineDialog.this.cancel();
            }
        });
        FormData fdSearch = new FormData();
        if (this.mode == 1) {
            Button openButton = new Button((Composite)this.shell, 8);
            PropsUi.setLook((Widget)openButton);
            FormData fdOpen = new FormData();
            fdOpen.right = new FormAttachment((Control)closeButton, -5);
            fdOpen.bottom = new FormAttachment((Control)closeButton, 0, 1024);
            openButton.setLayoutData((Object)fdOpen);
            openButton.setText(BaseMessages.getString(PKG, (String)"MissingPipelineDialog.OpenFile", (String[])new String[0]));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MissingPipelineDialog.this.ok();
                }
            });
            fdSearch.right = new FormAttachment((Control)openButton, -5);
            fdSearch.bottom = new FormAttachment((Control)openButton, 0, 1024);
        } else {
            fdSearch.right = new FormAttachment((Control)closeButton, -5);
            fdSearch.bottom = new FormAttachment((Control)closeButton, 0, 1024);
        }
        Button searchButton = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)searchButton);
        searchButton.setText(BaseMessages.getString(PKG, (String)"MissingPipelineDialog.SearchMarketplace", (String[])new String[0]));
        searchButton.setLayoutData((Object)fdSearch);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MissingPipelineDialog.this.shell.dispose();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformResult;
    }

    private void ok() {
        this.shell.dispose();
        this.transformResult = this.transformName;
    }

    private void cancel() {
        this.shell.dispose();
        this.transformResult = null;
    }
}

