/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.AddSheetRequest;
import com.google.api.services.sheets.v4.model.AppendValuesResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ClearValuesResponse;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.SpreadsheetProperties;
import com.google.api.services.sheets.v4.model.UpdateSheetPropertiesRequest;
import com.google.api.services.sheets.v4.model.UpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.http.HttpCredentialsAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsCredentials;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutputData;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutputMeta;

public class GoogleSheetsOutput
extends BaseTransform<GoogleSheetsOutputMeta, GoogleSheetsOutputData> {
    private String spreadsheetID;

    public GoogleSheetsOutput(TransformMeta transformMeta, GoogleSheetsOutputMeta meta, GoogleSheetsOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        Boolean exists = false;
        if (super.init()) {
            try {
                NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
                JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
                String scope = "https://www.googleapis.com/auth/drive";
                HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.resolve(((GoogleSheetsOutputMeta)this.meta).getJsonCredentialPath()), this.resolve(((GoogleSheetsOutputMeta)this.meta).getImpersonation()));
                Drive service = new Drive.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.resolve(((GoogleSheetsOutputMeta)this.meta).getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
                this.spreadsheetID = this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey());
                String q = "mimeType='application/vnd.google-apps.spreadsheet'";
                FileList result = (FileList)service.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ(q).setPageSize(Integer.valueOf(100)).setFields("nextPageToken, files(id, name)").execute();
                List spreadsheets = result.getFiles();
                for (File spreadsheet : spreadsheets) {
                    if (!this.spreadsheetID.equals(spreadsheet.getId())) continue;
                    exists = true;
                    this.log.logBasic("Spreadsheet:" + this.spreadsheetID + " exists");
                }
                boolean worksheetExists = false;
                if (exists.booleanValue()) {
                    ((GoogleSheetsOutputData)this.data).service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.resolve(((GoogleSheetsOutputMeta)this.meta).getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
                    Spreadsheet spreadSheet = (Spreadsheet)((GoogleSheetsOutputData)this.data).service.spreadsheets().get(this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey())).execute();
                    List sheets = spreadSheet.getSheets();
                    for (Sheet sheet : sheets) {
                        if (!sheet.getProperties().getTitle().equals(this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId()))) continue;
                        worksheetExists = true;
                    }
                    if (!worksheetExists) {
                        ArrayList<Request> requests = new ArrayList<Request>();
                        requests.add(new Request().setAddSheet(new AddSheetRequest().setProperties(new SheetProperties().setTitle(this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId())))));
                        BatchUpdateSpreadsheetRequest body = new BatchUpdateSpreadsheetRequest().setRequests(requests);
                        ((GoogleSheetsOutputData)this.data).service.spreadsheets().batchUpdate(this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()), body).execute();
                    }
                }
                if (!exists.booleanValue() && ((GoogleSheetsOutputMeta)this.meta).isCreate().booleanValue()) {
                    if (!((GoogleSheetsOutputMeta)this.meta).isAppend().booleanValue()) {
                        File spreadsheet;
                        scope = "https://www.googleapis.com/auth/spreadsheets";
                        ((GoogleSheetsOutputData)this.data).service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.resolve(((GoogleSheetsOutputMeta)this.meta).getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
                        spreadsheet = new Spreadsheet().setProperties(new SpreadsheetProperties().setTitle(this.spreadsheetID));
                        Sheets.Spreadsheets.Create request = ((GoogleSheetsOutputData)this.data).service.spreadsheets().create((Spreadsheet)spreadsheet);
                        Spreadsheet response = (Spreadsheet)request.execute();
                        this.spreadsheetID = response.getSpreadsheetId();
                        ((GoogleSheetsOutputMeta)this.meta).setSpreadsheetKey(this.spreadsheetID);
                        if (this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId()) != "Sheet1") {
                            SheetProperties title = new SheetProperties().setSheetId(Integer.valueOf(0)).setTitle(this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId()));
                            UpdateSheetPropertiesRequest rename = new UpdateSheetPropertiesRequest().setProperties(title);
                            rename.setFields("title");
                            this.log.logBasic("Changing worksheet title to:" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId()));
                            ArrayList<Request> requests = new ArrayList<Request>();
                            Request request1 = new Request().setUpdateSheetProperties(rename);
                            requests.add(request1);
                            BatchUpdateSpreadsheetRequest requestBody = new BatchUpdateSpreadsheetRequest();
                            requestBody.setRequests(requests);
                            ((GoogleSheetsOutputData)this.data).service.spreadsheets().batchUpdate(this.spreadsheetID, requestBody).execute();
                        }
                    } else {
                        this.log.logError("Append and Create options cannot be activated altogether");
                        return false;
                    }
                    if (this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()) != null && !this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()).isEmpty() || this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()) != null && !this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()).isEmpty()) {
                        String fileId = this.spreadsheetID;
                        JsonBatchCallback<Permission> callback = new JsonBatchCallback<Permission>(){

                            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                                GoogleSheetsOutput.this.log.logError("Failed sharing file" + e.getMessage());
                            }

                            public void onSuccess(Permission permission, HttpHeaders responseHeaders) throws IOException {
                                GoogleSheetsOutput.this.log.logBasic("Shared successfully : Permission ID: " + permission.getId());
                            }
                        };
                        BatchRequest batch = service.batch();
                        if (this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()) != null && !this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()).isEmpty()) {
                            this.log.logBasic("Sharing sheet with:" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()));
                            Permission userPermission = new Permission().setType("user").setRole("writer").setEmailAddress(this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareEmail()));
                            service.permissions().create(fileId, userPermission).setFields("id").queue(batch, (JsonBatchCallback)callback);
                        }
                        if (this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()) != null && !this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()).isEmpty()) {
                            this.log.logBasic("Sharing sheet with domain:" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()));
                            Permission domainPermission = new Permission().setType("domain").setRole("reader").setDomain(this.resolve(((GoogleSheetsOutputMeta)this.meta).getShareDomain()));
                            service.permissions().create(fileId, domainPermission).setFields("id").queue(batch, (JsonBatchCallback)callback);
                        }
                        batch.execute();
                    }
                }
                if (!exists.booleanValue() && !((GoogleSheetsOutputMeta)this.meta).isCreate().booleanValue()) {
                    this.log.logError("File does not Exist");
                    return false;
                }
            }
            catch (Exception e) {
                this.log.logError("Error: for worksheet : " + this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId()) + " in spreadsheet :" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()) + e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean processRow() throws HopException {
        int i;
        ArrayList<String> r;
        Object[] row = this.getRow();
        if (this.first && row != null) {
            this.first = false;
            ((GoogleSheetsOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GoogleSheetsOutputMeta)this.meta).getFields(((GoogleSheetsOutputData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            ((GoogleSheetsOutputData)this.data).rows = new ArrayList<List<Object>>();
            if (((GoogleSheetsOutputMeta)this.meta).isAppend().booleanValue()) {
                this.logBasic("Appending lines so skipping the header");
                ++((GoogleSheetsOutputData)this.data).currentRow;
            } else {
                this.logBasic("Writing header");
                r = new ArrayList();
                for (i = 0; i < ((GoogleSheetsOutputData)this.data).outputRowMeta.size(); ++i) {
                    IValueMeta v = ((GoogleSheetsOutputData)this.data).outputRowMeta.getValueMeta(i);
                    r.add(v.getName());
                }
                ((GoogleSheetsOutputData)this.data).rows.add(r);
                ++((GoogleSheetsOutputData)this.data).currentRow;
            }
        }
        try {
            if (row == null) {
                if (((GoogleSheetsOutputData)this.data).currentRow > 0) {
                    ClearValuesRequest requestBody = new ClearValuesRequest();
                    String range = this.resolve(((GoogleSheetsOutputMeta)this.meta).getWorksheetId());
                    this.logBasic("Clearing range" + range + " in Spreadsheet :" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()));
                    NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
                    JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
                    String scope = "https://www.googleapis.com/auth/spreadsheets";
                    HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.resolve(((GoogleSheetsOutputMeta)this.meta).getJsonCredentialPath()), this.resolve(((GoogleSheetsOutputMeta)this.meta).getImpersonation()));
                    ((GoogleSheetsOutputData)this.data).service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.resolve(((GoogleSheetsOutputMeta)this.meta).getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
                    if (!((GoogleSheetsOutputMeta)this.meta).isAppend().booleanValue()) {
                        Sheets.Spreadsheets.Values.Clear request = ((GoogleSheetsOutputData)this.data).service.spreadsheets().values().clear(this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()), range, requestBody);
                        this.logBasic("Clearing Sheet:" + range + "in Spreadsheet :" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()));
                        if (request != null) {
                            ClearValuesResponse clearValuesResponse = (ClearValuesResponse)request.execute();
                        } else {
                            this.logBasic("Nothing to clear");
                        }
                        this.logBasic("Writing to Sheet");
                        ValueRange body = new ValueRange().setValues(((GoogleSheetsOutputData)this.data).rows);
                        String valueInputOption = "USER_ENTERED";
                        UpdateValuesResponse updateValuesResponse = (UpdateValuesResponse)((GoogleSheetsOutputData)this.data).service.spreadsheets().values().update(this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()), range, body).setValueInputOption(valueInputOption).execute();
                    } else {
                        String valueInputOption = "USER_ENTERED";
                        String insertDataOption = "INSERT_ROWS";
                        ValueRange body = new ValueRange().setValues(((GoogleSheetsOutputData)this.data).rows);
                        this.logBasic("Appending data :" + range + "in Spreadsheet :" + this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()));
                        Sheets.Spreadsheets.Values.Append request = ((GoogleSheetsOutputData)this.data).service.spreadsheets().values().append(this.resolve(((GoogleSheetsOutputMeta)this.meta).getSpreadsheetKey()), range, body);
                        request.setValueInputOption(valueInputOption);
                        request.setInsertDataOption(insertDataOption);
                        AppendValuesResponse appendValuesResponse = (AppendValuesResponse)request.execute();
                    }
                } else {
                    this.logBasic("No data found");
                }
                this.setOutputDone();
                boolean requestBody = false;
                return requestBody;
            }
            r = new ArrayList<String>();
            for (i = 0; i < ((GoogleSheetsOutputData)this.data).outputRowMeta.size(); ++i) {
                int length = row.length;
                if (i < length && row[i] != null) {
                    r.add(row[i].toString());
                    continue;
                }
                r.add("");
            }
            ((GoogleSheetsOutputData)this.data).rows.add(r);
            this.putRow(((GoogleSheetsOutputData)this.data).outputRowMeta, row);
        }
        catch (Exception e) {
            throw new HopException(e.getMessage());
        }
        finally {
            ++((GoogleSheetsOutputData)this.data).currentRow;
        }
        return true;
    }
}

