/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.auth.http.HttpCredentialsAdapter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsCredentials;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GoogleSheetsOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GoogleSheetsOutputMeta.class;
    private final GoogleSheetsOutputMeta meta;
    private Label wlTestServiceAccountInfo;
    private TextVar wPrivateKeyStore;
    private TextVar wSpreadsheetKey;
    private TextVar wWorksheetId;
    private TextVar wShareEmail;
    private TextVar wShareDomainWise;
    private Button wbCreate;
    private Button wbAppend;
    private TextVar wTimeout;
    private TextVar wImpersonation;
    private TextVar wAppName;

    public GoogleSheetsOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String name) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, name);
        this.meta = (GoogleSheetsOutputMeta)((Object)in);
    }

    private static HttpRequestInitializer setHttpTimeout(final HttpRequestInitializer requestInitializer, final String timeout) {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                requestInitializer.initialize(httpRequest);
                Integer TO = 5;
                if (!timeout.isEmpty()) {
                    TO = Integer.parseInt(timeout);
                }
                httpRequest.setConnectTimeout(TO * 60000);
                httpRequest.setReadTimeout(TO * 60000);
            }
        };
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutput.transform.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutput.transform.Name", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)tabFolder, (int)4);
        tabFolder.setSimple(false);
        CTabItem serviceAccountTab = new CTabItem(tabFolder, 0);
        serviceAccountTab.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Tab.ServiceAccount", (String[])new String[0]));
        Composite serviceAccountComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)serviceAccountComposite);
        FormLayout serviceAccountLayout = new FormLayout();
        serviceAccountLayout.marginWidth = 3;
        serviceAccountLayout.marginHeight = 3;
        serviceAccountComposite.setLayout((Layout)serviceAccountLayout);
        Label wlPrivateKey = new Label(serviceAccountComposite, 131072);
        wlPrivateKey.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.PrivateKeyStore", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrivateKey);
        FormData fdlPrivateKey = new FormData();
        fdlPrivateKey.top = new FormAttachment(0, margin);
        fdlPrivateKey.left = new FormAttachment(0, 0);
        fdlPrivateKey.right = new FormAttachment(middle, -margin);
        wlPrivateKey.setLayoutData((Object)fdlPrivateKey);
        Button wbPrivateKey = new Button(serviceAccountComposite, 0x1000008);
        PropsUi.setLook((Widget)wbPrivateKey);
        wbPrivateKey.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbPrivateKey = new FormData();
        fdbPrivateKey.top = new FormAttachment(0, margin);
        fdbPrivateKey.right = new FormAttachment(100, 0);
        wbPrivateKey.setLayoutData((Object)fdbPrivateKey);
        wbPrivateKey.addListener(13, e -> this.selectPrivateKeyFile());
        this.wPrivateKeyStore = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wPrivateKeyStore);
        FormData fdPrivateKey = new FormData();
        fdPrivateKey.top = new FormAttachment(0, margin);
        fdPrivateKey.left = new FormAttachment(middle, 0);
        fdPrivateKey.right = new FormAttachment((Control)wbPrivateKey, -margin);
        this.wPrivateKeyStore.setLayoutData((Object)fdPrivateKey);
        Label appNameLabel = new Label(serviceAccountComposite, 131072);
        appNameLabel.setText("Google Application Name :");
        PropsUi.setLook((Widget)appNameLabel);
        FormData appNameLabelForm = new FormData();
        appNameLabelForm.top = new FormAttachment((Control)wbPrivateKey, margin);
        appNameLabelForm.left = new FormAttachment(0, 0);
        appNameLabelForm.right = new FormAttachment(middle, -margin);
        appNameLabel.setLayoutData((Object)appNameLabelForm);
        this.wAppName = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wAppName);
        FormData appNameData = new FormData();
        appNameData.top = new FormAttachment((Control)wbPrivateKey, margin);
        appNameData.left = new FormAttachment(middle, 0);
        appNameData.right = new FormAttachment((Control)wbPrivateKey, -margin);
        this.wAppName.setLayoutData((Object)appNameData);
        Label timeoutLabel = new Label(serviceAccountComposite, 131072);
        timeoutLabel.setText("Time out in minutes :");
        PropsUi.setLook((Widget)timeoutLabel);
        FormData timeoutLabelForm = new FormData();
        timeoutLabelForm.top = new FormAttachment((Control)appNameLabel, margin);
        timeoutLabelForm.left = new FormAttachment(0, 0);
        timeoutLabelForm.right = new FormAttachment(middle, -margin);
        timeoutLabel.setLayoutData((Object)timeoutLabelForm);
        this.wTimeout = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wTimeout);
        FormData timeoutData = new FormData();
        timeoutData.top = new FormAttachment((Control)appNameLabel, margin);
        timeoutData.left = new FormAttachment(middle, 0);
        timeoutData.right = new FormAttachment((Control)wbPrivateKey, -margin);
        this.wTimeout.setLayoutData((Object)timeoutData);
        Label impersonationLabel = new Label(serviceAccountComposite, 131072);
        impersonationLabel.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutputDialog.ImpersonationAccount", (String[])new String[0]));
        PropsUi.setLook((Widget)impersonationLabel);
        FormData impersonationLabelForm = new FormData();
        impersonationLabelForm.top = new FormAttachment((Control)this.wTimeout, margin);
        impersonationLabelForm.left = new FormAttachment(0, 0);
        impersonationLabelForm.right = new FormAttachment(middle, -margin);
        impersonationLabel.setLayoutData((Object)impersonationLabelForm);
        this.wImpersonation = new TextVar(this.variables, serviceAccountComposite, 18436);
        PropsUi.setLook((Widget)this.wImpersonation);
        FormData impersonationData = new FormData();
        impersonationData.top = new FormAttachment((Control)this.wTimeout, margin);
        impersonationData.left = new FormAttachment(middle, 0);
        impersonationData.right = new FormAttachment((Control)wbPrivateKey, -margin);
        this.wImpersonation.setLayoutData((Object)impersonationData);
        Button wbTestServiceAccount = new Button(serviceAccountComposite, 0x1000008);
        PropsUi.setLook((Widget)wbTestServiceAccount);
        wbTestServiceAccount.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Button.TestConnection", (String[])new String[0]));
        FormData fdbTestServiceAccount = new FormData();
        fdbTestServiceAccount.top = new FormAttachment((Control)this.wImpersonation, margin);
        fdbTestServiceAccount.left = new FormAttachment(0, 0);
        wbTestServiceAccount.setLayoutData((Object)fdbTestServiceAccount);
        wbTestServiceAccount.addListener(13, e -> this.testServiceAccount());
        this.wlTestServiceAccountInfo = new Label(serviceAccountComposite, 16384);
        PropsUi.setLook((Widget)this.wlTestServiceAccountInfo);
        FormData fdTestServiceAccountInfo = new FormData();
        fdTestServiceAccountInfo.top = new FormAttachment((Control)this.wImpersonation, margin);
        fdTestServiceAccountInfo.left = new FormAttachment(middle, 0);
        fdTestServiceAccountInfo.right = new FormAttachment(100, 0);
        this.wlTestServiceAccountInfo.setLayoutData((Object)fdTestServiceAccountInfo);
        FormData fdServiceAccountComposite = new FormData();
        fdServiceAccountComposite.left = new FormAttachment(0, 0);
        fdServiceAccountComposite.top = new FormAttachment(0, 0);
        fdServiceAccountComposite.right = new FormAttachment(100, 0);
        fdServiceAccountComposite.bottom = new FormAttachment(100, 0);
        serviceAccountComposite.setLayoutData((Object)fdServiceAccountComposite);
        serviceAccountComposite.layout();
        serviceAccountTab.setControl((Control)serviceAccountComposite);
        CTabItem spreadsheetTab = new CTabItem(tabFolder, 0);
        spreadsheetTab.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.Tab.Spreadsheet", (String[])new String[0]));
        Composite spreadsheetComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)spreadsheetComposite);
        FormLayout spreadsheetLayout = new FormLayout();
        spreadsheetLayout.marginWidth = 3;
        spreadsheetLayout.marginHeight = 3;
        spreadsheetComposite.setLayout((Layout)spreadsheetLayout);
        Label wlSpreadsheetKey = new Label(spreadsheetComposite, 131072);
        wlSpreadsheetKey.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.SpreadsheetKey", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpreadsheetKey);
        FormData fdlSpreadsheetKey = new FormData();
        fdlSpreadsheetKey.top = new FormAttachment(0, margin);
        fdlSpreadsheetKey.left = new FormAttachment(0, 0);
        fdlSpreadsheetKey.right = new FormAttachment(middle, -margin);
        wlSpreadsheetKey.setLayoutData((Object)fdlSpreadsheetKey);
        Button wbSpreadsheetKey = new Button(spreadsheetComposite, 0x1000008);
        wbSpreadsheetKey.setText(BaseMessages.getString((String)"System.Button.Browse"));
        PropsUi.setLook((Widget)wbSpreadsheetKey);
        FormData fdbSpreadsheetKey = new FormData();
        fdbSpreadsheetKey.top = new FormAttachment(0, margin);
        fdbSpreadsheetKey.right = new FormAttachment(100, 0);
        wbSpreadsheetKey.setLayoutData((Object)fdbSpreadsheetKey);
        wbSpreadsheetKey.addListener(13, e -> this.selectSpreadSheetKey());
        this.wSpreadsheetKey = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wSpreadsheetKey);
        FormData fdSpreadsheetKey = new FormData();
        fdSpreadsheetKey.top = new FormAttachment(0, margin);
        fdSpreadsheetKey.left = new FormAttachment(middle, 0);
        fdSpreadsheetKey.right = new FormAttachment((Control)wbSpreadsheetKey, -margin);
        this.wSpreadsheetKey.setLayoutData((Object)fdSpreadsheetKey);
        Label wlWorksheetId = new Label(spreadsheetComposite, 131072);
        wlWorksheetId.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsDialog.WorksheetId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorksheetId);
        FormData fdlWorksheetId = new FormData();
        fdlWorksheetId.top = new FormAttachment((Control)wbSpreadsheetKey, margin);
        fdlWorksheetId.left = new FormAttachment(0, 0);
        fdlWorksheetId.right = new FormAttachment(middle, -margin);
        wlWorksheetId.setLayoutData((Object)fdlWorksheetId);
        Button wbWorksheetId = new Button(spreadsheetComposite, 0x1000008);
        wbWorksheetId.setText(BaseMessages.getString((String)"System.Button.Browse"));
        PropsUi.setLook((Widget)wbWorksheetId);
        FormData fdbWorksheetId = new FormData();
        fdbWorksheetId.top = new FormAttachment((Control)wbSpreadsheetKey, margin);
        fdbWorksheetId.right = new FormAttachment(100, 0);
        wbWorksheetId.setLayoutData((Object)fdbWorksheetId);
        wbWorksheetId.addListener(13, e -> this.selectWorksheet());
        this.wWorksheetId = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wWorksheetId);
        FormData fdWorksheetId = new FormData();
        fdWorksheetId.top = new FormAttachment((Control)wbSpreadsheetKey, margin);
        fdWorksheetId.left = new FormAttachment(middle, 0);
        fdWorksheetId.right = new FormAttachment((Control)wbWorksheetId, -margin);
        this.wWorksheetId.setLayoutData((Object)fdWorksheetId);
        Label wlAppend = new Label(spreadsheetComposite, 131072);
        wlAppend.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutputDialog.Append.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAppend);
        FormData fdlAppend = new FormData();
        fdlAppend.top = new FormAttachment((Control)wbWorksheetId, margin);
        fdlAppend.left = new FormAttachment(0, 0);
        fdlAppend.right = new FormAttachment(middle, -margin);
        wlAppend.setLayoutData((Object)fdlAppend);
        this.wbAppend = new Button(spreadsheetComposite, 32);
        PropsUi.setLook((Widget)this.wbAppend);
        FormData fdbAppend = new FormData();
        fdbAppend.top = new FormAttachment((Control)wlAppend, 0, 0x1000000);
        fdbAppend.left = new FormAttachment(middle, 0);
        fdbAppend.right = new FormAttachment(100, 0);
        this.wbAppend.setLayoutData((Object)fdbAppend);
        Label wlCreate = new Label(spreadsheetComposite, 131072);
        wlCreate.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutputDialog.Create.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreate);
        FormData fdlCreate = new FormData();
        fdlCreate.top = new FormAttachment((Control)wlAppend, 2 * margin);
        fdlCreate.left = new FormAttachment(0, 0);
        fdlCreate.right = new FormAttachment(middle, -margin);
        wlCreate.setLayoutData((Object)fdlCreate);
        this.wbCreate = new Button(spreadsheetComposite, 32);
        PropsUi.setLook((Widget)this.wbCreate);
        FormData fdbCreate = new FormData();
        fdbCreate.top = new FormAttachment((Control)wlCreate, 0, 0x1000000);
        fdbCreate.left = new FormAttachment(middle, 0);
        fdbCreate.right = new FormAttachment(100, 0);
        this.wbCreate.setLayoutData((Object)fdbCreate);
        Label wlShare = new Label(spreadsheetComposite, 131072);
        wlShare.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutputDialog.Share.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShare);
        FormData fdlShare = new FormData();
        fdlShare.top = new FormAttachment((Control)wlCreate, 2 * margin);
        fdlShare.left = new FormAttachment(0, 0);
        fdlShare.right = new FormAttachment(middle, -margin);
        wlShare.setLayoutData((Object)fdlShare);
        this.wShareEmail = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wShareEmail);
        FormData fdShare = new FormData();
        fdShare.top = new FormAttachment((Control)wlShare, 0, 0x1000000);
        fdShare.left = new FormAttachment(middle, 0);
        fdShare.right = new FormAttachment(100, 0);
        this.wShareEmail.setLayoutData((Object)fdShare);
        Label wlShareDomainWise = new Label(spreadsheetComposite, 131072);
        wlShareDomainWise.setText(BaseMessages.getString(PKG, (String)"GoogleSheetsOutputDialog.Share.LabelDW", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShareDomainWise);
        FormData fdlShareDomainWise = new FormData();
        fdlShareDomainWise.top = new FormAttachment((Control)this.wShareEmail, margin);
        fdlShareDomainWise.left = new FormAttachment(0, 0);
        fdlShareDomainWise.right = new FormAttachment(middle, -margin);
        wlShareDomainWise.setLayoutData((Object)fdlShareDomainWise);
        this.wShareDomainWise = new TextVar(this.variables, spreadsheetComposite, 18436);
        PropsUi.setLook((Widget)this.wShareDomainWise);
        FormData fdShareDomainWise = new FormData();
        fdShareDomainWise.top = new FormAttachment((Control)this.wShareEmail, margin);
        fdShareDomainWise.left = new FormAttachment(middle, 0);
        fdShareDomainWise.right = new FormAttachment(100, 0);
        this.wShareDomainWise.setLayoutData((Object)fdShareDomainWise);
        FormData spreadsheetCompositeData = new FormData();
        spreadsheetCompositeData.left = new FormAttachment(0, 0);
        spreadsheetCompositeData.top = new FormAttachment(0, 0);
        spreadsheetCompositeData.right = new FormAttachment(100, 0);
        spreadsheetCompositeData.bottom = new FormAttachment(100, 0);
        spreadsheetComposite.setLayoutData((Object)spreadsheetCompositeData);
        spreadsheetComposite.layout();
        spreadsheetTab.setControl((Control)spreadsheetComposite);
        FormData tabFolderData = new FormData();
        tabFolderData.left = new FormAttachment(0, 0);
        tabFolderData.top = new FormAttachment((Control)this.wTransformName, margin);
        tabFolderData.right = new FormAttachment(100, 0);
        tabFolderData.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        tabFolder.setLayoutData((Object)tabFolderData);
        tabFolder.setSelection(0);
        this.getData(this.meta);
        this.meta.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void selectWorksheet() {
        try {
            String s;
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            Sheets service = new Sheets.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            Spreadsheet response1 = (Spreadsheet)service.spreadsheets().get(this.wSpreadsheetKey.getText()).setIncludeGridData(Boolean.valueOf(false)).execute();
            List worksheets = response1.getSheets();
            String[] names = new String[worksheets.size()];
            int selectedSheet = -1;
            for (int i = 0; i < worksheets.size(); ++i) {
                Sheet sheet = (Sheet)worksheets.get(i);
                names[i] = sheet.getProperties().getTitle();
                if (!sheet.getProperties().getTitle().endsWith("/" + this.wWorksheetId.getText())) continue;
                selectedSheet = i;
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, names, "Worksheets", "Select a Worksheet.");
            if (selectedSheet > -1) {
                esd.setSelectedNrs(new int[]{selectedSheet});
            }
            if ((s = esd.open()) != null) {
                if (esd.getSelectionIndeces().length > 0) {
                    selectedSheet = esd.getSelectionIndeces()[0];
                    Sheet sheet = (Sheet)worksheets.get(selectedSheet);
                    String id = sheet.getProperties().getTitle();
                    this.wWorksheetId.setText(id.substring(id.lastIndexOf("/") + 1));
                } else {
                    this.wWorksheetId.setText("");
                }
            }
        }
        catch (Exception err) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), err.getMessage(), err);
        }
    }

    private void selectSpreadSheetKey() {
        try {
            String s;
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/drive";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            Drive service = new Drive.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            FileList result = (FileList)service.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ("mimeType='application/vnd.google-apps.spreadsheet'").setPageSize(Integer.valueOf(100)).setFields("nextPageToken, files(id, name)").execute();
            List spreadsheets = result.getFiles();
            int selectedSpreadsheet = -1;
            int i = 0;
            String[] titles = new String[spreadsheets.size()];
            for (File spreadsheet : spreadsheets) {
                titles[i] = spreadsheet.getName() + " - " + spreadsheet.getId();
                if (spreadsheet.getId().equals(this.wSpreadsheetKey.getText())) {
                    selectedSpreadsheet = i;
                }
                ++i;
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, titles, "Spreadsheets", "Select a Spreadsheet.");
            if (selectedSpreadsheet > -1) {
                esd.setSelectedNrs(new int[]{selectedSpreadsheet});
            }
            if ((s = esd.open()) != null) {
                if (esd.getSelectionIndeces().length > 0) {
                    selectedSpreadsheet = esd.getSelectionIndeces()[0];
                    File spreadsheet = (File)spreadsheets.get(selectedSpreadsheet);
                    this.wSpreadsheetKey.setText(spreadsheet.getId());
                } else {
                    this.wSpreadsheetKey.setText("");
                }
            }
        }
        catch (Exception err) {
            new ErrorDialog(this.shell, "System.Dialog.Error.Title", err.getMessage(), err);
        }
    }

    private void testServiceAccount() {
        try {
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
            String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
            HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.variables.resolve(this.meta.getJsonCredentialPath()), this.variables.resolve(this.meta.getImpersonation()));
            new Drive.Builder((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.variables.resolve(this.meta.getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
            this.wlTestServiceAccountInfo.setText("Google Drive API : Success!");
        }
        catch (Exception error) {
            this.wlTestServiceAccountInfo.setText("Connection Failed");
        }
    }

    private void selectPrivateKeyFile() {
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (String[])new String[]{"*json", "*"}, (String[])new String[]{"credential JSON file", "All Files"}, (boolean)true);
        if (filename != null) {
            this.wPrivateKeyStore.setText(filename);
            this.meta.setChanged();
        }
    }

    private void getData(GoogleSheetsOutputMeta meta) {
        this.wTransformName.selectAll();
        if (!StringUtils.isEmpty((String)meta.getSpreadsheetKey())) {
            this.wSpreadsheetKey.setText(meta.getSpreadsheetKey());
        }
        if (!StringUtils.isEmpty((String)meta.getWorksheetId())) {
            this.wWorksheetId.setText(meta.getWorksheetId());
        }
        if (!StringUtils.isEmpty((String)meta.getShareEmail())) {
            this.wShareEmail.setText(meta.getShareEmail());
        }
        if (!StringUtils.isEmpty((String)meta.getTimeout())) {
            this.wTimeout.setText(meta.getTimeout());
        }
        if (!StringUtils.isEmpty((String)meta.getImpersonation())) {
            this.wImpersonation.setText(meta.getImpersonation());
        }
        if (!StringUtils.isEmpty((String)meta.getAppName())) {
            this.wAppName.setText(meta.getAppName());
        }
        if (!StringUtils.isEmpty((String)meta.getShareDomain())) {
            this.wShareDomainWise.setText(meta.getShareDomain());
        }
        if (!StringUtils.isEmpty((String)meta.getJsonCredentialPath())) {
            this.wPrivateKeyStore.setText(meta.getJsonCredentialPath());
        }
        this.wbCreate.setSelection(meta.isCreate().booleanValue());
        this.wbAppend.setSelection(meta.isAppend().booleanValue());
    }

    private void setData(GoogleSheetsOutputMeta meta) {
        meta.setJsonCredentialPath(this.wPrivateKeyStore.getText());
        meta.setSpreadsheetKey(this.wSpreadsheetKey.getText());
        meta.setWorksheetId(this.wWorksheetId.getText());
        meta.setShareEmail(this.wShareEmail.getText());
        meta.setCreate(this.wbCreate.getSelection());
        meta.setAppend(this.wbAppend.getSelection());
        meta.setShareDomain(this.wShareDomainWise.getText());
        meta.setTimeout(this.wTimeout.getText());
        meta.setAppName(this.wAppName.getText());
        meta.setImpersonation(this.wImpersonation.getText());
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.setData(this.meta);
        this.meta.setChanged();
        this.dispose();
    }
}

