/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.jdbc.ClickHouseResultSet;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class ClickHouseArray
implements Array {
    private final int columnIndex;
    private ClickHouseResultSet resultSet;

    protected ClickHouseArray(ClickHouseResultSet resultSet, int columnIndex) throws SQLException {
        this.resultSet = ClickHouseChecker.nonNull(resultSet, "ResultSet");
        resultSet.ensureRead(columnIndex);
        this.columnIndex = columnIndex;
    }

    protected void ensureValid() throws SQLException {
        if (this.resultSet == null) {
            throw SqlExceptionUtils.clientError("Cannot operate on a freed Array object");
        }
    }

    protected ClickHouseColumn getBaseColumn() {
        return this.resultSet.columns.get(this.columnIndex - 1).getArrayBaseColumn();
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.ensureValid();
        return this.getBaseColumn().getDataType().name();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.ensureValid();
        return this.resultSet.mapper.toSqlType(this.getBaseColumn(), this.resultSet.defaultTypeMap);
    }

    @Override
    public Object getArray() throws SQLException {
        this.ensureValid();
        return this.resultSet.getValue(this.columnIndex).asObject();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.ensureValid();
        throw SqlExceptionUtils.unsupportedError("getArray not implemented");
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.ensureValid();
        throw SqlExceptionUtils.unsupportedError("getResultSet not implemented");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public void free() throws SQLException {
        this.resultSet = null;
    }
}

