/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface AsyncTransactionManager
extends AutoCloseable {
    public TransactionContextFuture beginAsync();

    public ApiFuture<Void> rollbackAsync();

    public TransactionContextFuture resetForRetryAsync();

    public TransactionManager.TransactionState getState();

    public ApiFuture<CommitResponse> getCommitResponse();

    @Override
    public void close();

    public ApiFuture<Void> closeAsync();

    public static interface AsyncTransactionFunction<I, O> {
        public ApiFuture<O> apply(TransactionContext var1, I var2) throws Exception;
    }

    public static interface AsyncTransactionStep<I, O>
    extends ApiFuture<O> {
        public <RES> AsyncTransactionStep<O, RES> then(AsyncTransactionFunction<O, RES> var1, Executor var2);

        public CommitTimestampFuture commitAsync();
    }

    public static interface CommitTimestampFuture
    extends ApiFuture<Timestamp> {
        public Timestamp get() throws AbortedException, InterruptedException, ExecutionException;

        public Timestamp get(long var1, TimeUnit var3) throws AbortedException, InterruptedException, ExecutionException, TimeoutException;
    }

    public static interface TransactionContextFuture
    extends ApiFuture<TransactionContext> {
        public <O> AsyncTransactionStep<Void, O> then(AsyncTransactionFunction<Void, O> var1, Executor var2);
    }
}

