/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;
import com.google.spanner.v1.PartitionOptions;
import java.io.Serializable;
import java.util.Objects;

public class PartitionOptions
implements Serializable {
    private static final long serialVersionUID = 8067099123096783931L;
    private final long partitionSizeBytes;
    private final long maxPartitions;

    private PartitionOptions(Builder builder) {
        this.partitionSizeBytes = builder.partitionSizeBytes;
        this.maxPartitions = builder.maxPartitions;
    }

    public static PartitionOptions getDefaultInstance() {
        return PartitionOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getPartitionSizeBytes() {
        return this.partitionSizeBytes;
    }

    public long getMaxPartitions() {
        return this.maxPartitions;
    }

    void appendToProto(PartitionOptions.Builder proto) {
        if (this.partitionSizeBytes > 0L) {
            proto.setPartitionSizeBytes(this.partitionSizeBytes);
        }
        if (this.maxPartitions > 0L) {
            proto.setMaxPartitions(this.maxPartitions);
        }
    }

    public String toString() {
        return String.format("partitionSizeBytes: %s, maxPartitions: %s", this.getPartitionSizeBytes(), this.getMaxPartitions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionOptions that = (PartitionOptions)o;
        return Objects.equals(this.getMaxPartitions(), that.getMaxPartitions()) && Objects.equals(this.getPartitionSizeBytes(), that.getPartitionSizeBytes());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxPartitions(), this.getPartitionSizeBytes());
    }

    public static class Builder {
        private long partitionSizeBytes;
        private long maxPartitions;

        private Builder() {
        }

        public Builder setPartitionSizeBytes(long partitionSizeBytes) {
            Preconditions.checkArgument((partitionSizeBytes > 0L ? 1 : 0) != 0, (Object)("Invalid partitionSizeBytes: " + partitionSizeBytes));
            this.partitionSizeBytes = partitionSizeBytes;
            return this;
        }

        public Builder setMaxPartitions(long maxPartitions) {
            Preconditions.checkArgument((maxPartitions > 0L ? 1 : 0) != 0, (Object)("Invalid maxPartitions: " + maxPartitions));
            this.maxPartitions = maxPartitions;
            return this;
        }

        public PartitionOptions build() {
            return new PartitionOptions(this);
        }
    }
}

