/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.regex.Matcher;

class ClientSideStatementRunPartitionExecutor
implements ClientSideStatementExecutor {
    private final ClientSideStatementImpl statement;
    private final Method method;

    ClientSideStatementRunPartitionExecutor(ClientSideStatementImpl statement) throws ClientSideStatementImpl.CompileException {
        try {
            this.statement = statement;
            this.method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), String.class);
        }
        catch (Exception e) {
            throw new ClientSideStatementImpl.CompileException(e, statement);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, AbstractStatementParser.ParsedStatement parsedStatement) throws Exception {
        String partitionId = this.getParameterValue(parsedStatement);
        if (partitionId == null) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "No valid partition id found in statement: " + parsedStatement.getStatement().getSql());
        }
        return (StatementResult)this.method.invoke((Object)connection, partitionId);
    }

    String getParameterValue(AbstractStatementParser.ParsedStatement parsedStatement) {
        Object value;
        Matcher matcher = this.statement.getPattern().matcher(parsedStatement.getSqlWithoutComments());
        if (matcher.find() && matcher.groupCount() >= 1 && !Strings.isNullOrEmpty((String)(value = matcher.group(1)))) {
            return value;
        }
        if (parsedStatement.getStatement().getParameters().size() == 1) {
            value = parsedStatement.getStatement().getParameters().values().iterator().next();
            return ((Value)value).getAsString();
        }
        return null;
    }
}

