/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sql.ExecSqlArgumentItem;
import org.apache.hop.pipeline.transforms.sql.ExecSqlMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecSqlDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ExecSqlMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private StyledTextComp wSql;
    private Button wEachRow;
    private Label wlSetParams;
    private Button wSetParams;
    private Button wSingleStatement;
    private Text wInsertField;
    private Text wUpdateField;
    private Text wDeleteField;
    private Text wReadField;
    private Label wlFields;
    private TableView wFields;
    private Button wVariables;
    private Label wlQuoteString;
    private Button wQuoteString;
    private final ExecSqlMeta input;
    private boolean changedInDialog;
    private Label wlPosition;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;

    public ExecSqlDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ExecSqlMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> {
            this.changedInDialog = true;
            this.input.setChanged();
        };
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        ExecSqlDialog execSqlDialog = this;
        int margin = execSqlDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlDialog.this.input.setChanged();
            }
        };
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSql = new Label((Composite)this.shell, 16384);
        wlSql.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.SQL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment(this.wConnection, margin * 2);
        wlSql.setLayoutData((Object)fdlSql);
        this.wSql = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        PropsUi.setLook((Widget)this.wSql, (int)1);
        this.wSql.addModifyListener(lsMod);
        this.wSql.addModifyListener(arg0 -> this.setPosition());
        this.wSql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ExecSqlDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ExecSqlDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ExecSqlDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ExecSqlDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ExecSqlDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ExecSqlDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ExecSqlDialog.this.setPosition();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlReadField = new Label((Composite)this.shell, 131072);
        wlReadField.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.ReadField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReadField);
        FormData fdlReadField = new FormData();
        fdlReadField.left = new FormAttachment(middle, margin);
        fdlReadField.right = new FormAttachment(middle * 2, -margin);
        fdlReadField.bottom = new FormAttachment((Control)this.wOk, -3 * margin);
        wlReadField.setLayoutData((Object)fdlReadField);
        this.wReadField = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wReadField);
        this.wReadField.addModifyListener(lsMod);
        FormData fdReadField = new FormData();
        fdReadField.left = new FormAttachment(middle * 2, 0);
        fdReadField.bottom = new FormAttachment((Control)this.wOk, -3 * margin);
        fdReadField.right = new FormAttachment(100, 0);
        this.wReadField.setLayoutData((Object)fdReadField);
        Label wlDeleteField = new Label((Composite)this.shell, 131072);
        wlDeleteField.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.DeleteField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDeleteField);
        FormData fdlDeleteField = new FormData();
        fdlDeleteField.left = new FormAttachment(middle, margin);
        fdlDeleteField.right = new FormAttachment(middle * 2, -margin);
        fdlDeleteField.bottom = new FormAttachment((Control)this.wReadField, -margin);
        wlDeleteField.setLayoutData((Object)fdlDeleteField);
        this.wDeleteField = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wDeleteField);
        this.wDeleteField.addModifyListener(lsMod);
        FormData fdDeleteField = new FormData();
        fdDeleteField.left = new FormAttachment(middle * 2, 0);
        fdDeleteField.bottom = new FormAttachment((Control)this.wReadField, -margin);
        fdDeleteField.right = new FormAttachment(100, 0);
        this.wDeleteField.setLayoutData((Object)fdDeleteField);
        Label wlUpdateField = new Label((Composite)this.shell, 131072);
        wlUpdateField.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.UpdateField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUpdateField);
        FormData fdlUpdateField = new FormData();
        fdlUpdateField.left = new FormAttachment(middle, margin);
        fdlUpdateField.right = new FormAttachment(middle * 2, -margin);
        fdlUpdateField.bottom = new FormAttachment((Control)this.wDeleteField, -margin);
        wlUpdateField.setLayoutData((Object)fdlUpdateField);
        this.wUpdateField = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wUpdateField);
        this.wUpdateField.addModifyListener(lsMod);
        FormData fdUpdateField = new FormData();
        fdUpdateField.left = new FormAttachment(middle * 2, 0);
        fdUpdateField.bottom = new FormAttachment((Control)this.wDeleteField, -margin);
        fdUpdateField.right = new FormAttachment(100, 0);
        this.wUpdateField.setLayoutData((Object)fdUpdateField);
        Label wlInsertField = new Label((Composite)this.shell, 131072);
        wlInsertField.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.InsertField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInsertField);
        FormData fdlInsertField = new FormData();
        fdlInsertField.left = new FormAttachment(middle, margin);
        fdlInsertField.right = new FormAttachment(middle * 2, -margin);
        fdlInsertField.bottom = new FormAttachment((Control)this.wUpdateField, -margin);
        wlInsertField.setLayoutData((Object)fdlInsertField);
        this.wInsertField = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wInsertField);
        this.wInsertField.addModifyListener(lsMod);
        FormData fdInsertField = new FormData();
        fdInsertField.left = new FormAttachment(middle * 2, 0);
        fdInsertField.bottom = new FormAttachment((Control)this.wUpdateField, -margin);
        fdInsertField.right = new FormAttachment(100, 0);
        this.wInsertField.setLayoutData((Object)fdInsertField);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, 0);
        fdlFields.bottom = new FormAttachment((Control)this.wInsertField, -25);
        this.wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getArguments().size();
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExecSqlDialog.ColumnInfo.ArgumentFieldname", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(middle, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -3 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Label wlEachRow = new Label((Composite)this.shell, 131072);
        wlEachRow.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.EachRow.Label", (String[])new String[0]));
        wlEachRow.pack();
        Label wlSingleStatement = new Label((Composite)this.shell, 131072);
        wlSingleStatement.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.SingleStatement.Label", (String[])new String[0]));
        wlSingleStatement.pack();
        Label wlVariables = new Label((Composite)this.shell, 131072);
        wlVariables.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.ReplaceVariables", (String[])new String[0]));
        wlVariables.pack();
        this.wlQuoteString = new Label((Composite)this.shell, 131072);
        this.wlQuoteString.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.QuoteString.Label", (String[])new String[0]));
        this.wlQuoteString.pack();
        Rectangle rEachRow = wlEachRow.getBounds();
        Rectangle rSingleStatement = wlSingleStatement.getBounds();
        Rectangle rVariables = wlVariables.getBounds();
        Rectangle rQuoteString = this.wlQuoteString.getBounds();
        int width = Math.max(Math.max(Math.max(rEachRow.width, rSingleStatement.width), rVariables.width), rQuoteString.width) + 30;
        PropsUi.setLook((Widget)this.wlQuoteString);
        FormData fdlQuoteString = new FormData();
        fdlQuoteString.left = new FormAttachment(0, margin);
        fdlQuoteString.right = new FormAttachment(0, width);
        fdlQuoteString.bottom = new FormAttachment((Control)this.wlFields, -2 * margin);
        this.wlQuoteString.setLayoutData((Object)fdlQuoteString);
        this.wQuoteString = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wQuoteString);
        this.wQuoteString.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.QuoteString.Tooltip", (String[])new String[0]));
        FormData fdQuoteString = new FormData();
        fdQuoteString.left = new FormAttachment((Control)this.wlQuoteString, margin);
        fdQuoteString.top = new FormAttachment((Control)this.wlQuoteString, 0, 0x1000000);
        fdQuoteString.right = new FormAttachment(middle, 0);
        this.wQuoteString.setLayoutData((Object)fdQuoteString);
        this.wQuoteString.addSelectionListener((SelectionListener)lsSel);
        this.wlSetParams = new Label((Composite)this.shell, 131072);
        this.wlSetParams.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.SetParams.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSetParams);
        FormData fdlSetParams = new FormData();
        fdlSetParams.left = new FormAttachment(0, margin);
        fdlSetParams.bottom = new FormAttachment((Control)this.wQuoteString, -margin);
        fdlSetParams.right = new FormAttachment(0, width);
        this.wlSetParams.setLayoutData((Object)fdlSetParams);
        this.wSetParams = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSetParams);
        this.wSetParams.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.SetParams.Tooltip", (String[])new String[0]));
        FormData fdSetParams = new FormData();
        fdSetParams.left = new FormAttachment((Control)this.wlSetParams, margin);
        fdSetParams.top = new FormAttachment((Control)this.wlSetParams, 0, 0x1000000);
        fdSetParams.right = new FormAttachment(middle, 0);
        this.wSetParams.setLayoutData((Object)fdSetParams);
        this.wSetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlDialog.this.setExecutedSetParams();
                ExecSqlDialog.this.input.setChanged();
            }
        });
        PropsUi.setLook((Widget)wlVariables);
        FormData fdlVariables = new FormData();
        fdlVariables.left = new FormAttachment(0, margin);
        fdlVariables.right = new FormAttachment(0, width);
        fdlVariables.bottom = new FormAttachment((Control)this.wSetParams, -margin);
        wlVariables.setLayoutData((Object)fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wVariables);
        FormData fdVariables = new FormData();
        fdVariables.left = new FormAttachment((Control)wlVariables, margin);
        fdVariables.top = new FormAttachment((Control)wlVariables, 0, 0x1000000);
        fdVariables.right = new FormAttachment(middle, 0);
        this.wVariables.setLayoutData((Object)fdVariables);
        this.wVariables.addSelectionListener((SelectionListener)lsSel);
        PropsUi.setLook((Widget)wlSingleStatement);
        FormData fdlSingleStatement = new FormData();
        fdlSingleStatement.left = new FormAttachment(0, margin);
        fdlSingleStatement.right = new FormAttachment(0, width);
        fdlSingleStatement.bottom = new FormAttachment((Control)this.wVariables, -margin);
        wlSingleStatement.setLayoutData((Object)fdlSingleStatement);
        this.wSingleStatement = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSingleStatement);
        FormData fdSingleStatement = new FormData();
        fdSingleStatement.left = new FormAttachment((Control)wlEachRow, margin);
        fdSingleStatement.top = new FormAttachment((Control)wlSingleStatement, 0, 0x1000000);
        fdSingleStatement.right = new FormAttachment(middle, 0);
        this.wSingleStatement.setLayoutData((Object)fdSingleStatement);
        this.wSingleStatement.addSelectionListener((SelectionListener)lsSel);
        PropsUi.setLook((Widget)wlEachRow);
        FormData fdlEachRow = new FormData();
        fdlEachRow.left = new FormAttachment(0, margin);
        fdlEachRow.right = new FormAttachment(0, width);
        fdlEachRow.bottom = new FormAttachment((Control)this.wSingleStatement, -margin);
        wlEachRow.setLayoutData((Object)fdlEachRow);
        this.wEachRow = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wEachRow);
        FormData fdEachRow = new FormData();
        fdEachRow.left = new FormAttachment((Control)wlEachRow, margin);
        fdEachRow.top = new FormAttachment((Control)wlEachRow, 0, 0x1000000);
        fdEachRow.right = new FormAttachment(middle, 0);
        this.wEachRow.setLayoutData((Object)fdEachRow);
        this.wEachRow.addSelectionListener((SelectionListener)lsSel);
        this.wlPosition = new Label((Composite)this.shell, 0);
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment((Control)this.wEachRow, -2 * margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)wlSql, margin);
        fdSql.right = new FormAttachment(100, -2 * margin);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wEachRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlDialog.this.setExecutedEachInputRow();
                ExecSqlDialog.this.input.setChanged();
            }
        });
        this.getData();
        this.setExecutedEachInputRow();
        this.setExecutedSetParams();
        this.changedInDialog = false;
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setExecutedEachInputRow() {
        this.wlFields.setEnabled(this.wEachRow.getSelection());
        this.wFields.setEnabled(this.wEachRow.getSelection());
        this.wlSetParams.setEnabled(this.wEachRow.getSelection());
        this.wSetParams.setEnabled(this.wEachRow.getSelection());
        if (!this.wEachRow.getSelection()) {
            this.wSetParams.setSelection(this.wEachRow.getSelection());
        }
        if (!this.wEachRow.getSelection()) {
            this.wQuoteString.setSelection(this.wEachRow.getSelection());
        }
    }

    private void setExecutedSetParams() {
        this.wlQuoteString.setEnabled(!this.wSetParams.getSelection());
        this.wQuoteString.setEnabled(!this.wSetParams.getSelection());
        if (this.wSetParams.getSelection()) {
            this.wQuoteString.setSelection(!this.wSetParams.getSelection());
        }
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getSql() != null) {
            this.wSql.setText(this.input.getSql());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wEachRow.setSelection(this.input.isExecutedEachInputRow());
        this.wSingleStatement.setSelection(this.input.isSingleStatement());
        this.wVariables.setSelection(this.input.isReplaceVariables());
        this.wQuoteString.setSelection(this.input.isQuoteString());
        if (this.input.getUpdateField() != null) {
            this.wUpdateField.setText(this.input.getUpdateField());
        }
        if (this.input.getInsertField() != null) {
            this.wInsertField.setText(this.input.getInsertField());
        }
        if (this.input.getDeleteField() != null) {
            this.wDeleteField.setText(this.input.getDeleteField());
        }
        if (this.input.getReadField() != null) {
            this.wReadField.setText(this.input.getReadField());
        }
        for (int i = 0; i < this.input.getArguments().size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            ExecSqlArgumentItem arg = this.input.getArguments().get(i);
            if (arg == null) continue;
            item.setText(1, arg.getName());
        }
        this.wSetParams.setSelection(this.input.isParams());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setSql(this.wSql.getText());
        this.input.setConnection(this.wConnection.getText());
        this.input.setExecutedEachInputRow(this.wEachRow.getSelection());
        this.input.setSingleStatement(this.wSingleStatement.getSelection());
        this.input.setReplaceVariables(this.wVariables.getSelection());
        this.input.setQuoteString(this.wQuoteString.getSelection());
        this.input.setParams(this.wSetParams.getSelection());
        this.input.setInsertField(this.wInsertField.getText());
        this.input.setUpdateField(this.wUpdateField.getText());
        this.input.setDeleteField(this.wDeleteField.getText());
        this.input.setReadField(this.wReadField.getText());
        int nrargs = this.wFields.nrNonEmpty();
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecSqlDialog.Log.FoundArguments", (String[])new String[]{"" + nrargs}));
        }
        this.input.getArguments().clear();
        for (int i = 0; i < nrargs; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getArguments().add(new ExecSqlArgumentItem(item.getText(1)));
        }
        if (this.input.getConnection() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExecSqlDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExecSqlDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExecSqlDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

