/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.GcRule;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.cloud.bigtable.admin.v2.models.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public final class ColumnFamily {
    private final String id;
    private final GCRules.GCRule rule;
    private final Type valueType;

    @InternalApi
    public static ColumnFamily fromProto(String id, com.google.bigtable.admin.v2.ColumnFamily proto) {
        return new ColumnFamily(id, GCRules.GCRULES.fromProto(proto.getGcRule()), Type.fromProto(proto.getValueType()));
    }

    private ColumnFamily(String id, GCRules.GCRule rule, Type type) {
        this.id = id;
        this.rule = rule;
        this.valueType = type;
    }

    public String getId() {
        return this.id;
    }

    public GCRules.GCRule getGCRule() {
        return this.rule;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public boolean hasGCRule() {
        return !GcRule.RuleCase.RULE_NOT_SET.equals((Object)this.rule.toProto().getRuleCase());
    }

    public boolean hasValueType() {
        return this.valueType.getClass() != Type.Raw.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnFamily that = (ColumnFamily)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.rule, (Object)that.rule) && Objects.equal((Object)this.valueType, (Object)that.valueType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.rule, this.valueType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("GCRule", (Object)this.rule).add("valueType", (Object)this.valueType).toString();
    }
}

