/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class CreateAppProfileRequest {
    private final String instanceId;
    private final CreateAppProfileRequest.Builder proto;

    public static CreateAppProfileRequest of(String instanceId, String appProfileId) {
        return new CreateAppProfileRequest(instanceId, appProfileId);
    }

    private CreateAppProfileRequest(String instanceId, String appProfileId) {
        this.instanceId = instanceId;
        this.proto = com.google.bigtable.admin.v2.CreateAppProfileRequest.newBuilder();
        this.proto.setAppProfileId(appProfileId);
        this.proto.getAppProfileBuilder().setDescription(appProfileId);
    }

    public CreateAppProfileRequest setIgnoreWarnings(boolean value) {
        this.proto.setIgnoreWarnings(value);
        return this;
    }

    public CreateAppProfileRequest setDescription(@Nonnull String description) {
        this.proto.getAppProfileBuilder().setDescription(description);
        return this;
    }

    public CreateAppProfileRequest setRoutingPolicy(AppProfile.RoutingPolicy routingPolicy) {
        Preconditions.checkNotNull((Object)routingPolicy);
        if (routingPolicy instanceof AppProfile.MultiClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setMultiClusterRoutingUseAny(((AppProfile.MultiClusterRoutingPolicy)routingPolicy).toProto());
        } else if (routingPolicy instanceof AppProfile.SingleClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setSingleClusterRouting(((AppProfile.SingleClusterRoutingPolicy)routingPolicy).toProto());
        } else {
            throw new IllegalArgumentException("Unknown policy type: " + routingPolicy);
        }
        return this;
    }

    public CreateAppProfileRequest setIsolationPolicy(AppProfile.IsolationPolicy isolationPolicy) {
        Preconditions.checkNotNull((Object)isolationPolicy);
        if (!(isolationPolicy instanceof AppProfile.StandardIsolationPolicy)) {
            throw new IllegalArgumentException("Unknown policy type: " + isolationPolicy);
        }
        this.proto.getAppProfileBuilder().setStandardIsolation(((AppProfile.StandardIsolationPolicy)isolationPolicy).toProto());
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateAppProfileRequest toProto(String projectId) {
        String name = NameUtil.formatInstanceName(projectId, this.instanceId);
        return this.proto.setParent(name).build();
    }
}

