/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.KafkaReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;

final class AutoValue_KafkaReadSchemaTransformConfiguration
extends KafkaReadSchemaTransformConfiguration {
    private final String bootstrapServers;
    private final String confluentSchemaRegistryUrl;
    private final String format;
    private final String confluentSchemaRegistrySubject;
    private final String schema;
    private final String fileDescriptorPath;
    private final String messageName;
    private final String autoOffsetResetConfig;
    private final Map<String, String> consumerConfigUpdates;
    private final String topic;
    private final ErrorHandling errorHandling;

    private AutoValue_KafkaReadSchemaTransformConfiguration(String bootstrapServers, @Nullable String confluentSchemaRegistryUrl, @Nullable String format, @Nullable String confluentSchemaRegistrySubject, @Nullable String schema, @Nullable String fileDescriptorPath, @Nullable String messageName, @Nullable String autoOffsetResetConfig, @Nullable Map<String, String> consumerConfigUpdates, String topic, @Nullable ErrorHandling errorHandling) {
        this.bootstrapServers = bootstrapServers;
        this.confluentSchemaRegistryUrl = confluentSchemaRegistryUrl;
        this.format = format;
        this.confluentSchemaRegistrySubject = confluentSchemaRegistrySubject;
        this.schema = schema;
        this.fileDescriptorPath = fileDescriptorPath;
        this.messageName = messageName;
        this.autoOffsetResetConfig = autoOffsetResetConfig;
        this.consumerConfigUpdates = consumerConfigUpdates;
        this.topic = topic;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping\u2014this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form `host1:port1,host2:port2,...`")
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    @Nullable
    public String getConfluentSchemaRegistryUrl() {
        return this.confluentSchemaRegistryUrl;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The encoding format for the data stored in Kafka. Valid options are: RAW,AVRO,JSON,PROTO")
    public String getFormat() {
        return this.format;
    }

    @Override
    @Nullable
    public String getConfluentSchemaRegistrySubject() {
        return this.confluentSchemaRegistrySubject;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The schema in which the data is encoded in the Kafka topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/). If a URL to Confluent Schema Registry is provided, then this field is ignored, and the schema is fetched from Confluent Schema Registry.")
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The path to the Protocol Buffer File Descriptor Set file. This file is used for schema definition and message serialization.")
    public String getFileDescriptorPath() {
        return this.fileDescriptorPath;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The name of the Protocol Buffer message to be used for schema extraction and data conversion.")
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="What to do when there is no initial offset in Kafka or if the current offset does not exist any more on the server. (1) earliest: automatically reset the offset to the earliest offset. (2) latest: automatically reset the offset to the latest offset (3) none: throw exception to the consumer if no previous offset is found for the consumer\u2019s group")
    public String getAutoOffsetResetConfig() {
        return this.autoOffsetResetConfig;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="A list of key-value pairs that act as configuration parameters for Kafka consumers. Most of these configurations will not be needed, but if you need to customize your Kafka consumer, you may use this. See a detailed list: https://docs.confluent.io/platform/current/installation/configuration/consumer-configs.html")
    public Map<String, String> getConsumerConfigUpdates() {
        return this.consumerConfigUpdates;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "KafkaReadSchemaTransformConfiguration{bootstrapServers=" + this.bootstrapServers + ", confluentSchemaRegistryUrl=" + this.confluentSchemaRegistryUrl + ", format=" + this.format + ", confluentSchemaRegistrySubject=" + this.confluentSchemaRegistrySubject + ", schema=" + this.schema + ", fileDescriptorPath=" + this.fileDescriptorPath + ", messageName=" + this.messageName + ", autoOffsetResetConfig=" + this.autoOffsetResetConfig + ", consumerConfigUpdates=" + this.consumerConfigUpdates + ", topic=" + this.topic + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaReadSchemaTransformConfiguration) {
            KafkaReadSchemaTransformConfiguration that = (KafkaReadSchemaTransformConfiguration)o;
            return this.bootstrapServers.equals(that.getBootstrapServers()) && (this.confluentSchemaRegistryUrl == null ? that.getConfluentSchemaRegistryUrl() == null : this.confluentSchemaRegistryUrl.equals(that.getConfluentSchemaRegistryUrl())) && (this.format == null ? that.getFormat() == null : this.format.equals(that.getFormat())) && (this.confluentSchemaRegistrySubject == null ? that.getConfluentSchemaRegistrySubject() == null : this.confluentSchemaRegistrySubject.equals(that.getConfluentSchemaRegistrySubject())) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && (this.fileDescriptorPath == null ? that.getFileDescriptorPath() == null : this.fileDescriptorPath.equals(that.getFileDescriptorPath())) && (this.messageName == null ? that.getMessageName() == null : this.messageName.equals(that.getMessageName())) && (this.autoOffsetResetConfig == null ? that.getAutoOffsetResetConfig() == null : this.autoOffsetResetConfig.equals(that.getAutoOffsetResetConfig())) && (this.consumerConfigUpdates == null ? that.getConsumerConfigUpdates() == null : this.consumerConfigUpdates.equals(that.getConsumerConfigUpdates())) && this.topic.equals(that.getTopic()) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bootstrapServers.hashCode();
        h$ *= 1000003;
        h$ ^= this.confluentSchemaRegistryUrl == null ? 0 : this.confluentSchemaRegistryUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.format == null ? 0 : this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.confluentSchemaRegistrySubject == null ? 0 : this.confluentSchemaRegistrySubject.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.fileDescriptorPath == null ? 0 : this.fileDescriptorPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageName == null ? 0 : this.messageName.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoOffsetResetConfig == null ? 0 : this.autoOffsetResetConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerConfigUpdates == null ? 0 : this.consumerConfigUpdates.hashCode();
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends KafkaReadSchemaTransformConfiguration.Builder {
        private String bootstrapServers;
        private String confluentSchemaRegistryUrl;
        private String format;
        private String confluentSchemaRegistrySubject;
        private String schema;
        private String fileDescriptorPath;
        private String messageName;
        private String autoOffsetResetConfig;
        private Map<String, String> consumerConfigUpdates;
        private String topic;
        private ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setBootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("Null bootstrapServers");
            }
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setConfluentSchemaRegistryUrl(String confluentSchemaRegistryUrl) {
            this.confluentSchemaRegistryUrl = confluentSchemaRegistryUrl;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setConfluentSchemaRegistrySubject(String confluentSchemaRegistrySubject) {
            this.confluentSchemaRegistrySubject = confluentSchemaRegistrySubject;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setFileDescriptorPath(String fileDescriptorPath) {
            this.fileDescriptorPath = fileDescriptorPath;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setMessageName(String messageName) {
            this.messageName = messageName;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setAutoOffsetResetConfig(String autoOffsetResetConfig) {
            this.autoOffsetResetConfig = autoOffsetResetConfig;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setConsumerConfigUpdates(Map<String, String> consumerConfigUpdates) {
            this.consumerConfigUpdates = consumerConfigUpdates;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setTopic(String topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public KafkaReadSchemaTransformConfiguration build() {
            if (this.bootstrapServers == null || this.topic == null) {
                StringBuilder missing = new StringBuilder();
                if (this.bootstrapServers == null) {
                    missing.append(" bootstrapServers");
                }
                if (this.topic == null) {
                    missing.append(" topic");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaReadSchemaTransformConfiguration(this.bootstrapServers, this.confluentSchemaRegistryUrl, this.format, this.confluentSchemaRegistrySubject, this.schema, this.fileDescriptorPath, this.messageName, this.autoOffsetResetConfig, this.consumerConfigUpdates, this.topic, this.errorHandling);
        }
    }
}

