/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.nio.charset.Charset;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.skeleton.Skeleton;

public class OptionUtils {
    private OptionUtils() {
    }

    public static void setEncoding(String encodingName) {
        if (!Charset.isSupported(encodingName)) {
            Out.error(ErrorMessages.CHARSET_NOT_SUPPORTED, encodingName);
            throw new GeneratorException();
        }
        Options.encoding = Charset.forName(encodingName);
    }

    public static void setDefaultOptions() {
        Options.directory = null;
        Options.resetRootDirectory();
        Options.jlex = false;
        Options.no_minimize = false;
        Options.no_backup = false;
        Options.verbose = true;
        Options.progress = true;
        Options.unused_warning = true;
        Options.time = false;
        Options.dot = false;
        Options.dump = false;
        Options.legacy_dot = false;
        Options.encoding = Charset.defaultCharset();
        Skeleton.readDefault();
    }

    public static void setSkeleton(File skel) {
        Skeleton.readSkelFile(skel);
    }

    public static void setDir(File d) {
        if (d.isFile()) {
            Out.error("Error: \"" + d + "\" is not a directory.");
            throw new GeneratorException();
        }
        if (!d.isDirectory() && !d.mkdirs()) {
            Out.error("Error: couldn't create directory \"" + d + "\"");
            throw new GeneratorException();
        }
        Options.directory = d;
    }

    public static void setDir(String dirName) {
        OptionUtils.setDir(new File(dirName));
    }
}

