/*
 * Decompiled with CFR 0.152.
 */
package jflex.core.unicode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import jflex.chars.Interval;
import jflex.core.unicode.UnicodeProperties;

public final class IntCharSet
implements Iterable<Integer> {
    private static final boolean DEBUG = false;
    private final List<Interval> intervals = new ArrayList<Interval>();

    public static IntCharSet of(Interval interval) {
        IntCharSet charset = new IntCharSet();
        charset.intervals.add(interval);
        return charset;
    }

    public static IntCharSet of(Interval ... intervals) {
        IntCharSet charset = new IntCharSet();
        for (Interval i : intervals) {
            charset.add(i);
        }
        return charset;
    }

    public static IntCharSet ofCharacterRange(int start, int end) {
        return IntCharSet.of(new Interval(start, end));
    }

    public static IntCharSet ofCharacter(int singleChar) {
        return IntCharSet.of(Interval.ofCharacter(singleChar));
    }

    public static IntCharSet allChars() {
        return IntCharSet.ofCharacterRange(0, 0x10FFFF);
    }

    public static IntCharSet nlChars() {
        IntCharSet set = new IntCharSet();
        set.intervals.add(new Interval(10, 13));
        set.intervals.add(Interval.ofCharacter(133));
        set.intervals.add(new Interval(8232, 8233));
        return set;
    }

    private int indexOf(int c) {
        int start = 0;
        int end = this.intervals.size() - 1;
        while (start <= end) {
            int check = (start + end) / 2;
            Interval i = this.intervals.get(check);
            if (start == end) {
                return i.contains(c) ? start : -1;
            }
            if (c < i.start) {
                end = check - 1;
                continue;
            }
            if (c > i.end) {
                start = check + 1;
                continue;
            }
            return check;
        }
        return -1;
    }

    public void add(IntCharSet set) {
        for (Interval interval : set.intervals) {
            this.add(interval);
        }
    }

    public void add(Interval interval) {
        int size = this.intervals.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = this.intervals.get(i);
            if (elem.end + 1 < interval.start) continue;
            if (elem.contains(interval)) {
                return;
            }
            if (elem.start > interval.end + 1) {
                this.intervals.add(i, Interval.copyOf(interval));
                return;
            }
            if (interval.start < elem.start) {
                elem.start = interval.start;
            }
            if (interval.end <= elem.end) {
                return;
            }
            elem.end = interval.end;
            ++i;
            while (i < size) {
                Interval x = this.intervals.get(i);
                if (x.start > elem.end + 1) {
                    return;
                }
                if (x.end > elem.end) {
                    elem.end = x.end;
                }
                this.intervals.remove(i);
                --size;
            }
            return;
        }
        this.intervals.add(Interval.copyOf(interval));
    }

    public void add(int c) {
        int size = this.intervals.size();
        for (int i = 0; i < size; ++i) {
            Interval elem = this.intervals.get(i);
            if (elem.end + 1 < c) continue;
            if (elem.contains(c)) {
                return;
            }
            if (elem.start > c + 1) {
                this.intervals.add(i, Interval.ofCharacter(c));
                return;
            }
            if (c + 1 == elem.start) {
                elem.start = c;
                return;
            }
            elem.end = c;
            if (i + 1 >= size) {
                return;
            }
            Interval x = this.intervals.get(i + 1);
            if (x.start <= c + 1) {
                elem.end = x.end;
                this.intervals.remove(i + 1);
            }
            return;
        }
        this.intervals.add(Interval.ofCharacter(c));
    }

    public boolean contains(int singleChar) {
        return this.indexOf(singleChar) >= 0;
    }

    public boolean contains(IntCharSet other) {
        if (other == null) {
            return true;
        }
        IntCharSet set = IntCharSet.copyOf(other);
        IntCharSet inter = this.and(other);
        set.sub(inter);
        return !set.containsElements();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntCharSet)) {
            return false;
        }
        IntCharSet set = (IntCharSet)o;
        return Objects.equals(this.intervals, set.intervals);
    }

    public int hashCode() {
        int h = 1;
        for (Interval interval : this.intervals) {
            h *= 1000003;
            h ^= interval.hashCode();
        }
        return h;
    }

    public IntCharSet and(IntCharSet set) {
        IntCharSet result = new IntCharSet();
        int i = 0;
        int j = 0;
        int size = this.intervals.size();
        int setSize = set.intervals.size();
        while (i < size && j < setSize) {
            Interval x = this.intervals.get(i);
            Interval y = set.intervals.get(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            result.intervals.add(new Interval(Math.max(x.start, y.start), Math.min(x.end, y.end)));
            if (x.end >= y.end) {
                ++j;
            }
            if (y.end < x.end) continue;
            ++i;
        }
        return result;
    }

    public void sub(IntCharSet set) {
        int i = 0;
        int j = 0;
        int setSize = set.intervals.size();
        while (i < this.intervals.size() && j < setSize) {
            Interval x = this.intervals.get(i);
            Interval y = set.intervals.get(j);
            if (x.end < y.start) {
                ++i;
                continue;
            }
            if (y.end < x.start) {
                ++j;
                continue;
            }
            if (x.start == y.start && x.end == y.end) {
                this.intervals.remove(i);
                ++j;
                continue;
            }
            if (x.start == y.start) {
                x.start = y.end + 1;
                ++j;
                continue;
            }
            if (x.end == y.end) {
                x.end = y.start - 1;
                ++i;
                ++j;
                continue;
            }
            this.intervals.add(i, new Interval(x.start, y.start - 1));
            x.start = y.end + 1;
            ++i;
            ++j;
        }
    }

    public static IntCharSet complementOf(IntCharSet x) {
        IntCharSet result = IntCharSet.allChars();
        if (x != null) {
            result.sub(x);
        }
        return result;
    }

    public boolean containsElements() {
        return this.intervals.size() > 0;
    }

    public int numIntervals() {
        return this.intervals.size();
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public Iterator<Interval> intervalIterator() {
        return this.intervals.iterator();
    }

    public IntCharSet getCaseless(UnicodeProperties unicodeProperties) {
        IntCharSet n = IntCharSet.copyOf(this);
        for (Interval elem : this.intervals) {
            for (int c = elem.start; c <= elem.end; ++c) {
                IntCharSet equivalenceClass = unicodeProperties.getCaselessMatches(c);
                if (null == equivalenceClass) continue;
                n.add(equivalenceClass);
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{ ");
        for (Interval interval : this.intervals) {
            result.append(interval);
        }
        result.append(" }");
        return result.toString();
    }

    public static IntCharSet copyOf(IntCharSet intCharSet) {
        IntCharSet result = new IntCharSet();
        for (Interval interval : intCharSet.intervals) {
            result.intervals.add(Interval.copyOf(interval));
        }
        return result;
    }

    public int size() {
        int charCount = 0;
        for (Interval i : this.intervals) {
            charCount += i.size();
        }
        return charCount;
    }

    boolean invariants() {
        for (Interval i : this.intervals) {
            if (i.invariants()) continue;
            return false;
        }
        for (int j = 0; j < this.intervals.size() - 1; ++j) {
            if (this.intervals.get((int)j).end < this.intervals.get((int)(j + 1)).start) continue;
            return false;
        }
        return true;
    }

    static boolean isSubSet(IntCharSet s1, IntCharSet s2) {
        IntCharSetIterator intCharSetIterator = s1.iterator();
        while (intCharSetIterator.hasNext()) {
            int i = (Integer)intCharSetIterator.next();
            if (s2.contains(i)) continue;
            return false;
        }
        return true;
    }

    public IntCharSetIterator iterator() {
        return new IntCharSetIterator();
    }

    Interval getFirstInterval() {
        return this.intervals.get(0);
    }

    public class IntCharSetIterator
    implements PrimitiveIterator.OfInt {
        private final Iterator<Interval> intervalsIterator;
        private Interval.IntervalIterator current;

        private IntCharSetIterator() {
            this.intervalsIterator = IntCharSet.this.intervals.iterator();
            if (this.intervalsIterator.hasNext()) {
                this.current = this.intervalsIterator.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null && (this.current.hasNext() || this.intervalsIterator.hasNext());
        }

        @Override
        public int nextInt() {
            if (!this.current.hasNext()) {
                this.current = this.intervalsIterator.next().iterator();
            }
            return this.current.nextInt();
        }
    }
}

