/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

class SerializableAvroCodecFactory
implements Externalizable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 7445324844109564303L;
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> noOptAvroCodecs = Arrays.asList("null", "snappy", "bzip2");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern deflatePattern = Pattern.compile("deflate-(?<level>-?\\d)");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern xzPattern = Pattern.compile("xz-(?<level>\\d)");
    private @Nullable @UnknownKeyFor @Initialized CodecFactory codecFactory;

    public SerializableAvroCodecFactory() {
    }

    public SerializableAvroCodecFactory(@UnknownKeyFor @NonNull @Initialized CodecFactory codecFactory) {
        Preconditions.checkNotNull((Object)codecFactory, (Object)"Codec can't be null");
        Preconditions.checkState((boolean)this.checkIsSupportedCodec(codecFactory), (String)"%s is not supported", (Object)codecFactory);
        this.codecFactory = codecFactory;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkIsSupportedCodec(@UnknownKeyFor @NonNull @Initialized CodecFactory codecFactory) {
        String codecStr = codecFactory.toString();
        return noOptAvroCodecs.contains(codecStr) || deflatePattern.matcher(codecStr).matches() || xzPattern.matcher(codecStr).matches();
    }

    @Override
    public void writeExternal(@UnknownKeyFor @NonNull @Initialized ObjectOutput out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        out.writeUTF(this.codecFactory.toString());
    }

    @Override
    public void readExternal(@UnknownKeyFor @NonNull @Initialized ObjectInput in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        String codecStr;
        switch (codecStr = in.readUTF()) {
            case "null": 
            case "snappy": 
            case "bzip2": {
                this.codecFactory = CodecFactory.fromString((String)codecStr);
                return;
            }
        }
        Matcher deflateMatcher = deflatePattern.matcher(codecStr);
        if (deflateMatcher.find()) {
            this.codecFactory = CodecFactory.deflateCodec((int)Integer.parseInt(deflateMatcher.group("level")));
            return;
        }
        Matcher xzMatcher = xzPattern.matcher(codecStr);
        if (xzMatcher.find()) {
            this.codecFactory = CodecFactory.xzCodec((int)Integer.parseInt(xzMatcher.group("level")));
            return;
        }
        throw new IllegalStateException(codecStr + " is not supported");
    }

    public @UnknownKeyFor @NonNull @Initialized CodecFactory getCodec() {
        return this.codecFactory;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        Preconditions.checkNotNull((Object)this.codecFactory, (Object)"Inner CodecFactory is null, please use non default constructor");
        return this.codecFactory.toString();
    }
}

