/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PCollectionViewWindow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

class SideInputContainer {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of("beam:side_input:iterable:v1", "beam:side_input:multimap:v1");
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> containedViews;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>> viewByWindows;

    public static @UnknownKeyFor @NonNull @Initialized SideInputContainer create(@UnknownKeyFor @NonNull @Initialized EvaluationContext context, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> containedViews) {
        for (PCollectionView<?> pCollectionView : containedViews) {
            Preconditions.checkArgument(SUPPORTED_MATERIALIZATIONS.contains(pCollectionView.getViewFn().getMaterialization().getUrn()), "This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        LoadingCache<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> viewByWindows = CacheBuilder.newBuilder().build(new CallbackSchedulingLoader(context));
        return new SideInputContainer(containedViews, viewByWindows);
    }

    private SideInputContainer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> containedViews, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>> viewByWindows) {
        this.containedViews = ImmutableSet.copyOf(containedViews);
        this.viewByWindows = viewByWindows;
    }

    public @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader createReaderForViews(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> newContainedViews) {
        if (!this.containedViews.containsAll(newContainedViews)) {
            ImmutableSet<PCollectionView<?>> currentlyContained = ImmutableSet.copyOf(this.containedViews);
            ImmutableSet<PCollectionView<?>> newRequested = ImmutableSet.copyOf(newContainedViews);
            throw new IllegalArgumentException("Can't create a SideInputReader with unknown views " + Sets.difference(newRequested, currentlyContained));
        }
        return new SideInputContainerSideInputReader(newContainedViews);
    }

    public void write(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> values) {
        Map<BoundedWindow, Collection<WindowedValue<?>>> valuesPerWindow = this.indexValuesByWindow(values);
        for (Map.Entry<BoundedWindow, Collection<WindowedValue<?>>> windowValues : valuesPerWindow.entrySet()) {
            this.updatePCollectionViewWindowValues(view, windowValues.getKey(), windowValues.getValue());
        }
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> indexValuesByWindow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> values) {
        HashMap valuesPerWindow = new HashMap();
        for (WindowedValue<?> value : values) {
            for (BoundedWindow window : value.getWindows()) {
                Collection windowValues = valuesPerWindow.computeIfAbsent(window, k -> new ArrayList());
                windowValues.add(value);
            }
        }
        return valuesPerWindow;
    }

    private void updatePCollectionViewWindowValues(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> windowValues) {
        Iterable<WindowedValue<?>> existingValues;
        long existingPane;
        PCollectionViewWindow<?> windowedView = PCollectionViewWindow.of(view, window);
        AtomicReference<Iterable<WindowedValue<?>>> contents = this.viewByWindows.getUnchecked(windowedView);
        if (contents.compareAndSet(null, windowValues)) {
            return;
        }
        PaneInfo newPane = windowValues.iterator().next().getPane();
        do {
            long l = existingPane = Iterables.isEmpty(existingValues = contents.get()) ? -1L : existingValues.iterator().next().getPane().getIndex();
        } while (newPane.getIndex() > existingPane && !contents.compareAndSet(existingValues, windowValues));
    }

    private class CurrentViewContentsLoader
    extends CacheLoader<PCollectionViewWindow<?>, Optional<? extends Iterable<? extends WindowedValue<?>>>> {
        private CurrentViewContentsLoader() {
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Optional<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> load(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
            return Optional.ofNullable((Iterable)((AtomicReference)SideInputContainer.this.viewByWindows.getUnchecked(key)).get());
        }
    }

    private final class SideInputContainerSideInputReader
    implements ReadyCheckingSideInputReader {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> readerViews;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Optional<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>> viewContents;

        private SideInputContainerSideInputReader(Collection<PCollectionView<?>> readerViews) {
            this.readerViews = ImmutableSet.copyOf(readerViews);
            this.viewContents = CacheBuilder.newBuilder().build(new CurrentViewContentsLoader());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isReady(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Preconditions.checkArgument(this.readerViews.contains(view), "Tried to check if view %s was ready in a SideInputReader that does not contain it. Contained views; %s", view, this.readerViews);
            return this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window)).isPresent();
        }

        @Override
        public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            Preconditions.checkArgument(this.readerViews.contains(view), "call to get(PCollectionView) with unknown view: %s", view);
            Preconditions.checkArgument(this.isReady(view, window), "calling get() on PCollectionView %s that is not ready in window %s", view, (Object)window);
            Iterable elements = Iterables.transform(this.viewContents.getUnchecked(PCollectionViewWindow.of(view, window)).get(), WindowedValue::getValue);
            switch (view.getViewFn().getMaterialization().getUrn()) {
                case "beam:side_input:iterable:v1": {
                    ViewFn<?, T> viewFn = view.getViewFn();
                    return viewFn.apply(() -> elements);
                }
                case "beam:side_input:multimap:v1": {
                    ViewFn<?, T> viewFn = view.getViewFn();
                    Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                    return viewFn.apply(InMemoryMultimapSideInputView.fromIterable(keyCoder, elements));
                }
            }
            throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
            return this.readerViews.contains(view);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return this.readerViews.isEmpty();
        }
    }

    private static class WriteEmptyViewContents
    implements Runnable {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view;
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> contents;

        private WriteEmptyViewContents(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> contents) {
            this.contents = contents;
            this.view = view;
            this.window = window;
        }

        @Override
        public void run() {
            this.contents.compareAndSet(null, Collections.emptyList());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this).add("view", this.view).add("window", this.window).toString();
        }
    }

    private static class CallbackSchedulingLoader
    extends CacheLoader<PCollectionViewWindow<?>, AtomicReference<Iterable<? extends WindowedValue<?>>>> {
        private final @UnknownKeyFor @NonNull @Initialized EvaluationContext context;

        public CallbackSchedulingLoader(@UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
            this.context = context;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> load(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view) {
            AtomicReference contents = new AtomicReference();
            WindowingStrategy<?, ?> windowingStrategy = view.getView().getWindowingStrategyInternal();
            this.context.scheduleAfterOutputWouldBeProduced(view.getView(), view.getWindow(), windowingStrategy, (Runnable)new WriteEmptyViewContents(view.getView(), view.getWindow(), contents));
            return contents;
        }
    }
}

