/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BitConverters {
    private BitConverters() {
    }

    static @UnknownKeyFor @NonNull @Initialized long readBigEndianLong(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buf = new byte[8];
        ByteStreams.readFully(in, buf);
        return Longs.fromByteArray(buf);
    }

    static @UnknownKeyFor @NonNull @Initialized int readBigEndianInt(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int b4;
        int b3;
        int b2;
        int b1 = in.read();
        if ((b1 | (b2 = in.read()) | (b3 = in.read()) | (b4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    static @UnknownKeyFor @NonNull @Initialized short readBigEndianShort(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int b2;
        int b1 = in.read();
        if ((b1 | (b2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((b1 & 0xFF) << 8 | b2 & 0xFF);
    }

    static void writeBigEndianLong(@UnknownKeyFor @NonNull @Initialized long value, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buf = Longs.toByteArray(value);
        out.write(buf);
    }

    static void writeBigEndianInt(@UnknownKeyFor @NonNull @Initialized int value, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        out.write((byte)(value >>> 24) & 0xFF);
        out.write((byte)(value >>> 16) & 0xFF);
        out.write((byte)(value >>> 8) & 0xFF);
        out.write((byte)value);
    }

    static void writeBigEndianShort(@UnknownKeyFor @NonNull @Initialized short value, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        out.write((byte)(value >> 8));
        out.write((byte)value);
    }
}

