/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
final class WindowSupplier
implements Supplier<Collection<BoundedWindow>>,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> coder;
    private final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> encodedWindows;
    private transient @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized WindowSupplier of(@UnknownKeyFor @NonNull @Initialized Coder<W> coder, @UnknownKeyFor @NonNull @Initialized Iterable<W> windows) {
        ImmutableSet.Builder windowsBuilder = ImmutableSet.builder();
        for (BoundedWindow window : windows) {
            try {
                windowsBuilder.add((Object)CoderUtils.encodeToByteArray(coder, window));
            }
            catch (CoderException e) {
                throw new IllegalArgumentException("Could not encode provided windows with the provided window coder", e);
            }
        }
        return new WindowSupplier(coder, windowsBuilder.build());
    }

    private WindowSupplier(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> coder, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> encodedWindows) {
        this.coder = coder;
        this.encodedWindows = encodedWindows;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> get() {
        if (this.windows == null) {
            this.decodeWindows();
        }
        return this.windows;
    }

    private synchronized void decodeWindows() {
        if (this.windows == null) {
            ImmutableList.Builder windowsBuilder = ImmutableList.builder();
            for (byte[] encoded : this.encodedWindows) {
                try {
                    windowsBuilder.add(CoderUtils.decodeFromByteArray(this.coder, encoded));
                }
                catch (CoderException e) {
                    throw new IllegalArgumentException("Could not decode provided windows with the provided window coder", e);
                }
            }
            this.windows = windowsBuilder.build();
        }
    }
}

