/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.ConvertHelpers;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ParDo {
    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized SingleOutput<InputT, OutputT> of(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn) {
        ParDo.validate(fn);
        return new SingleOutput<InputT, OutputT>(fn, Collections.emptyMap(), ParDo.displayDataForFn(fn));
    }

    private static <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> displayDataForFn(T fn) {
        return DisplayData.item("fn", fn.getClass()).withLabel("Transform Function");
    }

    private static void finishSpecifyingStateSpecs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputCoder) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        Map<String, DoFnSignature.StateDeclaration> stateDeclarations = signature.stateDeclarations();
        for (DoFnSignature.StateDeclaration stateDeclaration : stateDeclarations.values()) {
            try {
                Coder[] coders;
                StateSpec stateSpec = (StateSpec)stateDeclaration.field().get(fn);
                try {
                    coders = ParDo.schemasForStateSpecTypes(stateDeclaration, schemaRegistry);
                }
                catch (NoSuchSchemaException e) {
                    coders = ParDo.codersForStateSpecTypes(stateDeclaration, coderRegistry, inputCoder);
                }
                stateSpec.offerCoders(coders);
                stateSpec.finishSpecifying();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void validateStateApplicableForInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        Coder<?> inputCoder = input.getCoder();
        Preconditions.checkArgument(inputCoder instanceof KvCoder, "%s requires its input to use %s in order to use state and timers.", (Object)ParDo.class.getSimpleName(), (Object)KvCoder.class.getSimpleName());
        KvCoder kvCoder = (KvCoder)inputCoder;
        try {
            kvCoder.getKeyCoder().verifyDeterministic();
        }
        catch (Coder.NonDeterministicException exc) {
            throw new IllegalArgumentException(String.format("%s requires a deterministic key coder in order to use state and timers, the reason is:%n %s", ParDo.class.getSimpleName(), exc.getMessage()));
        }
    }

    private static void validateSideInputTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        DoFnSignature.ProcessElementMethod processElementMethod = signature.processElement();
        for (DoFnSignature.Parameter.SideInputParameter sideInput : processElementMethod.getSideInputParameters()) {
            PCollectionView<?> view = sideInputs.get(sideInput.sideInputId());
            Preconditions.checkArgument(view != null, "the ProcessElement method expects a side input identified with the tag %s, but no such side input was supplied. Use withSideInput(String, PCollectionView) to supply this side input.", (Object)sideInput.sideInputId());
            TypeDescriptor<?> viewType = view.getViewFn().getTypeDescriptor();
            Preconditions.checkArgument(viewType.equals(sideInput.elementT()), "Side Input with tag %s and type %s cannot be bound to ProcessElement parameter with type %s", (Object)sideInput.sideInputId(), viewType, sideInput.elementT());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptorFromParameter(@Nullable @UnknownKeyFor @Initialized String fieldAccessString, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DoFnSignature.FieldAccessDeclaration> fieldAccessDeclarations, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn) {
        FieldAccessDescriptor fieldAccessDescriptor = null;
        if (fieldAccessString == null) {
            fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();
        } else {
            DoFnSignature.FieldAccessDeclaration fieldAccessDeclaration = fieldAccessDeclarations.get(fieldAccessString);
            if (fieldAccessDeclaration != null) {
                Preconditions.checkArgument(fieldAccessDeclaration.field().getType().equals(FieldAccessDescriptor.class));
                try {
                    fieldAccessDescriptor = (FieldAccessDescriptor)fieldAccessDeclaration.field().get(fn);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            } else {
                fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames(fieldAccessString);
            }
        }
        return fieldAccessDescriptor.resolve(inputSchema);
    }

    private static @UnknownKeyFor @NonNull @Initialized SchemaCoder @UnknownKeyFor @NonNull @Initialized [] schemasForStateSpecTypes(@UnknownKeyFor @NonNull @Initialized DoFnSignature.StateDeclaration stateDeclaration, @UnknownKeyFor @NonNull @Initialized SchemaRegistry schemaRegistry) throws @UnknownKeyFor @NonNull @Initialized NoSuchSchemaException {
        Type stateType = stateDeclaration.stateType().getType();
        if (!(stateType instanceof ParameterizedType)) {
            return new SchemaCoder[0];
        }
        Type[] typeArguments = ((ParameterizedType)stateType).getActualTypeArguments();
        SchemaCoder[] coders = new SchemaCoder[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            Type typeArgument = typeArguments[i];
            TypeDescriptor<?> typeDescriptor = TypeDescriptor.of(typeArgument);
            coders[i] = SchemaCoder.of(schemaRegistry.getSchema(typeDescriptor), typeDescriptor, schemaRegistry.getToRowFunction(typeDescriptor), schemaRegistry.getFromRowFunction(typeDescriptor));
        }
        return coders;
    }

    private static <InputT> @UnknownKeyFor @NonNull @Initialized Coder @UnknownKeyFor @NonNull @Initialized [] codersForStateSpecTypes(@UnknownKeyFor @NonNull @Initialized DoFnSignature.StateDeclaration stateDeclaration, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) {
        Type stateType = stateDeclaration.stateType().getType();
        if (!(stateType instanceof ParameterizedType)) {
            return new Coder[0];
        }
        Type[] typeArguments = ((ParameterizedType)stateType).getActualTypeArguments();
        Coder[] coders = new Coder[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            Type typeArgument = typeArguments[i];
            TypeDescriptor<?> typeDescriptor = TypeDescriptor.of(typeArgument);
            try {
                coders[i] = coderRegistry.getCoder(typeDescriptor);
                continue;
            }
            catch (CannotProvideCoderException e) {
                try {
                    coders[i] = coderRegistry.getCoder(typeDescriptor, inputCoder.getEncodedTypeDescriptor(), inputCoder);
                    continue;
                }
                catch (CannotProvideCoderException cannotProvideCoderException) {
                    // empty catch block
                }
            }
        }
        return coders;
    }

    private static <InputT, OutputT> void validateWindowType(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        TypeDescriptor<?> actualWindowT = input.getWindowingStrategy().getWindowFn().getWindowTypeDescriptor();
        ParDo.validateWindowTypeForMethod(actualWindowT, signature.processElement());
        for (DoFnSignature.OnTimerMethod onTimerMethod : signature.onTimerMethods().values()) {
            ParDo.validateWindowTypeForMethod(actualWindowT, onTimerMethod);
        }
        for (DoFnSignature.OnTimerFamilyMethod onTimerFamilyMethod : signature.onTimerFamilyMethods().values()) {
            ParDo.validateWindowTypeForMethod(actualWindowT, onTimerFamilyMethod);
        }
    }

    private static void validateWindowTypeForMethod(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> actualWindowT, @UnknownKeyFor @NonNull @Initialized DoFnSignature.MethodWithExtraParameters methodSignature) {
        if (methodSignature.windowT() != null) {
            Preconditions.checkArgument(methodSignature.windowT().isSupertypeOf(actualWindowT), "%s unable to provide window -- expected window type from parameter (%s) is not a supertype of actual window type assigned by windowing (%s)", (Object)methodSignature.targetMethod(), methodSignature.windowT(), actualWindowT);
        }
    }

    private static <InputT, OutputT> void validate(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        if (!signature.stateDeclarations().isEmpty() && signature.processElement().isSplittable()) {
            throw new UnsupportedOperationException(String.format("%s is splittable and uses state, but these are not compatible", fn.getClass().getName()));
        }
        if (!(signature.timerDeclarations().isEmpty() && signature.timerFamilyDeclarations().isEmpty() || !signature.processElement().isSplittable())) {
            throw new UnsupportedOperationException(String.format("%s is splittable and uses timers, but these are not compatible", fn.getClass().getName()));
        }
        if (!signature.timerFamilyDeclarations().isEmpty() && signature.processElement().isSplittable()) {
            throw new UnsupportedOperationException(String.format("%s is splittable and uses timer family, but these are not compatible", fn.getClass().getName()));
        }
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation getDoFnSchemaInformation(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        DoFnSignature.ProcessElementMethod processElementMethod = signature.processElement();
        if (!processElementMethod.getSchemaElementParameters().isEmpty() && !input.hasSchema()) {
            throw new IllegalArgumentException("Type of @Element must match the DoFn type" + input);
        }
        SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
        DoFnSchemaInformation doFnSchemaInformation = DoFnSchemaInformation.create();
        for (DoFnSignature.Parameter.SchemaElementParameter parameter : processElementMethod.getSchemaElementParameters()) {
            TypeDescriptor<?> elementT = parameter.elementT();
            FieldAccessDescriptor accessDescriptor = ParDo.getFieldAccessDescriptorFromParameter(parameter.fieldAccessString(), input.getSchema(), signature.fieldAccessDeclarations(), fn);
            doFnSchemaInformation = doFnSchemaInformation.withFieldAccessDescriptor(accessDescriptor);
            Schema selectedSchema = SelectHelpers.getOutputSchema(input.getSchema(), accessDescriptor);
            ConvertHelpers.ConvertedSchemaInformation<?> converted = ConvertHelpers.getConvertedSchemaInformation(selectedSchema, elementT, schemaRegistry);
            if (converted.outputSchemaCoder != null) {
                doFnSchemaInformation = doFnSchemaInformation.withSelectFromSchemaParameter((SchemaCoder)input.getCoder(), accessDescriptor, selectedSchema, converted.outputSchemaCoder, converted.unboxedType != null);
                continue;
            }
            Preconditions.checkArgument(converted.unboxedType != null);
            doFnSchemaInformation = doFnSchemaInformation.withUnboxPrimitiveParameter((SchemaCoder)input.getCoder(), accessDescriptor, selectedSchema, elementT);
        }
        for (DoFnSignature.Parameter p : processElementMethod.extraParameters()) {
            if (!(p instanceof DoFnSignature.Parameter.ProcessContextParameter) && !(p instanceof DoFnSignature.Parameter.ElementParameter)) continue;
            doFnSchemaInformation = doFnSchemaInformation.withFieldAccessDescriptor(FieldAccessDescriptor.withAllFields());
            break;
        }
        return doFnSchemaInformation;
    }

    private static @UnknownKeyFor @NonNull @Initialized String stateDescription(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> spec) {
        return spec.match(new StateSpec.Cases<String>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchValue(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return "ValueState<" + valueCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchBag(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return "BagState<" + elementCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchOrderedList(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return "OrderedListState<" + elementCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchCombining(/*
             * Issues handling annotations - annotations may be inaccurate
             */
             @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> accumCoder) {
                return "CombiningState<" + accumCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchMap(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return "MapState<" + keyCoder + ", " + valueCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchSet(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> elementCoder) {
                return "SetState<" + elementCoder + ">";
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String dispatchMultimap(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueCoder) {
                return "MultimapState<" + keyCoder + ", " + valueCoder + ">";
            }
        });
    }

    private static void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
        builder.include("fn", fn).add(fnDisplayData);
        for (DoFnSignature.StateDeclaration stateDeclaration : DoFnSignatures.signatureForDoFn(fn).stateDeclarations().values()) {
            try {
                StateSpec stateSpec = (StateSpec)stateDeclaration.field().get(fn);
                builder.add(DisplayData.item("state_" + stateDeclaration.id(), ParDo.stateDescription(stateSpec)).withLabel("State \"" + stateDeclaration.id() + "\""));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MultiOutput<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<? extends InputT>, PCollectionTuple> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;

        MultiOutput(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
            this.sideInputs = sideInputs;
            this.mainOutputTag = mainOutputTag;
            this.additionalOutputTags = additionalOutputTags;
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
        }

        public @UnknownKeyFor @NonNull @Initialized MultiOutput<InputT, OutputT> withSideInputs(PCollectionView<?> ... sideInputs) {
            return this.withSideInputs(Arrays.asList(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized MultiOutput<InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            Map<String, PCollectionView<?>> mappedInputs = StreamSupport.stream(sideInputs.spliterator(), false).collect(Collectors.toMap(v -> v.getTagInternal().getId(), v -> v));
            return this.withSideInputs(mappedInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized MultiOutput<InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            return new MultiOutput<InputT, OutputT>(this.fn, ImmutableMap.builder().putAll(this.sideInputs).putAll(sideInputs).build(), this.mainOutputTag, this.additionalOutputTags, this.fnDisplayData);
        }

        public @UnknownKeyFor @NonNull @Initialized MultiOutput<InputT, OutputT> withSideInput(@UnknownKeyFor @NonNull @Initialized String tagId, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollectionView) {
            return this.withSideInputs(Collections.singletonMap(tagId, pCollectionView));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input) {
            ParDo.validateWindowType(input, this.fn);
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
            ParDo.finishSpecifyingStateSpecs(this.fn, coderRegistry, schemaRegistry, input.getCoder());
            DoFnSignature signature = DoFnSignatures.getSignature(this.fn.getClass());
            if (signature.usesState() || signature.usesTimers()) {
                ParDo.validateStateApplicableForInput(input);
            }
            ParDo.validateSideInputTypes(this.sideInputs, this.fn);
            PCollectionTuple outputs = PCollectionTuple.ofPrimitiveOutputsInternal(input.getPipeline(), TupleTagList.of(this.mainOutputTag).and(this.additionalOutputTags.getAll()), Collections.emptyMap(), input.getWindowingStrategy(), input.isBounded().and(signature.isBoundedPerElement()));
            Coder<? extends InputT> inputCoder = input.getCoder();
            for (PCollection<?> out : outputs.getAll().values()) {
                try {
                    out.setCoder(coderRegistry.getCoder(out.getTypeDescriptor(), this.getFn().getInputTypeDescriptor(), inputCoder));
                }
                catch (CannotProvideCoderException cannotProvideCoderException) {}
            }
            outputs.get(this.mainOutputTag).setTypeDescriptor(this.getFn().getOutputTypeDescriptor());
            return outputs;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("ParMultiDo(%s)", NameUtils.approximateSimpleName(this.getFn()));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ParDo.populateDisplayData(builder, this.fn, this.fnDisplayData);
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
            return this.fn;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> getMainOutputTag() {
            return this.mainOutputTag;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTagList getAdditionalOutputTags() {
            return this.additionalOutputTags;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs.values());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.fn.toString();
        }
    }

    public static class SingleOutput<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
        private static final @UnknownKeyFor @NonNull @Initialized String MAIN_OUTPUT_TAG = "output";
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData;

        SingleOutput(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DisplayData.ItemSpec<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> fnDisplayData) {
            this.fn = fn;
            this.fnDisplayData = fnDisplayData;
            this.sideInputs = sideInputs;
        }

        public @UnknownKeyFor @NonNull @Initialized SingleOutput<InputT, OutputT> withSideInputs(PCollectionView<?> ... sideInputs) {
            return this.withSideInputs(Arrays.asList(sideInputs));
        }

        public @UnknownKeyFor @NonNull @Initialized SingleOutput<InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            Map<String, PCollectionView<?>> mappedInputs = StreamSupport.stream(sideInputs.spliterator(), false).collect(Collectors.toMap(v -> v.getTagInternal().getId(), v -> v));
            return this.withSideInputs(mappedInputs);
        }

        public @UnknownKeyFor @NonNull @Initialized SingleOutput<InputT, OutputT> withSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
            return new SingleOutput<InputT, OutputT>(this.fn, ImmutableMap.builder().putAll(this.sideInputs).putAll(sideInputs).build(), this.fnDisplayData);
        }

        public @UnknownKeyFor @NonNull @Initialized SingleOutput<InputT, OutputT> withSideInput(@UnknownKeyFor @NonNull @Initialized String tagId, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollectionView) {
            return this.withSideInputs(Collections.singletonMap(tagId, pCollectionView));
        }

        public @UnknownKeyFor @NonNull @Initialized MultiOutput<InputT, OutputT> withOutputTags(@UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags) {
            return new MultiOutput<InputT, OutputT>(this.fn, this.sideInputs, mainOutputTag, additionalOutputTags, this.fnDisplayData);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InputT> input) {
            SchemaRegistry schemaRegistry = input.getPipeline().getSchemaRegistry();
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            ParDo.finishSpecifyingStateSpecs(this.fn, coderRegistry, schemaRegistry, input.getCoder());
            TupleTag mainOutput = new TupleTag(MAIN_OUTPUT_TAG);
            PCollection res = ((PCollectionTuple)input.apply(this.withOutputTags(mainOutput, TupleTagList.empty()))).get(mainOutput);
            TypeDescriptor<OutputT> outputTypeDescriptor = this.getFn().getOutputTypeDescriptor();
            try {
                res.setSchema(schemaRegistry.getSchema(outputTypeDescriptor), outputTypeDescriptor, schemaRegistry.getToRowFunction(outputTypeDescriptor), schemaRegistry.getFromRowFunction(outputTypeDescriptor));
            }
            catch (NoSuchSchemaException e) {
                try {
                    res.setCoder(coderRegistry.getCoder(outputTypeDescriptor, this.getFn().getInputTypeDescriptor(), input.getCoder()));
                }
                catch (CannotProvideCoderException cannotProvideCoderException) {
                    // empty catch block
                }
            }
            return res;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("ParDo(%s)", NameUtils.approximateSimpleName(this.getFn()));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            ParDo.populateDisplayData(builder, this.fn, this.fnDisplayData);
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
            return this.fn;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs.values());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.fn.toString();
        }
    }
}

