/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class AfterWatermark {
    private static final @UnknownKeyFor @NonNull @Initialized String TO_STRING = "AfterWatermark.pastEndOfWindow()";

    private AfterWatermark() {
    }

    public static @UnknownKeyFor @NonNull @Initialized FromEndOfWindow pastEndOfWindow() {
        return new FromEndOfWindow();
    }

    public static class FromEndOfWindow
    extends Trigger.OnceTrigger {
        private FromEndOfWindow() {
            super(null);
        }

        public @UnknownKeyFor @NonNull @Initialized AfterWatermarkEarlyAndLate withEarlyFirings(@UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger earlyFirings) {
            Preconditions.checkNotNull(earlyFirings, "Must specify the trigger to use for early firings");
            return new AfterWatermarkEarlyAndLate(earlyFirings, null);
        }

        public @UnknownKeyFor @NonNull @Initialized AfterWatermarkEarlyAndLate withLateFirings(@UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger lateFirings) {
            Preconditions.checkNotNull(lateFirings, "Must specify the trigger to use for late firings");
            return new AfterWatermarkEarlyAndLate(Never.ever(), lateFirings);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return window.maxTimestamp();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized FromEndOfWindow getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
            return this;
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return AfterWatermark.TO_STRING;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj instanceof FromEndOfWindow;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getClass());
        }
    }

    public static class AfterWatermarkEarlyAndLate
    extends Trigger {
        private final @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger earlyTrigger;
        private final @Nullable @UnknownKeyFor @Initialized Trigger.OnceTrigger lateTrigger;

        public @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getEarlyTrigger() {
            return this.earlyTrigger;
        }

        public @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getLateTrigger() {
            return this.lateTrigger;
        }

        private AfterWatermarkEarlyAndLate(@UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger earlyTrigger, @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger lateTrigger) {
            super(lateTrigger == null ? ImmutableList.of(earlyTrigger) : ImmutableList.of(earlyTrigger, lateTrigger));
            this.earlyTrigger = Preconditions.checkNotNull(earlyTrigger, "earlyTrigger should not be null");
            this.lateTrigger = lateTrigger;
        }

        public @UnknownKeyFor @NonNull @Initialized AfterWatermarkEarlyAndLate withEarlyFirings(@UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger earlyTrigger) {
            return new AfterWatermarkEarlyAndLate(earlyTrigger, this.lateTrigger);
        }

        public @UnknownKeyFor @NonNull @Initialized AfterWatermarkEarlyAndLate withLateFirings(@UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger lateTrigger) {
            return new AfterWatermarkEarlyAndLate(this.earlyTrigger, lateTrigger);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger() {
            return new AfterWatermarkEarlyAndLate(this.earlyTrigger.getContinuationTrigger(), this.lateTrigger == null ? null : this.lateTrigger.getContinuationTrigger());
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
            throw new UnsupportedOperationException("Should not call getContinuationTrigger(List<Trigger>)");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return window.maxTimestamp();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean mayFinish() {
            return this.lateTrigger == null;
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            StringBuilder builder = new StringBuilder(AfterWatermark.TO_STRING);
            if (!(this.earlyTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null && !(this.lateTrigger instanceof Never.NeverTrigger)) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }
    }
}

