/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.construction.graph.FieldAccessVisitor;
import org.apache.beam.sdk.util.construction.graph.PCollectionOutputTagVisitor;
import org.apache.beam.sdk.util.construction.graph.ProjectionProducerVisitor;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectionPushdownOptimizer {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ProjectionPushdownOptimizer.class);

    public static void optimize(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        FieldAccessVisitor fieldAccessVisitor = new FieldAccessVisitor();
        pipeline.traverseTopologically(fieldAccessVisitor);
        ProjectionProducerVisitor pushdownProjectorVisitor = new ProjectionProducerVisitor(fieldAccessVisitor.getPCollectionFieldAccess());
        pipeline.traverseTopologically(pushdownProjectorVisitor);
        Map<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> pushdownOpportunities = pushdownProjectorVisitor.getPushdownOpportunities();
        PCollectionOutputTagVisitor outputTagVisitor = new PCollectionOutputTagVisitor(pushdownOpportunities);
        pipeline.traverseTopologically(outputTagVisitor);
        Map<ProjectionProducer<PTransform<?, ?>>, Map<TupleTag<?>, FieldAccessDescriptor>> taggedFieldAccess = outputTagVisitor.getTaggedFieldAccess();
        for (Map.Entry<ProjectionProducer<PTransform<?, ?>>, Map<TupleTag<?>, FieldAccessDescriptor>> entry : taggedFieldAccess.entrySet()) {
            for (Map.Entry<TupleTag<?>, FieldAccessDescriptor> outputFields : entry.getValue().entrySet()) {
                LOG.info("Optimizing transform {}: output {} will contain reduced field set {}", new Object[]{entry.getKey(), outputFields.getKey(), outputFields.getValue().fieldNamesAccessed()});
            }
            PTransformMatcher matcher = application -> application.getTransform() == entry.getKey();
            PushdownOverrideFactory overrideFactory = new PushdownOverrideFactory(entry.getValue());
            pipeline.replaceAll(ImmutableList.of(PTransformOverride.of(matcher, overrideFactory)));
        }
    }

    private static class PushdownOverrideFactory<@UnknownKeyFor OutputT extends @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor TransformT extends @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, OutputT>>
    implements PTransformOverrideFactory<PBegin, OutputT, TransformT> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> fields;

        PushdownOverrideFactory(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> fields) {
            this.fields = fields;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, OutputT> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, OutputT, TransformT> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), (PTransform)((ProjectionProducer)transform.getTransform()).actuateProjectionPushdown(this.fields));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, OutputT newOutput) {
            return outputs.entrySet().stream().map(oldOutput -> {
                PCollection newOutputPColl = newOutput.expand().size() == 1 ? (PCollection)Iterables.getOnlyElement(newOutput.expand().values()) : Preconditions.checkArgumentNotNull((PCollection)newOutput.expand().get(oldOutput.getKey()), "No PCollection found for output tag %s. Were output tags changed in actuateProjectionPushdown?", oldOutput.getKey());
                return new AbstractMap.SimpleEntry<PCollection, PTransformOverrideFactory.ReplacementOutput>(newOutputPColl, PTransformOverrideFactory.ReplacementOutput.of(TaggedPValue.ofExpandedValue((PCollection)oldOutput.getValue()), TaggedPValue.ofExpandedValue(newOutputPColl)));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

