/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics;

import com.google.bigtable.veneer.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DerivedDoubleCumulativeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DerivedDoubleGaugeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DerivedLongCumulativeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DerivedLongGaugeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DoubleCumulativeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.DoubleGaugeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.LongCumulativeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.LongGaugeImpl;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.Meter;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DerivedDoubleCumulative;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DerivedDoubleGauge;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DerivedLongCumulative;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DerivedLongGauge;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DoubleCumulative;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DoubleGauge;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LongCumulative;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LongGauge;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.MetricOptions;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.MetricRegistry;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.MetricProducer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MetricRegistryImpl
extends MetricRegistry {
    private final RegisteredMeters registeredMeters = new RegisteredMeters();
    private final MetricProducer metricProducer;
    private final Clock clock;

    MetricRegistryImpl(Clock clock) {
        this.metricProducer = new MetricProducerForRegistry(this.registeredMeters, clock);
        this.clock = clock;
    }

    @Override
    public LongGauge addLongGauge(String name, MetricOptions options) {
        LongGaugeImpl longGaugeMetric = new LongGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels());
        return (LongGauge)((Object)this.registeredMeters.registerMeter(name, longGaugeMetric));
    }

    @Override
    public DoubleGauge addDoubleGauge(String name, MetricOptions options) {
        DoubleGaugeImpl doubleGaugeMetric = new DoubleGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels());
        return (DoubleGauge)((Object)this.registeredMeters.registerMeter(name, doubleGaugeMetric));
    }

    @Override
    public DerivedLongGauge addDerivedLongGauge(String name, MetricOptions options) {
        DerivedLongGaugeImpl derivedLongGauge = new DerivedLongGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels());
        return (DerivedLongGauge)((Object)this.registeredMeters.registerMeter(name, derivedLongGauge));
    }

    @Override
    public DerivedDoubleGauge addDerivedDoubleGauge(String name, MetricOptions options) {
        DerivedDoubleGaugeImpl derivedDoubleGauge = new DerivedDoubleGaugeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels());
        return (DerivedDoubleGauge)((Object)this.registeredMeters.registerMeter(name, derivedDoubleGauge));
    }

    @Override
    public LongCumulative addLongCumulative(String name, MetricOptions options) {
        LongCumulativeImpl longCumulativeMetric = new LongCumulativeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels(), this.clock.now());
        return (LongCumulative)((Object)this.registeredMeters.registerMeter(name, longCumulativeMetric));
    }

    @Override
    public DoubleCumulative addDoubleCumulative(String name, MetricOptions options) {
        DoubleCumulativeImpl longCumulativeMetric = new DoubleCumulativeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels(), this.clock.now());
        return (DoubleCumulative)((Object)this.registeredMeters.registerMeter(name, longCumulativeMetric));
    }

    @Override
    public DerivedLongCumulative addDerivedLongCumulative(String name, MetricOptions options) {
        DerivedLongCumulativeImpl derivedLongCumulative = new DerivedLongCumulativeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels(), this.clock.now());
        return (DerivedLongCumulative)((Object)this.registeredMeters.registerMeter(name, derivedLongCumulative));
    }

    @Override
    public DerivedDoubleCumulative addDerivedDoubleCumulative(String name, MetricOptions options) {
        DerivedDoubleCumulativeImpl derivedDoubleCumulative = new DerivedDoubleCumulativeImpl((String)Preconditions.checkNotNull((Object)name, (Object)"name"), options.getDescription(), options.getUnit(), options.getLabelKeys(), options.getConstantLabels(), this.clock.now());
        return (DerivedDoubleCumulative)((Object)this.registeredMeters.registerMeter(name, derivedDoubleCumulative));
    }

    MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    private static final class MetricProducerForRegistry
    extends MetricProducer {
        private final RegisteredMeters registeredMeters;
        private final Clock clock;

        private MetricProducerForRegistry(RegisteredMeters registeredMeters, Clock clock) {
            this.registeredMeters = registeredMeters;
            this.clock = clock;
        }

        @Override
        public Collection<Metric> getMetrics() {
            Map meters = this.registeredMeters.getRegisteredMeters();
            if (meters.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Metric> metrics = new ArrayList<Metric>(meters.size());
            for (Map.Entry entry : meters.entrySet()) {
                Metric metric = ((Meter)entry.getValue()).getMetric(this.clock);
                if (metric == null) continue;
                metrics.add(metric);
            }
            return Collections.unmodifiableCollection(metrics);
        }
    }

    private static final class RegisteredMeters {
        private volatile Map<String, Meter> registeredMeters = Collections.emptyMap();

        private RegisteredMeters() {
        }

        private Map<String, Meter> getRegisteredMeters() {
            return this.registeredMeters;
        }

        private synchronized Meter registerMeter(String meterName, Meter meter) {
            Meter existingMeter = this.registeredMeters.get(meterName);
            if (existingMeter != null) {
                if (!existingMeter.getMetricDescriptor().equals(meter.getMetricDescriptor())) {
                    throw new IllegalArgumentException("A different metric with the same name already registered.");
                }
                return existingMeter;
            }
            LinkedHashMap<String, Meter> registeredMetersCopy = new LinkedHashMap<String, Meter>(this.registeredMeters);
            registeredMetersCopy.put(meterName, meter);
            this.registeredMeters = Collections.unmodifiableMap(registeredMetersCopy);
            return meter;
        }
    }
}

