/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class GoogleAppEngineRequestor
extends HttpRequestor {
    private final URLFetchService service;
    private final FetchOptions options;

    public GoogleAppEngineRequestor() {
        this(GoogleAppEngineRequestor.newDefaultOptions());
    }

    public GoogleAppEngineRequestor(FetchOptions options) {
        this(options, URLFetchServiceFactory.getURLFetchService());
    }

    public GoogleAppEngineRequestor(FetchOptions options, URLFetchService service) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.options = options;
        this.service = service;
    }

    public FetchOptions getOptions() {
        return this.options;
    }

    public URLFetchService getService() {
        return this.service;
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HTTPRequest request = this.newRequest(url, HTTPMethod.GET, headers);
        HTTPResponse response = this.service.fetch(request);
        return GoogleAppEngineRequestor.toRequestorResponse(response);
    }

    @Override
    public HttpRequestor.Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HTTPRequest request = this.newRequest(url, HTTPMethod.POST, headers);
        return new FetchServiceUploader(this.service, request, new ByteArrayOutputStream());
    }

    @Override
    public HttpRequestor.Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HTTPRequest request = this.newRequest(url, HTTPMethod.POST, headers);
        return new FetchServiceUploader(this.service, request, new ByteArrayOutputStream());
    }

    private HTTPRequest newRequest(String url, HTTPMethod method, Iterable<HttpRequestor.Header> headers) throws IOException {
        HTTPRequest request = new HTTPRequest(new URL(url), method, this.options);
        for (HttpRequestor.Header header : headers) {
            request.addHeader(new HTTPHeader(header.getKey(), header.getValue()));
        }
        return request;
    }

    public static FetchOptions newDefaultOptions() {
        return FetchOptions.Builder.withDefaults().validateCertificate().doNotFollowRedirects().disallowTruncate().setDeadline(Double.valueOf((double)(DEFAULT_CONNECT_TIMEOUT_MILLIS + DEFAULT_READ_TIMEOUT_MILLIS) / 1000.0));
    }

    private static HttpRequestor.Response toRequestorResponse(HTTPResponse response) {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (HTTPHeader header : response.getHeadersUncombined()) {
            ArrayList<String> existing = (ArrayList<String>)headers.get(header.getName());
            if (existing == null) {
                existing = new ArrayList<String>();
                headers.put(header.getName(), existing);
            }
            existing.add(header.getValue());
        }
        return new HttpRequestor.Response(response.getResponseCode(), new ByteArrayInputStream(response.getContent()), headers);
    }

    private static class FetchServiceUploader
    extends HttpRequestor.Uploader {
        private final URLFetchService service;
        private final ByteArrayOutputStream body;
        private HTTPRequest request;

        public FetchServiceUploader(URLFetchService service, HTTPRequest request, ByteArrayOutputStream body) {
            this.service = service;
            this.request = request;
            this.body = body;
        }

        @Override
        public OutputStream getBody() {
            return this.body;
        }

        @Override
        public void close() {
            if (this.request != null) {
                try {
                    this.body.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.request = null;
            }
        }

        @Override
        public void abort() {
            if (this.request == null) {
                throw new IllegalStateException("Uploader already closed.");
            }
            this.close();
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            if (this.request == null) {
                throw new IllegalStateException("Uploader already closed.");
            }
            this.request.setPayload(this.body.toByteArray());
            HTTPResponse response = this.service.fetch(this.request);
            HttpRequestor.Response requestorResponse = GoogleAppEngineRequestor.toRequestorResponse(response);
            this.close();
            if (this.progressListener != null) {
                this.progressListener.onProgress(this.request.getPayload().length);
            }
            return requestorResponse;
        }
    }
}

