/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_BigQueryIO_Write<T>
extends BigQueryIO.Write<T> {
    private final @Nullable ValueProvider<String> jsonTableRef;
    private final @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
    private final @Nullable SerializableFunction<T, TableRow> formatFunction;
    private final @Nullable SerializableFunction<T, TableRow> formatRecordOnFailureFunction;
    private final  @Nullable RowWriterFactory.AvroRowWriterFactory<T, ?, ?> avroRowWriterFactory;
    private final @Nullable SerializableFunction<@Nullable TableSchema, Schema> avroSchemaFactory;
    private final boolean useAvroLogicalTypes;
    private final @Nullable DynamicDestinations<T, ?> dynamicDestinations;
    private final @Nullable PCollectionView<Map<String, String>> schemaFromView;
    private final @Nullable ValueProvider<String> jsonSchema;
    private final @Nullable ValueProvider<String> jsonTimePartitioning;
    private final @Nullable ValueProvider<String> jsonClustering;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryIO.Write.WriteDisposition writeDisposition;
    private final Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private final @Nullable String tableDescription;
    private final boolean validate;
    private final BigQueryServices bigQueryServices;
    private final @Nullable Integer maxFilesPerBundle;
    private final @Nullable Long maxFileSize;
    private final int numFileShards;
    private final int numStorageWriteApiStreams;
    private final boolean propagateSuccessfulStorageApiWrites;
    private final int maxFilesPerPartition;
    private final long maxBytesPerPartition;
    private final @Nullable Duration triggeringFrequency;
    private final BigQueryIO.Write.Method method;
    private final @Nullable ValueProvider<String> loadJobProjectId;
    private final @Nullable InsertRetryPolicy failedInsertRetryPolicy;
    private final @Nullable ValueProvider<String> customGcsTempLocation;
    private final boolean extendedErrorInfo;
    private final Boolean skipInvalidRows;
    private final Boolean ignoreUnknownValues;
    private final Boolean ignoreInsertIds;
    private final int maxRetryJobs;
    private final @Nullable String kmsKey;
    private final @Nullable List<String> primaryKey;
    private final AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation;
    private final Boolean optimizeWrites;
    private final Boolean useBeamSchema;
    private final Boolean autoSharding;
    private final Boolean propagateSuccessful;
    private final Boolean autoSchemaUpdate;
    private final @Nullable Class<T> writeProtosClass;
    private final Boolean directWriteProtos;
    private final @Nullable SerializableFunction<T, String> deterministicRecordIdFn;
    private final @Nullable String writeTempDataset;
    private final @Nullable SerializableFunction<T, RowMutationInformation> rowMutationInformationFn;
    private final ErrorHandler<BadRecord, ?> badRecordErrorHandler;
    private final BadRecordRouter badRecordRouter;

    private AutoValue_BigQueryIO_Write(@Nullable ValueProvider<String> jsonTableRef, @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction, @Nullable SerializableFunction<T, TableRow> formatFunction, @Nullable SerializableFunction<T, TableRow> formatRecordOnFailureFunction,  @Nullable RowWriterFactory.AvroRowWriterFactory<T, ?, ?> avroRowWriterFactory, @Nullable SerializableFunction<@Nullable TableSchema, Schema> avroSchemaFactory, boolean useAvroLogicalTypes, @Nullable DynamicDestinations<T, ?> dynamicDestinations, @Nullable PCollectionView<Map<String, String>> schemaFromView, @Nullable ValueProvider<String> jsonSchema, @Nullable ValueProvider<String> jsonTimePartitioning, @Nullable ValueProvider<String> jsonClustering, BigQueryIO.Write.CreateDisposition createDisposition, BigQueryIO.Write.WriteDisposition writeDisposition, Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions, @Nullable String tableDescription, boolean validate, BigQueryServices bigQueryServices, @Nullable Integer maxFilesPerBundle, @Nullable Long maxFileSize, int numFileShards, int numStorageWriteApiStreams, boolean propagateSuccessfulStorageApiWrites, int maxFilesPerPartition, long maxBytesPerPartition, @Nullable Duration triggeringFrequency, BigQueryIO.Write.Method method, @Nullable ValueProvider<String> loadJobProjectId, @Nullable InsertRetryPolicy failedInsertRetryPolicy, @Nullable ValueProvider<String> customGcsTempLocation, boolean extendedErrorInfo, Boolean skipInvalidRows, Boolean ignoreUnknownValues, Boolean ignoreInsertIds, int maxRetryJobs, @Nullable String kmsKey, @Nullable List<String> primaryKey, AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation, Boolean optimizeWrites, Boolean useBeamSchema, Boolean autoSharding, Boolean propagateSuccessful, Boolean autoSchemaUpdate, @Nullable Class<T> writeProtosClass, Boolean directWriteProtos, @Nullable SerializableFunction<T, String> deterministicRecordIdFn, @Nullable String writeTempDataset, @Nullable SerializableFunction<T, RowMutationInformation> rowMutationInformationFn, ErrorHandler<BadRecord, ?> badRecordErrorHandler, BadRecordRouter badRecordRouter) {
        this.jsonTableRef = jsonTableRef;
        this.tableFunction = tableFunction;
        this.formatFunction = formatFunction;
        this.formatRecordOnFailureFunction = formatRecordOnFailureFunction;
        this.avroRowWriterFactory = avroRowWriterFactory;
        this.avroSchemaFactory = avroSchemaFactory;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.dynamicDestinations = dynamicDestinations;
        this.schemaFromView = schemaFromView;
        this.jsonSchema = jsonSchema;
        this.jsonTimePartitioning = jsonTimePartitioning;
        this.jsonClustering = jsonClustering;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.schemaUpdateOptions = schemaUpdateOptions;
        this.tableDescription = tableDescription;
        this.validate = validate;
        this.bigQueryServices = bigQueryServices;
        this.maxFilesPerBundle = maxFilesPerBundle;
        this.maxFileSize = maxFileSize;
        this.numFileShards = numFileShards;
        this.numStorageWriteApiStreams = numStorageWriteApiStreams;
        this.propagateSuccessfulStorageApiWrites = propagateSuccessfulStorageApiWrites;
        this.maxFilesPerPartition = maxFilesPerPartition;
        this.maxBytesPerPartition = maxBytesPerPartition;
        this.triggeringFrequency = triggeringFrequency;
        this.method = method;
        this.loadJobProjectId = loadJobProjectId;
        this.failedInsertRetryPolicy = failedInsertRetryPolicy;
        this.customGcsTempLocation = customGcsTempLocation;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.maxRetryJobs = maxRetryJobs;
        this.kmsKey = kmsKey;
        this.primaryKey = primaryKey;
        this.defaultMissingValueInterpretation = defaultMissingValueInterpretation;
        this.optimizeWrites = optimizeWrites;
        this.useBeamSchema = useBeamSchema;
        this.autoSharding = autoSharding;
        this.propagateSuccessful = propagateSuccessful;
        this.autoSchemaUpdate = autoSchemaUpdate;
        this.writeProtosClass = writeProtosClass;
        this.directWriteProtos = directWriteProtos;
        this.deterministicRecordIdFn = deterministicRecordIdFn;
        this.writeTempDataset = writeTempDataset;
        this.rowMutationInformationFn = rowMutationInformationFn;
        this.badRecordErrorHandler = badRecordErrorHandler;
        this.badRecordRouter = badRecordRouter;
    }

    @Override
    @Nullable ValueProvider<String> getJsonTableRef() {
        return this.jsonTableRef;
    }

    @Override
    @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> getTableFunction() {
        return this.tableFunction;
    }

    @Override
    @Nullable SerializableFunction<T, TableRow> getFormatFunction() {
        return this.formatFunction;
    }

    @Override
    @Nullable SerializableFunction<T, TableRow> getFormatRecordOnFailureFunction() {
        return this.formatRecordOnFailureFunction;
    }

    @Override
     @Nullable RowWriterFactory.AvroRowWriterFactory<T, ?, ?> getAvroRowWriterFactory() {
        return this.avroRowWriterFactory;
    }

    @Override
    @Nullable SerializableFunction<@Nullable TableSchema, Schema> getAvroSchemaFactory() {
        return this.avroSchemaFactory;
    }

    @Override
    boolean getUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    @Override
    @Nullable DynamicDestinations<T, ?> getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    @Override
    @Nullable PCollectionView<Map<String, String>> getSchemaFromView() {
        return this.schemaFromView;
    }

    @Override
    @Nullable ValueProvider<String> getJsonSchema() {
        return this.jsonSchema;
    }

    @Override
    @Nullable ValueProvider<String> getJsonTimePartitioning() {
        return this.jsonTimePartitioning;
    }

    @Override
    @Nullable ValueProvider<String> getJsonClustering() {
        return this.jsonClustering;
    }

    @Override
    BigQueryIO.Write.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    BigQueryIO.Write.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    Set<BigQueryIO.Write.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    @Override
    @Nullable String getTableDescription() {
        return this.tableDescription;
    }

    @Override
    boolean getValidate() {
        return this.validate;
    }

    @Override
    BigQueryServices getBigQueryServices() {
        return this.bigQueryServices;
    }

    @Override
    @Nullable Integer getMaxFilesPerBundle() {
        return this.maxFilesPerBundle;
    }

    @Override
    @Nullable Long getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    int getNumFileShards() {
        return this.numFileShards;
    }

    @Override
    int getNumStorageWriteApiStreams() {
        return this.numStorageWriteApiStreams;
    }

    @Override
    boolean getPropagateSuccessfulStorageApiWrites() {
        return this.propagateSuccessfulStorageApiWrites;
    }

    @Override
    int getMaxFilesPerPartition() {
        return this.maxFilesPerPartition;
    }

    @Override
    long getMaxBytesPerPartition() {
        return this.maxBytesPerPartition;
    }

    @Override
    @Nullable Duration getTriggeringFrequency() {
        return this.triggeringFrequency;
    }

    @Override
    public BigQueryIO.Write.Method getMethod() {
        return this.method;
    }

    @Override
    @Nullable ValueProvider<String> getLoadJobProjectId() {
        return this.loadJobProjectId;
    }

    @Override
    @Nullable InsertRetryPolicy getFailedInsertRetryPolicy() {
        return this.failedInsertRetryPolicy;
    }

    @Override
    @Nullable ValueProvider<String> getCustomGcsTempLocation() {
        return this.customGcsTempLocation;
    }

    @Override
    boolean getExtendedErrorInfo() {
        return this.extendedErrorInfo;
    }

    @Override
    Boolean getSkipInvalidRows() {
        return this.skipInvalidRows;
    }

    @Override
    Boolean getIgnoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    Boolean getIgnoreInsertIds() {
        return this.ignoreInsertIds;
    }

    @Override
    int getMaxRetryJobs() {
        return this.maxRetryJobs;
    }

    @Override
    @Nullable String getKmsKey() {
        return this.kmsKey;
    }

    @Override
    @Nullable List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    AppendRowsRequest.MissingValueInterpretation getDefaultMissingValueInterpretation() {
        return this.defaultMissingValueInterpretation;
    }

    @Override
    Boolean getOptimizeWrites() {
        return this.optimizeWrites;
    }

    @Override
    Boolean getUseBeamSchema() {
        return this.useBeamSchema;
    }

    @Override
    Boolean getAutoSharding() {
        return this.autoSharding;
    }

    @Override
    Boolean getPropagateSuccessful() {
        return this.propagateSuccessful;
    }

    @Override
    Boolean getAutoSchemaUpdate() {
        return this.autoSchemaUpdate;
    }

    @Override
    @Nullable Class<T> getWriteProtosClass() {
        return this.writeProtosClass;
    }

    @Override
    Boolean getDirectWriteProtos() {
        return this.directWriteProtos;
    }

    @Override
    @Nullable SerializableFunction<T, String> getDeterministicRecordIdFn() {
        return this.deterministicRecordIdFn;
    }

    @Override
    @Nullable String getWriteTempDataset() {
        return this.writeTempDataset;
    }

    @Override
    @Nullable SerializableFunction<T, RowMutationInformation> getRowMutationInformationFn() {
        return this.rowMutationInformationFn;
    }

    @Override
    ErrorHandler<BadRecord, ?> getBadRecordErrorHandler() {
        return this.badRecordErrorHandler;
    }

    @Override
    BadRecordRouter getBadRecordRouter() {
        return this.badRecordRouter;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryIO.Write) {
            BigQueryIO.Write that = (BigQueryIO.Write)((Object)o);
            return (this.jsonTableRef == null ? that.getJsonTableRef() == null : this.jsonTableRef.equals(that.getJsonTableRef())) && (this.tableFunction == null ? that.getTableFunction() == null : this.tableFunction.equals(that.getTableFunction())) && (this.formatFunction == null ? that.getFormatFunction() == null : this.formatFunction.equals(that.getFormatFunction())) && (this.formatRecordOnFailureFunction == null ? that.getFormatRecordOnFailureFunction() == null : this.formatRecordOnFailureFunction.equals(that.getFormatRecordOnFailureFunction())) && (this.avroRowWriterFactory == null ? that.getAvroRowWriterFactory() == null : this.avroRowWriterFactory.equals(that.getAvroRowWriterFactory())) && (this.avroSchemaFactory == null ? that.getAvroSchemaFactory() == null : this.avroSchemaFactory.equals(that.getAvroSchemaFactory())) && this.useAvroLogicalTypes == that.getUseAvroLogicalTypes() && (this.dynamicDestinations == null ? that.getDynamicDestinations() == null : this.dynamicDestinations.equals(that.getDynamicDestinations())) && (this.schemaFromView == null ? that.getSchemaFromView() == null : this.schemaFromView.equals(that.getSchemaFromView())) && (this.jsonSchema == null ? that.getJsonSchema() == null : this.jsonSchema.equals(that.getJsonSchema())) && (this.jsonTimePartitioning == null ? that.getJsonTimePartitioning() == null : this.jsonTimePartitioning.equals(that.getJsonTimePartitioning())) && (this.jsonClustering == null ? that.getJsonClustering() == null : this.jsonClustering.equals(that.getJsonClustering())) && this.createDisposition.equals((Object)that.getCreateDisposition()) && this.writeDisposition.equals((Object)that.getWriteDisposition()) && this.schemaUpdateOptions.equals(that.getSchemaUpdateOptions()) && (this.tableDescription == null ? that.getTableDescription() == null : this.tableDescription.equals(that.getTableDescription())) && this.validate == that.getValidate() && this.bigQueryServices.equals(that.getBigQueryServices()) && (this.maxFilesPerBundle == null ? that.getMaxFilesPerBundle() == null : this.maxFilesPerBundle.equals(that.getMaxFilesPerBundle())) && (this.maxFileSize == null ? that.getMaxFileSize() == null : this.maxFileSize.equals(that.getMaxFileSize())) && this.numFileShards == that.getNumFileShards() && this.numStorageWriteApiStreams == that.getNumStorageWriteApiStreams() && this.propagateSuccessfulStorageApiWrites == that.getPropagateSuccessfulStorageApiWrites() && this.maxFilesPerPartition == that.getMaxFilesPerPartition() && this.maxBytesPerPartition == that.getMaxBytesPerPartition() && (this.triggeringFrequency == null ? that.getTriggeringFrequency() == null : this.triggeringFrequency.equals((Object)that.getTriggeringFrequency())) && this.method.equals((Object)that.getMethod()) && (this.loadJobProjectId == null ? that.getLoadJobProjectId() == null : this.loadJobProjectId.equals(that.getLoadJobProjectId())) && (this.failedInsertRetryPolicy == null ? that.getFailedInsertRetryPolicy() == null : this.failedInsertRetryPolicy.equals(that.getFailedInsertRetryPolicy())) && (this.customGcsTempLocation == null ? that.getCustomGcsTempLocation() == null : this.customGcsTempLocation.equals(that.getCustomGcsTempLocation())) && this.extendedErrorInfo == that.getExtendedErrorInfo() && this.skipInvalidRows.equals(that.getSkipInvalidRows()) && this.ignoreUnknownValues.equals(that.getIgnoreUnknownValues()) && this.ignoreInsertIds.equals(that.getIgnoreInsertIds()) && this.maxRetryJobs == that.getMaxRetryJobs() && (this.kmsKey == null ? that.getKmsKey() == null : this.kmsKey.equals(that.getKmsKey())) && (this.primaryKey == null ? that.getPrimaryKey() == null : this.primaryKey.equals(that.getPrimaryKey())) && this.defaultMissingValueInterpretation.equals((Object)that.getDefaultMissingValueInterpretation()) && this.optimizeWrites.equals(that.getOptimizeWrites()) && this.useBeamSchema.equals(that.getUseBeamSchema()) && this.autoSharding.equals(that.getAutoSharding()) && this.propagateSuccessful.equals(that.getPropagateSuccessful()) && this.autoSchemaUpdate.equals(that.getAutoSchemaUpdate()) && (this.writeProtosClass == null ? that.getWriteProtosClass() == null : this.writeProtosClass.equals(that.getWriteProtosClass())) && this.directWriteProtos.equals(that.getDirectWriteProtos()) && (this.deterministicRecordIdFn == null ? that.getDeterministicRecordIdFn() == null : this.deterministicRecordIdFn.equals(that.getDeterministicRecordIdFn())) && (this.writeTempDataset == null ? that.getWriteTempDataset() == null : this.writeTempDataset.equals(that.getWriteTempDataset())) && (this.rowMutationInformationFn == null ? that.getRowMutationInformationFn() == null : this.rowMutationInformationFn.equals(that.getRowMutationInformationFn())) && this.badRecordErrorHandler.equals(that.getBadRecordErrorHandler()) && this.badRecordRouter.equals(that.getBadRecordRouter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jsonTableRef == null ? 0 : this.jsonTableRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableFunction == null ? 0 : this.tableFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.formatFunction == null ? 0 : this.formatFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.formatRecordOnFailureFunction == null ? 0 : this.formatRecordOnFailureFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.avroRowWriterFactory == null ? 0 : this.avroRowWriterFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.avroSchemaFactory == null ? 0 : this.avroSchemaFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.useAvroLogicalTypes ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.dynamicDestinations == null ? 0 : this.dynamicDestinations.hashCode();
        h$ *= 1000003;
        h$ ^= this.schemaFromView == null ? 0 : this.schemaFromView.hashCode();
        h$ *= 1000003;
        h$ ^= this.jsonSchema == null ? 0 : this.jsonSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.jsonTimePartitioning == null ? 0 : this.jsonTimePartitioning.hashCode();
        h$ *= 1000003;
        h$ ^= this.jsonClustering == null ? 0 : this.jsonClustering.hashCode();
        h$ *= 1000003;
        h$ ^= this.createDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeDisposition.hashCode();
        h$ *= 1000003;
        h$ ^= this.schemaUpdateOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableDescription == null ? 0 : this.tableDescription.hashCode();
        h$ *= 1000003;
        h$ ^= this.validate ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.bigQueryServices.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxFilesPerBundle == null ? 0 : this.maxFilesPerBundle.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxFileSize == null ? 0 : this.maxFileSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.numFileShards;
        h$ *= 1000003;
        h$ ^= this.numStorageWriteApiStreams;
        h$ *= 1000003;
        h$ ^= this.propagateSuccessfulStorageApiWrites ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxFilesPerPartition;
        h$ *= 1000003;
        h$ ^= (int)(this.maxBytesPerPartition >>> 32 ^ this.maxBytesPerPartition);
        h$ *= 1000003;
        h$ ^= this.triggeringFrequency == null ? 0 : this.triggeringFrequency.hashCode();
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.loadJobProjectId == null ? 0 : this.loadJobProjectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.failedInsertRetryPolicy == null ? 0 : this.failedInsertRetryPolicy.hashCode();
        h$ *= 1000003;
        h$ ^= this.customGcsTempLocation == null ? 0 : this.customGcsTempLocation.hashCode();
        h$ *= 1000003;
        h$ ^= this.extendedErrorInfo ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.skipInvalidRows.hashCode();
        h$ *= 1000003;
        h$ ^= this.ignoreUnknownValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.ignoreInsertIds.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxRetryJobs;
        h$ *= 1000003;
        h$ ^= this.kmsKey == null ? 0 : this.kmsKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.primaryKey == null ? 0 : this.primaryKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultMissingValueInterpretation.hashCode();
        h$ *= 1000003;
        h$ ^= this.optimizeWrites.hashCode();
        h$ *= 1000003;
        h$ ^= this.useBeamSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoSharding.hashCode();
        h$ *= 1000003;
        h$ ^= this.propagateSuccessful.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoSchemaUpdate.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeProtosClass == null ? 0 : this.writeProtosClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.directWriteProtos.hashCode();
        h$ *= 1000003;
        h$ ^= this.deterministicRecordIdFn == null ? 0 : this.deterministicRecordIdFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeTempDataset == null ? 0 : this.writeTempDataset.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowMutationInformationFn == null ? 0 : this.rowMutationInformationFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.badRecordErrorHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= this.badRecordRouter.hashCode();
    }

    @Override
    BigQueryIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends BigQueryIO.Write.Builder<T> {
        private @Nullable ValueProvider<String> jsonTableRef;
        private @Nullable SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;
        private @Nullable SerializableFunction<T, TableRow> formatFunction;
        private @Nullable SerializableFunction<T, TableRow> formatRecordOnFailureFunction;
        private  @Nullable RowWriterFactory.AvroRowWriterFactory<T, ?, ?> avroRowWriterFactory;
        private @Nullable SerializableFunction<@Nullable TableSchema, Schema> avroSchemaFactory;
        private Boolean useAvroLogicalTypes;
        private @Nullable DynamicDestinations<T, ?> dynamicDestinations;
        private @Nullable PCollectionView<Map<String, String>> schemaFromView;
        private @Nullable ValueProvider<String> jsonSchema;
        private @Nullable ValueProvider<String> jsonTimePartitioning;
        private @Nullable ValueProvider<String> jsonClustering;
        private BigQueryIO.Write.CreateDisposition createDisposition;
        private BigQueryIO.Write.WriteDisposition writeDisposition;
        private Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
        private @Nullable String tableDescription;
        private Boolean validate;
        private BigQueryServices bigQueryServices;
        private @Nullable Integer maxFilesPerBundle;
        private @Nullable Long maxFileSize;
        private Integer numFileShards;
        private Integer numStorageWriteApiStreams;
        private Boolean propagateSuccessfulStorageApiWrites;
        private Integer maxFilesPerPartition;
        private Long maxBytesPerPartition;
        private @Nullable Duration triggeringFrequency;
        private BigQueryIO.Write.Method method;
        private @Nullable ValueProvider<String> loadJobProjectId;
        private @Nullable InsertRetryPolicy failedInsertRetryPolicy;
        private @Nullable ValueProvider<String> customGcsTempLocation;
        private Boolean extendedErrorInfo;
        private Boolean skipInvalidRows;
        private Boolean ignoreUnknownValues;
        private Boolean ignoreInsertIds;
        private Integer maxRetryJobs;
        private @Nullable String kmsKey;
        private @Nullable List<String> primaryKey;
        private AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation;
        private Boolean optimizeWrites;
        private Boolean useBeamSchema;
        private Boolean autoSharding;
        private Boolean propagateSuccessful;
        private Boolean autoSchemaUpdate;
        private @Nullable Class<T> writeProtosClass;
        private Boolean directWriteProtos;
        private @Nullable SerializableFunction<T, String> deterministicRecordIdFn;
        private @Nullable String writeTempDataset;
        private @Nullable SerializableFunction<T, RowMutationInformation> rowMutationInformationFn;
        private ErrorHandler<BadRecord, ?> badRecordErrorHandler;
        private BadRecordRouter badRecordRouter;

        Builder() {
        }

        private Builder(BigQueryIO.Write<T> source) {
            this.jsonTableRef = source.getJsonTableRef();
            this.tableFunction = source.getTableFunction();
            this.formatFunction = source.getFormatFunction();
            this.formatRecordOnFailureFunction = source.getFormatRecordOnFailureFunction();
            this.avroRowWriterFactory = source.getAvroRowWriterFactory();
            this.avroSchemaFactory = source.getAvroSchemaFactory();
            this.useAvroLogicalTypes = source.getUseAvroLogicalTypes();
            this.dynamicDestinations = source.getDynamicDestinations();
            this.schemaFromView = source.getSchemaFromView();
            this.jsonSchema = source.getJsonSchema();
            this.jsonTimePartitioning = source.getJsonTimePartitioning();
            this.jsonClustering = source.getJsonClustering();
            this.createDisposition = source.getCreateDisposition();
            this.writeDisposition = source.getWriteDisposition();
            this.schemaUpdateOptions = source.getSchemaUpdateOptions();
            this.tableDescription = source.getTableDescription();
            this.validate = source.getValidate();
            this.bigQueryServices = source.getBigQueryServices();
            this.maxFilesPerBundle = source.getMaxFilesPerBundle();
            this.maxFileSize = source.getMaxFileSize();
            this.numFileShards = source.getNumFileShards();
            this.numStorageWriteApiStreams = source.getNumStorageWriteApiStreams();
            this.propagateSuccessfulStorageApiWrites = source.getPropagateSuccessfulStorageApiWrites();
            this.maxFilesPerPartition = source.getMaxFilesPerPartition();
            this.maxBytesPerPartition = source.getMaxBytesPerPartition();
            this.triggeringFrequency = source.getTriggeringFrequency();
            this.method = source.getMethod();
            this.loadJobProjectId = source.getLoadJobProjectId();
            this.failedInsertRetryPolicy = source.getFailedInsertRetryPolicy();
            this.customGcsTempLocation = source.getCustomGcsTempLocation();
            this.extendedErrorInfo = source.getExtendedErrorInfo();
            this.skipInvalidRows = source.getSkipInvalidRows();
            this.ignoreUnknownValues = source.getIgnoreUnknownValues();
            this.ignoreInsertIds = source.getIgnoreInsertIds();
            this.maxRetryJobs = source.getMaxRetryJobs();
            this.kmsKey = source.getKmsKey();
            this.primaryKey = source.getPrimaryKey();
            this.defaultMissingValueInterpretation = source.getDefaultMissingValueInterpretation();
            this.optimizeWrites = source.getOptimizeWrites();
            this.useBeamSchema = source.getUseBeamSchema();
            this.autoSharding = source.getAutoSharding();
            this.propagateSuccessful = source.getPropagateSuccessful();
            this.autoSchemaUpdate = source.getAutoSchemaUpdate();
            this.writeProtosClass = source.getWriteProtosClass();
            this.directWriteProtos = source.getDirectWriteProtos();
            this.deterministicRecordIdFn = source.getDeterministicRecordIdFn();
            this.writeTempDataset = source.getWriteTempDataset();
            this.rowMutationInformationFn = source.getRowMutationInformationFn();
            this.badRecordErrorHandler = source.getBadRecordErrorHandler();
            this.badRecordRouter = source.getBadRecordRouter();
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonTableRef(ValueProvider<String> jsonTableRef) {
            this.jsonTableRef = jsonTableRef;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setTableFunction(SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            this.tableFunction = tableFunction;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setFormatFunction(SerializableFunction<T, TableRow> formatFunction) {
            this.formatFunction = formatFunction;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setFormatRecordOnFailureFunction(SerializableFunction<T, TableRow> formatRecordOnFailureFunction) {
            this.formatRecordOnFailureFunction = formatRecordOnFailureFunction;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setAvroRowWriterFactory(RowWriterFactory.AvroRowWriterFactory<T, ?, ?> avroRowWriterFactory) {
            this.avroRowWriterFactory = avroRowWriterFactory;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setAvroSchemaFactory(SerializableFunction<@Nullable TableSchema, Schema> avroSchemaFactory) {
            this.avroSchemaFactory = avroSchemaFactory;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setUseAvroLogicalTypes(boolean useAvroLogicalTypes) {
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setDynamicDestinations(DynamicDestinations<T, ?> dynamicDestinations) {
            this.dynamicDestinations = dynamicDestinations;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setSchemaFromView(PCollectionView<Map<String, String>> schemaFromView) {
            this.schemaFromView = schemaFromView;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonSchema(ValueProvider<String> jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonTimePartitioning(ValueProvider<String> jsonTimePartitioning) {
            this.jsonTimePartitioning = jsonTimePartitioning;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setJsonClustering(ValueProvider<String> jsonClustering) {
            this.jsonClustering = jsonClustering;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setCreateDisposition(BigQueryIO.Write.CreateDisposition createDisposition) {
            if (createDisposition == null) {
                throw new NullPointerException("Null createDisposition");
            }
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setWriteDisposition(BigQueryIO.Write.WriteDisposition writeDisposition) {
            if (writeDisposition == null) {
                throw new NullPointerException("Null writeDisposition");
            }
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setSchemaUpdateOptions(Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
            if (schemaUpdateOptions == null) {
                throw new NullPointerException("Null schemaUpdateOptions");
            }
            this.schemaUpdateOptions = schemaUpdateOptions;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setTableDescription(String tableDescription) {
            this.tableDescription = tableDescription;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
            if (bigQueryServices == null) {
                throw new NullPointerException("Null bigQueryServices");
            }
            this.bigQueryServices = bigQueryServices;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxFilesPerBundle(Integer maxFilesPerBundle) {
            this.maxFilesPerBundle = maxFilesPerBundle;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxFileSize(Long maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setNumFileShards(int numFileShards) {
            this.numFileShards = numFileShards;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setNumStorageWriteApiStreams(int numStorageWriteApiStreams) {
            this.numStorageWriteApiStreams = numStorageWriteApiStreams;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setPropagateSuccessfulStorageApiWrites(boolean propagateSuccessfulStorageApiWrites) {
            this.propagateSuccessfulStorageApiWrites = propagateSuccessfulStorageApiWrites;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxFilesPerPartition(int maxFilesPerPartition) {
            this.maxFilesPerPartition = maxFilesPerPartition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxBytesPerPartition(long maxBytesPerPartition) {
            this.maxBytesPerPartition = maxBytesPerPartition;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setTriggeringFrequency(Duration triggeringFrequency) {
            this.triggeringFrequency = triggeringFrequency;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMethod(BigQueryIO.Write.Method method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setLoadJobProjectId(ValueProvider<String> loadJobProjectId) {
            this.loadJobProjectId = loadJobProjectId;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setFailedInsertRetryPolicy(InsertRetryPolicy failedInsertRetryPolicy) {
            this.failedInsertRetryPolicy = failedInsertRetryPolicy;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setCustomGcsTempLocation(ValueProvider<String> customGcsTempLocation) {
            this.customGcsTempLocation = customGcsTempLocation;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setExtendedErrorInfo(boolean extendedErrorInfo) {
            this.extendedErrorInfo = extendedErrorInfo;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setSkipInvalidRows(Boolean skipInvalidRows) {
            if (skipInvalidRows == null) {
                throw new NullPointerException("Null skipInvalidRows");
            }
            this.skipInvalidRows = skipInvalidRows;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
            if (ignoreUnknownValues == null) {
                throw new NullPointerException("Null ignoreUnknownValues");
            }
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setIgnoreInsertIds(Boolean ignoreInsertIds) {
            if (ignoreInsertIds == null) {
                throw new NullPointerException("Null ignoreInsertIds");
            }
            this.ignoreInsertIds = ignoreInsertIds;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setMaxRetryJobs(int maxRetryJobs) {
            this.maxRetryJobs = maxRetryJobs;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setKmsKey(@Nullable String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setPrimaryKey(@Nullable List<String> primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation) {
            if (defaultMissingValueInterpretation == null) {
                throw new NullPointerException("Null defaultMissingValueInterpretation");
            }
            this.defaultMissingValueInterpretation = defaultMissingValueInterpretation;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setOptimizeWrites(Boolean optimizeWrites) {
            if (optimizeWrites == null) {
                throw new NullPointerException("Null optimizeWrites");
            }
            this.optimizeWrites = optimizeWrites;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setUseBeamSchema(Boolean useBeamSchema) {
            if (useBeamSchema == null) {
                throw new NullPointerException("Null useBeamSchema");
            }
            this.useBeamSchema = useBeamSchema;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setAutoSharding(Boolean autoSharding) {
            if (autoSharding == null) {
                throw new NullPointerException("Null autoSharding");
            }
            this.autoSharding = autoSharding;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setPropagateSuccessful(Boolean propagateSuccessful) {
            if (propagateSuccessful == null) {
                throw new NullPointerException("Null propagateSuccessful");
            }
            this.propagateSuccessful = propagateSuccessful;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setAutoSchemaUpdate(Boolean autoSchemaUpdate) {
            if (autoSchemaUpdate == null) {
                throw new NullPointerException("Null autoSchemaUpdate");
            }
            this.autoSchemaUpdate = autoSchemaUpdate;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setWriteProtosClass(@Nullable Class<T> writeProtosClass) {
            this.writeProtosClass = writeProtosClass;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setDirectWriteProtos(Boolean directWriteProtos) {
            if (directWriteProtos == null) {
                throw new NullPointerException("Null directWriteProtos");
            }
            this.directWriteProtos = directWriteProtos;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setDeterministicRecordIdFn(SerializableFunction<T, String> deterministicRecordIdFn) {
            this.deterministicRecordIdFn = deterministicRecordIdFn;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setWriteTempDataset(String writeTempDataset) {
            this.writeTempDataset = writeTempDataset;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setRowMutationInformationFn(SerializableFunction<T, RowMutationInformation> rowMutationInformationFn) {
            this.rowMutationInformationFn = rowMutationInformationFn;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setBadRecordErrorHandler(ErrorHandler<BadRecord, ?> badRecordErrorHandler) {
            if (badRecordErrorHandler == null) {
                throw new NullPointerException("Null badRecordErrorHandler");
            }
            this.badRecordErrorHandler = badRecordErrorHandler;
            return this;
        }

        @Override
        BigQueryIO.Write.Builder<T> setBadRecordRouter(BadRecordRouter badRecordRouter) {
            if (badRecordRouter == null) {
                throw new NullPointerException("Null badRecordRouter");
            }
            this.badRecordRouter = badRecordRouter;
            return this;
        }

        @Override
        BigQueryIO.Write<T> build() {
            if (this.useAvroLogicalTypes == null || this.createDisposition == null || this.writeDisposition == null || this.schemaUpdateOptions == null || this.validate == null || this.bigQueryServices == null || this.numFileShards == null || this.numStorageWriteApiStreams == null || this.propagateSuccessfulStorageApiWrites == null || this.maxFilesPerPartition == null || this.maxBytesPerPartition == null || this.method == null || this.extendedErrorInfo == null || this.skipInvalidRows == null || this.ignoreUnknownValues == null || this.ignoreInsertIds == null || this.maxRetryJobs == null || this.defaultMissingValueInterpretation == null || this.optimizeWrites == null || this.useBeamSchema == null || this.autoSharding == null || this.propagateSuccessful == null || this.autoSchemaUpdate == null || this.directWriteProtos == null || this.badRecordErrorHandler == null || this.badRecordRouter == null) {
                StringBuilder missing = new StringBuilder();
                if (this.useAvroLogicalTypes == null) {
                    missing.append(" useAvroLogicalTypes");
                }
                if (this.createDisposition == null) {
                    missing.append(" createDisposition");
                }
                if (this.writeDisposition == null) {
                    missing.append(" writeDisposition");
                }
                if (this.schemaUpdateOptions == null) {
                    missing.append(" schemaUpdateOptions");
                }
                if (this.validate == null) {
                    missing.append(" validate");
                }
                if (this.bigQueryServices == null) {
                    missing.append(" bigQueryServices");
                }
                if (this.numFileShards == null) {
                    missing.append(" numFileShards");
                }
                if (this.numStorageWriteApiStreams == null) {
                    missing.append(" numStorageWriteApiStreams");
                }
                if (this.propagateSuccessfulStorageApiWrites == null) {
                    missing.append(" propagateSuccessfulStorageApiWrites");
                }
                if (this.maxFilesPerPartition == null) {
                    missing.append(" maxFilesPerPartition");
                }
                if (this.maxBytesPerPartition == null) {
                    missing.append(" maxBytesPerPartition");
                }
                if (this.method == null) {
                    missing.append(" method");
                }
                if (this.extendedErrorInfo == null) {
                    missing.append(" extendedErrorInfo");
                }
                if (this.skipInvalidRows == null) {
                    missing.append(" skipInvalidRows");
                }
                if (this.ignoreUnknownValues == null) {
                    missing.append(" ignoreUnknownValues");
                }
                if (this.ignoreInsertIds == null) {
                    missing.append(" ignoreInsertIds");
                }
                if (this.maxRetryJobs == null) {
                    missing.append(" maxRetryJobs");
                }
                if (this.defaultMissingValueInterpretation == null) {
                    missing.append(" defaultMissingValueInterpretation");
                }
                if (this.optimizeWrites == null) {
                    missing.append(" optimizeWrites");
                }
                if (this.useBeamSchema == null) {
                    missing.append(" useBeamSchema");
                }
                if (this.autoSharding == null) {
                    missing.append(" autoSharding");
                }
                if (this.propagateSuccessful == null) {
                    missing.append(" propagateSuccessful");
                }
                if (this.autoSchemaUpdate == null) {
                    missing.append(" autoSchemaUpdate");
                }
                if (this.directWriteProtos == null) {
                    missing.append(" directWriteProtos");
                }
                if (this.badRecordErrorHandler == null) {
                    missing.append(" badRecordErrorHandler");
                }
                if (this.badRecordRouter == null) {
                    missing.append(" badRecordRouter");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryIO_Write(this.jsonTableRef, this.tableFunction, this.formatFunction, this.formatRecordOnFailureFunction, this.avroRowWriterFactory, this.avroSchemaFactory, this.useAvroLogicalTypes, this.dynamicDestinations, this.schemaFromView, this.jsonSchema, this.jsonTimePartitioning, this.jsonClustering, this.createDisposition, this.writeDisposition, this.schemaUpdateOptions, this.tableDescription, this.validate, this.bigQueryServices, this.maxFilesPerBundle, this.maxFileSize, this.numFileShards, this.numStorageWriteApiStreams, this.propagateSuccessfulStorageApiWrites, this.maxFilesPerPartition, this.maxBytesPerPartition, this.triggeringFrequency, this.method, this.loadJobProjectId, this.failedInsertRetryPolicy, this.customGcsTempLocation, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.maxRetryJobs, this.kmsKey, this.primaryKey, this.defaultMissingValueInterpretation, this.optimizeWrites, this.useBeamSchema, this.autoSharding, this.propagateSuccessful, this.autoSchemaUpdate, this.writeProtosClass, this.directWriteProtos, this.deterministicRecordIdFn, this.writeTempDataset, this.rowMutationInformationFn, this.badRecordErrorHandler, this.badRecordRouter);
        }
    }
}

