/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class StorageApiConvertMessages<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollectionTuple> {
    private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedWritesTag;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successfulWritesTag;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> errorCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successCoder;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> rowMutationFn;
    private final @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter;

    public StorageApiConvertMessages(@UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedWritesTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successfulWritesTag, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> errorCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successCoder, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> rowMutationFn, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
        this.failedWritesTag = failedWritesTag;
        this.successfulWritesTag = successfulWritesTag;
        this.errorCoder = errorCoder;
        this.successCoder = successCoder;
        this.rowMutationFn = rowMutationFn;
        this.badRecordRouter = badRecordRouter;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        String operationName = input.getName() + "/" + this.getName();
        PCollectionTuple result = (PCollectionTuple)input.apply("Convert to message", (PTransform)ParDo.of(new ConvertMessagesDoFn<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, operationName, this.failedWritesTag, this.successfulWritesTag, this.rowMutationFn, this.badRecordRouter, input.getCoder())).withOutputTags(this.successfulWritesTag, TupleTagList.of((List)ImmutableList.of(this.failedWritesTag, (Object)BadRecordRouter.BAD_RECORD_TAG))).withSideInputs(this.dynamicDestinations.getSideInputs()));
        result.get(this.successfulWritesTag).setCoder(this.successCoder);
        result.get(this.failedWritesTag).setCoder(this.errorCoder);
        result.get(BadRecordRouter.BAD_RECORD_TAG).setCoder(BadRecord.getCoder((Pipeline)input.getPipeline()));
        return result;
    }

    public static class ConvertMessagesDoFn<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, StorageApiWritePayload>> {
        private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private @UnknownKeyFor @NonNull @Initialized TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedWritesTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successfulWritesTag;
        private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> rowMutationFn;
        private final @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter;
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> elementCoder;
        private transient @Nullable @UnknownKeyFor @Initialized BigQueryServices.DatasetService datasetServiceInternal = null;

        ConvertMessagesDoFn(@UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized String operationName, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedWritesTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successfulWritesTag, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> rowMutationFn, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> elementCoder) {
            this.dynamicDestinations = dynamicDestinations;
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.bqServices = bqServices;
            this.failedWritesTag = failedWritesTag;
            this.successfulWritesTag = successfulWritesTag;
            this.rowMutationFn = rowMutationFn;
            this.badRecordRouter = badRecordRouter;
            this.elementCoder = elementCoder;
        }

        private @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService getDatasetService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.datasetServiceInternal == null) {
                this.datasetServiceInternal = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.datasetServiceInternal;
        }

        @DoFn.Teardown
        public void onTeardown() {
            try {
                if (this.datasetServiceInternal != null) {
                    this.datasetServiceInternal.close();
                    this.datasetServiceInternal = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver o) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter = this.messageConverters.get(element.getKey(), this.dynamicDestinations, this.getDatasetService(pipelineOptions));
            RowMutationInformation rowMutationInformation = null;
            if (this.rowMutationFn != null) {
                rowMutationInformation = (RowMutationInformation)((SerializableFunction)Preconditions.checkStateNotNull(this.rowMutationFn)).apply(element.getValue());
            }
            try {
                StorageApiWritePayload payload = messageConverter.toMessage(element.getValue(), rowMutationInformation).withTimestamp(timestamp);
                o.get(this.successfulWritesTag).output((Object)KV.of((Object)element.getKey(), (Object)payload));
            }
            catch (TableRowToStorageApiProto.SchemaConversionException conversionException) {
                TableRow tableRow;
                try {
                    tableRow = messageConverter.toTableRow(element.getValue());
                }
                catch (Exception e) {
                    this.badRecordRouter.route(o, element, this.elementCoder, e, "Unable to convert value to TableRow");
                    return;
                }
                o.get(this.failedWritesTag).output((Object)new BigQueryStorageApiInsertError(tableRow, conversionException.toString()));
            }
            catch (Exception e) {
                this.badRecordRouter.route(o, element, this.elementCoder, e, "Unable to convert value to StorageWriteApiPayload");
            }
        }
    }
}

