/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteTables;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StreamingInserts<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    private @UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy;
    private @UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo;
    private final @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoSharding;
    private final @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful;
    private final @Nullable @UnknownKeyFor @Initialized String kmsKey;
    private final @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn;

    public StreamingInserts(@UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow) {
        this(createDisposition, dynamicDestinations, new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry(), false, false, false, false, false, true, elementCoder, toTableRow, toFailsafeTableRow, null, null);
    }

    private StreamingInserts(@UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized boolean autoSharding, @UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful, @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow, @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn, @Nullable @UnknownKeyFor @Initialized String kmsKey) {
        this.createDisposition = createDisposition;
        this.dynamicDestinations = dynamicDestinations;
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.autoSharding = autoSharding;
        this.propagateSuccessful = propagateSuccessful;
        this.elementCoder = elementCoder;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.deterministicRecordIdFn = deterministicRecordIdFn;
        this.kmsKey = kmsKey;
    }

    public @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    public @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withExtendedErrorInfo(@UnknownKeyFor @NonNull @Initialized boolean extendedErrorInfo) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withSkipInvalidRows(@UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withIgnoreUnknownValues(@UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withIgnoreInsertIds(@UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withAutoSharding(@UnknownKeyFor @NonNull @Initialized boolean autoSharding) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withSuccessfulInsertsPropagation(@UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withDeterministicRecordIdFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> deterministicRecordIdFn) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, deterministicRecordIdFn, this.kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized StreamingInserts<DestinationT, ElementT> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices) {
        return new StreamingInserts<DestinationT, ElementT>(this.createDisposition, this.dynamicDestinations, bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.autoSharding, this.propagateSuccessful, this.elementCoder, this.toTableRow, this.toFailsafeTableRow, this.deterministicRecordIdFn, this.kmsKey);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        PCollection writes = (PCollection)input.apply("CreateTables", new CreateTables(this.createDisposition, this.dynamicDestinations).withTestServices(this.bigQueryServices).withKmsKey(this.kmsKey));
        return (WriteResult)writes.apply(new StreamingWriteTables().withTestServices(this.bigQueryServices).withInsertRetryPolicy(this.retryPolicy).withExtendedErrorInfo(this.extendedErrorInfo).withSkipInvalidRows(this.skipInvalidRows).withIgnoreUnknownValues(this.ignoreUnknownValues).withIgnoreInsertIds(this.ignoreInsertIds).withAutoSharding(this.autoSharding).withPropagateSuccessful(this.propagateSuccessful).withElementCoder(this.elementCoder).withToTableRow(this.toTableRow).withToFailsafeTableRow(this.toFailsafeTableRow).withDeterministicRecordIdFn(this.deterministicRecordIdFn));
    }
}

