/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloserReference<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized AutoCloseable>
implements Supplier<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CloserReference.class);
    private final T object;

    public static <T extends AutoCloseable> @UnknownKeyFor @NonNull @Initialized CloserReference<T> of(T object) {
        return new CloserReference<T>(object);
    }

    @Override
    public T get() {
        return this.object;
    }

    private CloserReference(T object) {
        this.object = object;
    }

    protected void finalize() {
        SystemExecutors.getFuturesExecutor().execute(new Closer((AutoCloseable)this.object));
    }

    private static class Closer
    implements Runnable {
        private final @UnknownKeyFor @NonNull @Initialized AutoCloseable object;

        private Closer(@UnknownKeyFor @NonNull @Initialized AutoCloseable object) {
            this.object = object;
        }

        @Override
        public void run() {
            try {
                this.object.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close resource with class: " + this.object.getClass().getCanonicalName(), (Throwable)e);
            }
        }
    }
}

