/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.flink.adapter.BeamAdapterCoderUtils;
import org.apache.beam.runners.flink.adapter.FlinkInput;
import org.apache.beam.runners.flink.adapter.FlinkOutput;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.construction.PipelineTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BeamAdapterUtils {
    private BeamAdapterUtils() {
    }

    static <DataSetOrStreamT, ExecutionEnvironmentT, BeamInputT extends PInput, BeamOutputT extends POutput> @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, DataSetOrStreamT> applyBeamPTransformInternal(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends DataSetOrStreamT> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Pipeline, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>, BeamInputT> toBeamInput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<BeamOutputT, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> fromBeamOutput, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super BeamInputT, BeamOutputT> transform, ExecutionEnvironmentT executionEnvironment, @UnknownKeyFor @NonNull @Initialized boolean isBounded, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<DataSetOrStreamT, @UnknownKeyFor @NonNull @Initialized TypeInformation<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getTypeInformation, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry, @UnknownKeyFor @NonNull @Initialized PipelineFragmentTranslator<DataSetOrStreamT, ExecutionEnvironmentT> translator) {
        Pipeline pipeline = Pipeline.create();
        ImmutableMap beamInputs = ImmutableMap.copyOf((Map)Maps.transformEntries(inputs, (key, flinkInput) -> (PCollection)pipeline.apply(new FlinkInput((String)key, BeamAdapterCoderUtils.typeInformationToCoder((TypeInformation)getTypeInformation.apply(Preconditions.checkArgumentNotNull((Object)flinkInput)), coderRegistry), isBounded))));
        Map<String, PCollection<?>> beamOutputs = fromBeamOutput.apply(BeamAdapterUtils.applyTransform((PInput)toBeamInput.apply(pipeline, (Map<String, PCollection<?>>)beamInputs), transform));
        beamOutputs.entrySet().stream().forEach(e -> ((PCollection)e.getValue()).apply(new FlinkOutput((String)e.getKey())));
        ((PortablePipelineOptions)pipelineOptions.as(PortablePipelineOptions.class)).setDefaultEnvironmentType("EMBEDDED");
        SdkComponents components = SdkComponents.create((PipelineOptions)pipelineOptions);
        RunnerApi.Pipeline pipelineProto = PipelineTranslation.toProto((Pipeline)pipeline, (SdkComponents)components);
        return translator.translate(inputs, pipelineProto, executionEnvironment);
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> tupleToMap(@UnknownKeyFor @NonNull @Initialized PCollectionTuple tuple) {
        return tuple.getAll().entrySet().stream().collect(Collectors.toMap(e -> ((TupleTag)e.getKey()).getId(), e -> (PCollection)e.getValue()));
    }

    static @UnknownKeyFor @NonNull @Initialized PCollectionTuple mapToTuple(@UnknownKeyFor @NonNull @Initialized Pipeline p, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> map) {
        PCollectionTuple tuple = PCollectionTuple.empty((Pipeline)p);
        for (Map.Entry<String, PCollection<?>> entry : map.entrySet()) {
            tuple = tuple.and(entry.getKey(), entry.getValue());
        }
        return tuple;
    }

    private static <BeamInputT extends PInput, BeamOutputT extends POutput> BeamOutputT applyTransform(BeamInputT beamInput, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super BeamInputT, BeamOutputT> transform) {
        if (beamInput instanceof PCollection) {
            return (BeamOutputT)((PCollection)beamInput).apply(transform);
        }
        if (beamInput instanceof PCollectionTuple) {
            return (BeamOutputT)((PCollectionTuple)beamInput).apply(transform);
        }
        if (beamInput instanceof PBegin) {
            return (BeamOutputT)((PBegin)beamInput).apply(transform);
        }
        throw new IllegalArgumentException("Unknown Beam input type " + beamInput.getClass().getTypeName() + " for " + beamInput);
    }

    static interface PipelineFragmentTranslator<@UnknownKeyFor DataSetOrStreamT, @UnknownKeyFor ExecutionEnvironmentT> {
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, DataSetOrStreamT> translate(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends DataSetOrStreamT> var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline var2, ExecutionEnvironmentT var3);
    }
}

