/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.Closeable;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintsBuffer;
import org.apache.cassandra.utils.concurrent.BlockingQueues;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

final class HintsBufferPool
implements Closeable {
    static final int MAX_ALLOCATED_BUFFERS = Integer.getInteger("cassandra.MAX_HINT_BUFFERS", 3);
    private volatile HintsBuffer currentBuffer;
    private final BlockingQueue<HintsBuffer> reserveBuffers = BlockingQueues.newBlockingQueue();
    private final int bufferSize;
    private final FlushCallback flushCallback;
    private int allocatedBuffers = 0;

    HintsBufferPool(int bufferSize, FlushCallback flushCallback) {
        this.bufferSize = bufferSize;
        this.flushCallback = flushCallback;
    }

    void write(Iterable<UUID> hostIds, Hint hint) {
        int hintSize = (int)Hint.serializer.serializedSize(hint, 12);
        try (HintsBuffer.Allocation allocation = this.allocate(hintSize);){
            allocation.write(hostIds, hint);
        }
    }

    long getEarliestHintForHost(UUID hostId) {
        long min = this.currentBuffer().getEarliestHintTime(hostId);
        Iterator it = this.reserveBuffers.iterator();
        while (it.hasNext()) {
            min = Math.min(min, ((HintsBuffer)it.next()).getEarliestHintTime(hostId));
        }
        return min;
    }

    private HintsBuffer.Allocation allocate(int hintSize) {
        HintsBuffer current = this.currentBuffer();
        HintsBuffer.Allocation allocation;
        while ((allocation = current.allocate(hintSize)) == null) {
            if (this.switchCurrentBuffer(current)) {
                this.flushCallback.flush(current, this);
            }
            current = this.currentBuffer;
        }
        return allocation;
    }

    void offer(HintsBuffer buffer) {
        if (!this.reserveBuffers.offer(buffer)) {
            throw new RuntimeException("Failed to store buffer");
        }
    }

    HintsBuffer currentBuffer() {
        if (this.currentBuffer == null) {
            this.initializeCurrentBuffer();
        }
        return this.currentBuffer;
    }

    private synchronized void initializeCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.createBuffer();
        }
    }

    private synchronized boolean switchCurrentBuffer(HintsBuffer previous) {
        if (this.currentBuffer != previous) {
            return false;
        }
        HintsBuffer buffer = (HintsBuffer)this.reserveBuffers.poll();
        if (buffer == null && this.allocatedBuffers >= MAX_ALLOCATED_BUFFERS) {
            try {
                buffer = this.reserveBuffers.take();
            }
            catch (InterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        }
        this.currentBuffer = buffer == null ? this.createBuffer() : buffer;
        return true;
    }

    private HintsBuffer createBuffer() {
        ++this.allocatedBuffers;
        return HintsBuffer.create(this.bufferSize);
    }

    @Override
    public void close() {
        this.currentBuffer.free();
    }

    static interface FlushCallback {
        public void flush(HintsBuffer var1, HintsBufferPool var2);
    }
}

