/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.endpointdiscovery;

import com.amazonaws.cache.CacheLoader;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryRefreshCache;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.endpointdiscovery.AmazonDynamoDBEndpointCacheLoader;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonDynamoDBEndpointCache
extends EndpointDiscoveryRefreshCache<String> {
    private static final Log log = LogFactory.getLog(AmazonDynamoDBEndpointCache.class);

    public AmazonDynamoDBEndpointCache(AmazonDynamoDB client) {
        super((CacheLoader)new AmazonDynamoDBEndpointCacheLoader(client));
    }

    public URI get(String key, boolean required, URI defaultEndpoint) {
        URI endpoint = (URI)this.cache.get(key);
        if (endpoint != null) {
            return endpoint;
        }
        if (!required) {
            this.cache.put(key, defaultEndpoint);
        }
        return this.discoverEndpoint(key, required, defaultEndpoint);
    }

    public URI put(String key, Map<String, String> endpointDetails, URI defaultEndpoint) {
        URI discoveredEndpoint = URI.create(String.format("%s://%s", defaultEndpoint.getScheme(), endpointDetails.get("Endpoint")));
        this.cache.put(key, discoveredEndpoint);
        this.loadAndScheduleEvict(key, Long.valueOf(endpointDetails.get("CachePeriod")), TimeUnit.MINUTES);
        log.debug((Object)("Cached new endpoint from service: " + discoveredEndpoint.toASCIIString()));
        log.debug((Object)("Cached endpoint TTL: " + endpointDetails.get("CachePeriod") + " minutes"));
        return discoveredEndpoint;
    }
}

