/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.PickFirstLoadBalancer;
import java.util.Map;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "pick_first";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PickFirstLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            return NameResolver.ConfigOrError.fromConfig((Object)new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(JsonUtil.getBoolean(rawLoadBalancingPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY)));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }
}

