/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;

public class CqlVector<T> {
    private final ImmutableList<T> values;

    private CqlVector(ImmutableList<T> values) {
        this.values = values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Iterable<T> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CqlVector) {
            CqlVector that = (CqlVector)o;
            return this.values.equals(that.values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values.toArray());
    }

    public String toString() {
        String contents = Joiner.on((String)", ").join(this.values);
        return "CqlVector{" + contents + '}';
    }

    public static class Builder<T> {
        private ImmutableList.Builder<T> listBuilder = new ImmutableList.Builder();

        private Builder() {
        }

        public Builder add(T element) {
            this.listBuilder.add(element);
            return this;
        }

        public Builder add(T ... elements) {
            this.listBuilder.addAll((Iterator)Iterators.forArray((Object[])elements));
            return this;
        }

        public Builder addAll(Iterable<T> iter) {
            this.listBuilder.addAll(iter);
            return this;
        }

        public CqlVector<T> build() {
            return new CqlVector(this.listBuilder.build());
        }
    }
}

