/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Deploy$;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;

public final class SparkCuratorUtil$
implements Logging {
    public static SparkCuratorUtil$ MODULE$;
    private final int ZK_CONNECTION_TIMEOUT_MILLIS;
    private final int ZK_SESSION_TIMEOUT_MILLIS;
    private final int RETRY_WAIT_MILLIS;
    private final int MAX_RECONNECT_ATTEMPTS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkCuratorUtil$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int ZK_CONNECTION_TIMEOUT_MILLIS() {
        return this.ZK_CONNECTION_TIMEOUT_MILLIS;
    }

    private int ZK_SESSION_TIMEOUT_MILLIS() {
        return this.ZK_SESSION_TIMEOUT_MILLIS;
    }

    private int RETRY_WAIT_MILLIS() {
        return this.RETRY_WAIT_MILLIS;
    }

    private int MAX_RECONNECT_ATTEMPTS() {
        return this.MAX_RECONNECT_ATTEMPTS;
    }

    public CuratorFramework newClient(SparkConf conf, String zkUrlConf) {
        String ZK_URL = conf.get(zkUrlConf);
        CuratorFramework zk = CuratorFrameworkFactory.newClient((String)ZK_URL, (int)this.ZK_SESSION_TIMEOUT_MILLIS(), (int)this.ZK_CONNECTION_TIMEOUT_MILLIS(), (RetryPolicy)new ExponentialBackoffRetry(this.RETRY_WAIT_MILLIS(), this.MAX_RECONNECT_ATTEMPTS()));
        zk.start();
        return zk;
    }

    public String newClient$default$2() {
        return Deploy$.MODULE$.ZOOKEEPER_URL().key();
    }

    public void mkdir(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) == null) {
            try {
                zk.create().creatingParentsIfNeeded().forPath(path);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
            }
            catch (Exception e) {
                throw e;
            }
            return;
        }
    }

    public void deleteRecursive(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)zk.getChildren().forPath(path)).asScala()).foreach((Function1 & java.io.Serializable & Serializable)child -> (Void)zk.delete().forPath(new StringBuilder(1).append(path).append("/").append((String)child).toString()));
            zk.delete().forPath(path);
            return;
        }
    }

    private SparkCuratorUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ZK_CONNECTION_TIMEOUT_MILLIS = 15000;
        this.ZK_SESSION_TIMEOUT_MILLIS = 60000;
        this.RETRY_WAIT_MILLIS = 5000;
        this.MAX_RECONNECT_ATTEMPTS = 3;
    }
}

