/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mapred;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.java8.JFunction0;

public final class SparkHadoopMapRedUtil$
implements Logging {
    public static SparkHadoopMapRedUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkHadoopMapRedUtil$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void commitTask(OutputCommitter committer, TaskAttemptContext mrTaskContext, int jobId, int splitId) {
        TaskAttemptID mrTaskAttemptID = mrTaskContext.getTaskAttemptID();
        if (committer.needsTaskCommit(mrTaskContext)) {
            SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
            boolean shouldCoordinateWithDriver = sparkConf.getBoolean("spark.hadoop.outputCommitCoordination.enabled", true);
            if (shouldCoordinateWithDriver) {
                TaskContext ctx;
                OutputCommitCoordinator outputCommitCoordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean canCommit = outputCommitCoordinator.canCommit((ctx = TaskContext$.MODULE$.get()).stageId(), ctx.stageAttemptNumber(), splitId, ctx.attemptNumber());
                if (canCommit) {
                    this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
                    return;
                }
                String message = new StringBuilder(59).append(mrTaskAttemptID).append(": Not committed because the driver did not authorize commit").toString();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                committer.abortTask(mrTaskContext);
                throw new CommitDeniedException(message, ctx.stageId(), splitId, ctx.attemptNumber());
            }
            this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("No need to commit output of task because needsTaskCommit=false: ").append(mrTaskAttemptID).toString());
    }

    private final void performCommit$1(OutputCommitter committer$1, TaskAttemptContext mrTaskContext$1, TaskAttemptID mrTaskAttemptID$1) {
        try {
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> committer$1.commitTask(mrTaskContext$1));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long timeCost = tuple2._2$mcJ$sp();
            long timeCost2 = timeCost;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append(mrTaskAttemptID$1).append(": Committed. Elapsed time: ").append(timeCost2).append(" ms.").toString());
        }
        catch (IOException cause) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Error committing the output of task: ").append(mrTaskAttemptID$1).toString(), cause);
            committer$1.abortTask(mrTaskContext$1);
            throw cause;
        }
    }

    private SparkHadoopMapRedUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

