/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.status.AppStatusListener;
import org.apache.spark.status.AppStatusSource;
import org.apache.spark.status.AppStatusStore$;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.ApplicationEnvironmentInfoWrapper;
import org.apache.spark.status.ApplicationInfoWrapper;
import org.apache.spark.status.CachedQuantile;
import org.apache.spark.status.ExecutorStageSummaryWrapper;
import org.apache.spark.status.ExecutorSummaryWrapper;
import org.apache.spark.status.JobDataWrapper;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.PoolData;
import org.apache.spark.status.ProcessSummaryWrapper;
import org.apache.spark.status.RDDOperationGraphWrapper;
import org.apache.spark.status.RDDStorageInfoWrapper;
import org.apache.spark.status.ResourceProfileWrapper;
import org.apache.spark.status.SpeculationStageSummaryWrapper;
import org.apache.spark.status.StageDataWrapper;
import org.apache.spark.status.StreamBlockData;
import org.apache.spark.status.TaskDataWrapper;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorPeakMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.InputMetricDistributions;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.OutputMetricDistributions;
import org.apache.spark.status.api.v1.ProcessSummary;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ResourceProfileInfo;
import org.apache.spark.status.api.v1.ShufflePushReadMetricDistributions;
import org.apache.spark.status.api.v1.ShuffleReadMetricDistributions;
import org.apache.spark.status.api.v1.ShuffleWriteMetricDistributions;
import org.apache.spark.status.api.v1.SpeculationStageSummary;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011]c!B'O\u0001A3\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011A0\t\u0011!\u0004!\u0011!Q\u0001\n\u0001D\u0001\"\u001b\u0001\u0003\u0006\u0004%\tA\u001b\u0005\te\u0002\u0011\t\u0011)A\u0005W\"A1\u000f\u0001BC\u0002\u0013\u0005A\u000f\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003v\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002|\u0001!\t!! \t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a2\u0001\t\u0003\tI\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\b\"\u0003B\u0016\u0001E\u0005I\u0011\u0001B\u0017\u0011%\u0011\u0019\u0005AI\u0001\n\u0003\u0011i\u0003C\u0005\u0003F\u0001\t\n\u0011\"\u0001\u0003H!I!1\n\u0001\u0012\u0002\u0013\u0005!Q\n\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011%\u0011\t\u0007AI\u0001\n\u0003\u0011i\u0003C\u0005\u0003d\u0001\t\n\u0011\"\u0001\u0003N!I!Q\r\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005O\u0002\u0011\u0013!C\u0001\u0005\u000fBqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u0013\t\u0015\u0005!%A\u0005\u0002\t5\u0002\"\u0003BD\u0001E\u0005I\u0011\u0001B'\u0011%\u0011I\tAI\u0001\n\u0003\u0011i\u0003C\u0005\u0003\f\u0002\t\n\u0011\"\u0001\u0003H!9!Q\u0012\u0001\u0005\u0002\t=\u0005b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005G\u0003A\u0011\u0001BS\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003D\u0002!\tA!2\t\u000f\t\r\u0007\u0001\"\u0001\u0003X\"9!1\u0019\u0001\u0005\u0002\tE\b\"CB\u0003\u0001E\u0005I\u0011\u0001B'\u0011\u001d\t)\u000e\u0001C\u0001\u0007\u000fAqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004(\u0001!\ta!\u000b\t\u0013\r]\u0002!%A\u0005\u0002\t5\u0002bBB\u001d\u0001\u0011\u000511\b\u0005\b\u0007C\u0002A\u0011AB2\u0011%\u0019\u0019\bAI\u0001\n\u0003\u0011i\u0003C\u0005\u0004v\u0001\t\n\u0011\"\u0001\u0003N!I1q\u000f\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0007s\u0002\u0011\u0013!C\u0001\u0005\u000fBqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\u000e\u0002!\taa$\t\u000f\r}\u0005\u0001\"\u0001\u0004\"\"91q\u0015\u0001\u0005\u0002\r%\u0006bBBZ\u0001\u0011\u00051Q\u0017\u0005\b\u0007\u0013\u0004A\u0011ABf\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077Dqaa:\u0001\t\u0003\u0019I\u000fC\u0004\u0004r\u0002!\taa=\t\u000f\rm\b\u0001\"\u0003\u0004t\"91Q \u0001\u0005\u0002\r}x\u0001\u0003C\t\u001d\"\u0005\u0001\u000bb\u0005\u0007\u000f5s\u0005\u0012\u0001)\u0005\u0016!1q0\u0012C\u0001\tGA\u0011\u0002\"\nF\u0005\u0004%\t\u0001b\n\t\u0011\u0011%R\t)A\u0005\u0003\u000fCq\u0001b\u000bF\t\u0003!i\u0003C\u0005\u0005F\u0015\u000b\n\u0011\"\u0001\u0005H!IA1J#\u0012\u0002\u0013\u0005AQ\n\u0005\n\t#*\u0015\u0013!C\u0001\t'\u0012a\"\u00119q'R\fG/^:Ti>\u0014XM\u0003\u0002P!\u000611\u000f^1ukNT!!\u0015*\u0002\u000bM\u0004\u0018M]6\u000b\u0005M#\u0016AB1qC\u000eDWMC\u0001V\u0003\ry'oZ\n\u0003\u0001]\u0003\"\u0001W.\u000e\u0003eS\u0011AW\u0001\u0006g\u000e\fG.Y\u0005\u00039f\u0013a!\u00118z%\u00164\u0017!B:u_J,7\u0001A\u000b\u0002AB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\bWZ\u001cHo\u001c:f\u0015\t)\u0007+\u0001\u0003vi&d\u0017BA4c\u0005\u001dYek\u0015;pe\u0016\faa\u001d;pe\u0016\u0004\u0013\u0001\u00037jgR,g.\u001a:\u0016\u0003-\u00042\u0001\u00177o\u0013\ti\u0017L\u0001\u0004PaRLwN\u001c\t\u0003_Bl\u0011AT\u0005\u0003c:\u0013\u0011#\u00119q'R\fG/^:MSN$XM\\3s\u0003%a\u0017n\u001d;f]\u0016\u0014\b%A\u0005ti>\u0014X\rU1uQV\tQ\u000fE\u0002YYZ\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0005%|'\"A>\u0002\t)\fg/Y\u0005\u0003{b\u0014AAR5mK\u0006Q1\u000f^8sKB\u000bG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)!\t\u0019!!\u0002\u0002\b\u0005%\u0001CA8\u0001\u0011\u0015iv\u00011\u0001a\u0011\u001dIw\u0001%AA\u0002-Dqa]\u0004\u0011\u0002\u0003\u0007Q/A\bbaBd\u0017nY1uS>t\u0017J\u001c4p)\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0005Y\f$bAA\r\u001d\u0006\u0019\u0011\r]5\n\t\u0005u\u00111\u0003\u0002\u0010\u0003B\u0004H.[2bi&|g.\u00138g_\u0006yQM\u001c<je>tW.\u001a8u\u0013:4w\u000e\u0006\u0002\u0002$A!\u0011\u0011CA\u0013\u0013\u0011\t9#a\u0005\u00035\u0005\u0003\b\u000f\\5dCRLwN\\#om&\u0014xN\\7f]RLeNZ8\u0002'I,7o\\;sG\u0016\u0004&o\u001c4jY\u0016LeNZ8\u0015\u0005\u00055\u0002CBA\u0018\u0003\u007f\t)E\u0004\u0003\u00022\u0005mb\u0002BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]b,\u0001\u0004=e>|GOP\u0005\u00025&\u0019\u0011QH-\u0002\u000fA\f7m[1hK&!\u0011\u0011IA\"\u0005\r\u0019V-\u001d\u0006\u0004\u0003{I\u0006\u0003BA\t\u0003\u000fJA!!\u0013\u0002\u0014\t\u0019\"+Z:pkJ\u001cW\r\u0015:pM&dW-\u00138g_\u0006A!n\u001c2t\u0019&\u001cH\u000f\u0006\u0003\u0002P\u0005]\u0003CBA\u0018\u0003\u007f\t\t\u0006\u0005\u0003\u0002\u0012\u0005M\u0013\u0002BA+\u0003'\u0011qAS8c\t\u0006$\u0018\rC\u0004\u0002Z-\u0001\r!a\u0017\u0002\u0011M$\u0018\r^;tKN\u0004b!!\u0018\u0002b\u0005\u0015TBAA0\u0015\t)'0\u0003\u0003\u0002d\u0005}#\u0001\u0002'jgR\u0004B!a\u001a\u0002j5\t\u0001+C\u0002\u0002lA\u0013!CS8c\u000bb,7-\u001e;j_:\u001cF/\u0019;vg\u0006\u0019!n\u001c2\u0015\t\u0005E\u0013\u0011\u000f\u0005\b\u0003gb\u0001\u0019AA;\u0003\u0015QwNY%e!\rA\u0016qO\u0005\u0004\u0003sJ&aA%oi\u0006!\"n\u001c2XSRD\u0017i]:pG&\fG/\u001a3Tc2$B!a \u0002\u000eB9\u0001,!!\u0002R\u0005\u0015\u0015bAAB3\n1A+\u001e9mKJ\u0002B\u0001\u00177\u0002\bB\u0019\u0001,!#\n\u0007\u0005-\u0015L\u0001\u0003M_:<\u0007bBA:\u001b\u0001\u0007\u0011QO\u0001\rKb,7-\u001e;pe2K7\u000f\u001e\u000b\u0005\u0003'\u000bY\n\u0005\u0004\u00020\u0005}\u0012Q\u0013\t\u0005\u0003#\t9*\u0003\u0003\u0002\u001a\u0006M!aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=\t\u000f\u0005ue\u00021\u0001\u0002 \u0006Q\u0011m\u0019;jm\u0016|e\u000e\\=\u0011\u0007a\u000b\t+C\u0002\u0002$f\u0013qAQ8pY\u0016\fg.A\u0006sKBd\u0017mY3Fq\u0016\u001cG\u0003BAK\u0003SCq!a+\u0010\u0001\u0004\t)*\u0001\u0004pe&<\u0017N\\\u0001\u0014e\u0016\u0004H.Y2f\tJLg/\u001a:HGRKW.\u001a\u000b\t\u0003+\u000b\t,!.\u0002:\"9\u00111\u0017\tA\u0002\u0005U\u0015AB:pkJ\u001cW\rC\u0004\u00028B\u0001\r!!\"\u0002\u0017Q|G/\u00197HGRKW.\u001a\u0005\b\u0003w\u0003\u0002\u0019AAC\u00031!x\u000e^1m\u0003B\u0004H+[7f\u00035)\u0007\u0010\u001e:bGR<5\rV5nKR!\u0011QQAa\u0011\u001d\t\u0019,\u0005a\u0001\u0003+\u000ba\"\u001a=ue\u0006\u001cG/\u00119q)&lW-\u0006\u0002\u0002\u0006\u0006AR.[:dK2d\u0017M\\3pkN\u0004&o\\2fgNd\u0015n\u001d;\u0015\t\u0005-\u00171\u001b\t\u0007\u0003_\ty$!4\u0011\t\u0005E\u0011qZ\u0005\u0005\u0003#\f\u0019B\u0001\bQe>\u001cWm]:Tk6l\u0017M]=\t\u000f\u0005u5\u00031\u0001\u0002 \u0006yQ\r_3dkR|'oU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002\u0016\u0006e\u0007bBAn)\u0001\u0007\u0011Q\\\u0001\u000bKb,7-\u001e;pe&#\u0007\u0003BAp\u0003OtA!!9\u0002dB\u0019\u00111G-\n\u0007\u0005\u0015\u0018,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\fYO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003KL\u0016\u0001D1di&4Xm\u0015;bO\u0016\u001cHCAAy!\u0019\ty#a\u0010\u0002tB!\u0011\u0011CA{\u0013\u0011\t90a\u0005\u0003\u0013M#\u0018mZ3ECR\f\u0017!C:uC\u001e,G*[:u)1\t\t0!@\u0003\b\t-!q\u0002B\u0010\u0011\u001d\tIF\u0006a\u0001\u0003\u007f\u0004b!!\u0018\u0002b\t\u0005\u0001\u0003BA\t\u0005\u0007IAA!\u0002\u0002\u0014\tY1\u000b^1hKN#\u0018\r^;t\u0011%\u0011IA\u0006I\u0001\u0002\u0004\ty*A\u0004eKR\f\u0017\u000e\\:\t\u0013\t5a\u0003%AA\u0002\u0005}\u0015!D<ji\"\u001cV/\\7be&,7\u000fC\u0005\u0003\u0012Y\u0001\n\u00111\u0001\u0003\u0014\u0005\tRO\\:peR,G-U;b]RLG.Z:\u0011\u000ba\u0013)B!\u0007\n\u0007\t]\u0011LA\u0003BeJ\f\u0017\u0010E\u0002Y\u00057I1A!\bZ\u0005\u0019!u.\u001e2mK\"I!\u0011\u0005\f\u0011\u0002\u0003\u0007!1E\u0001\u000bi\u0006\u001c8n\u0015;biV\u001c\bCBA/\u0003C\u0012)\u0003\u0005\u0003\u0002\u0012\t\u001d\u0012\u0002\u0002B\u0015\u0003'\u0011!\u0002V1tWN#\u0018\r^;t\u0003M\u0019H/Y4f\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yC\u000b\u0003\u0002 \nE2F\u0001B\u001a!\u0011\u0011)Da\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu\u0012,\u0001\u0006b]:|G/\u0019;j_:LAA!\u0011\u00038\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'M$\u0018mZ3MSN$H\u0005Z3gCVdG\u000fJ\u001a\u0002'M$\u0018mZ3MSN$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%#\u0006\u0002B\n\u0005c\t1c\u001d;bO\u0016d\u0015n\u001d;%I\u00164\u0017-\u001e7uIU*\"Aa\u0014+\t\t\r\"\u0011G\u0001\ngR\fw-\u001a#bi\u0006$B\"!=\u0003V\te#1\fB/\u0005?BqAa\u0016\u001c\u0001\u0004\t)(A\u0004ti\u0006<W-\u00133\t\u0013\t%1\u0004%AA\u0002\u0005}\u0005\"\u0003B\u00117A\u0005\t\u0019\u0001B\u0012\u0011%\u0011ia\u0007I\u0001\u0002\u0004\ty\nC\u0005\u0003\u0012m\u0001\n\u00111\u0001\u0003\u0014\u0005\u00192\u000f^1hK\u0012\u000bG/\u0019\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u00192\u000f^1hK\u0012\u000bG/\u0019\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u00192\u000f^1hK\u0012\u000bG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00192\u000f^1hK\u0012\u000bG/\u0019\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0001B.Y:u'R\fw-Z!ui\u0016l\u0007\u000f\u001e\u000b\u0005\u0003g\u0014i\u0007C\u0004\u0003X\u0001\u0002\r!!\u001e\u0002\u0019M$\u0018mZ3BiR,W\u000e\u001d;\u0015\u001d\tM$q\u000fB=\u0005{\u0012yH!!\u0003\u0004B9\u0001,!!\u0002t\nU\u0004CBA\u0018\u0003\u007f\t)\bC\u0004\u0003X\u0005\u0002\r!!\u001e\t\u000f\tm\u0014\u00051\u0001\u0002v\u0005q1\u000f^1hK\u0006#H/Z7qi&#\u0007\"\u0003B\u0005CA\u0005\t\u0019AAP\u0011%\u0011\t#\tI\u0001\u0002\u0004\u0011\u0019\u0003C\u0005\u0003\u000e\u0005\u0002\n\u00111\u0001\u0002 \"I!\u0011C\u0011\u0011\u0002\u0003\u0007!1C\u0001\u0017gR\fw-Z!ui\u0016l\u0007\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u000512\u000f^1hK\u0006#H/Z7qi\u0012\"WMZ1vYR$C'\u0001\fti\u0006<W-\u0011;uK6\u0004H\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003Y\u0019H/Y4f\u0003R$X-\u001c9uI\u0011,g-Y;mi\u00122\u0014!\u0003;bg.\u001cu.\u001e8u)\u0019\t9I!%\u0003\u0014\"9!q\u000b\u0014A\u0002\u0005U\u0004b\u0002B>M\u0001\u0007\u0011QO\u0001\u0010Y>\u001c\u0017\r\\5usN+X.\\1ssR1!\u0011\u0014BP\u0005C\u0003\u0002\"a8\u0003\u001c\u0006u\u0017qQ\u0005\u0005\u0005;\u000bYOA\u0002NCBDqAa\u0016(\u0001\u0004\t)\bC\u0004\u0003|\u001d\u0002\r!!\u001e\u0002\u0017Q\f7o[*v[6\f'/\u001f\u000b\t\u0005O\u0013yK!-\u00034B!\u0001\f\u001cBU!\u0011\t\tBa+\n\t\t5\u00161\u0003\u0002\u0018)\u0006\u001c8.T3ue&\u001cG)[:ue&\u0014W\u000f^5p]NDqAa\u0016)\u0001\u0004\t)\bC\u0004\u0003|!\u0002\r!!\u001e\t\u000f\tE\u0001\u00061\u0001\u0003\u0014\u0005\u00192\u000f[8vY\u0012\u001c\u0015m\u00195f#V\fg\u000e^5mKR!\u0011q\u0014B]\u0011\u001d\u0011Y,\u000ba\u0001\u00053\t\u0011!]\u0001\u0011cV\fg\u000e^5mKR{7\u000b\u001e:j]\u001e$B!!8\u0003B\"9!1\u0018\u0016A\u0002\te\u0011\u0001\u0003;bg.d\u0015n\u001d;\u0015\u0011\t\u001d'q\u001aBi\u0005'\u0004b!a\f\u0002@\t%\u0007\u0003BA\t\u0005\u0017LAA!4\u0002\u0014\tAA+Y:l\t\u0006$\u0018\rC\u0004\u0003X-\u0002\r!!\u001e\t\u000f\tm4\u00061\u0001\u0002v!9!Q[\u0016A\u0002\u0005U\u0014\u0001C7bqR\u000b7o[:\u0015\u001d\t\u001d'\u0011\u001cBn\u0005;\u0014\tO!:\u0003p\"9!q\u000b\u0017A\u0002\u0005U\u0004b\u0002B>Y\u0001\u0007\u0011Q\u000f\u0005\b\u0005?d\u0003\u0019AA;\u0003\u0019ygMZ:fi\"9!1\u001d\u0017A\u0002\u0005U\u0014A\u00027f]\u001e$\b\u000eC\u0004\u0003h2\u0002\rA!;\u0002\rM|'\u000f\u001e\"z!\u0011\t\tBa;\n\t\t5\u00181\u0003\u0002\f)\u0006\u001c8nU8si&tw\rC\u0004\u0002Z1\u0002\rAa\t\u0015!\t\u001d'1\u001fB{\u0005o\u0014IPa?\u0003\u0000\u000e\r\u0001b\u0002B,[\u0001\u0007\u0011Q\u000f\u0005\b\u0005wj\u0003\u0019AA;\u0011\u001d\u0011y.\fa\u0001\u0003kBqAa9.\u0001\u0004\t)\bC\u0004\u0003h6\u0002\rA!@\u0011\tac\u0017Q\u001c\u0005\b\u0007\u0003i\u0003\u0019AAP\u0003%\t7oY3oI&tw\rC\u0005\u0002Z5\u0002\n\u00111\u0001\u0003$\u0005\u0011B/Y:l\u0019&\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00138)\u0019\u0019Ia!\u0005\u0004\u0014AA\u0011q\u001cBN\u0003;\u001cY\u0001\u0005\u0003\u0002\u0012\r5\u0011\u0002BB\b\u0003'\u0011A#\u0012=fGV$xN]*uC\u001e,7+^7nCJL\bb\u0002B,_\u0001\u0007\u0011Q\u000f\u0005\b\u0007+y\u0003\u0019AA;\u0003%\tG\u000f^3naRLE-\u0001\nta\u0016\u001cW\u000f\\1uS>t7+^7nCJLHCBB\u000e\u0007G\u0019)\u0003\u0005\u0003YY\u000eu\u0001\u0003BA\t\u0007?IAa!\t\u0002\u0014\t92\u000b]3dk2\fG/[8o'R\fw-Z*v[6\f'/\u001f\u0005\b\u0005/\u0002\u0004\u0019AA;\u0011\u001d\u0019)\u0002\ra\u0001\u0003k\nqA\u001d3e\u0019&\u001cH\u000f\u0006\u0003\u0004,\rM\u0002CBA\u0018\u0003\u007f\u0019i\u0003\u0005\u0003\u0002\u0012\r=\u0012\u0002BB\u0019\u0003'\u0011aB\u0015#E'R|'/Y4f\u0013:4w\u000eC\u0005\u00046E\u0002\n\u00111\u0001\u0002 \u0006Q1-Y2iK\u0012|e\u000e\\=\u0002#I$G\rT5ti\u0012\"WMZ1vYR$\u0013'\u0001\u0005bg>\u0003H/[8o+\u0011\u0019id!\u0012\u0015\t\r}2q\u000b\t\u000512\u001c\t\u0005\u0005\u0003\u0004D\r\u0015C\u0002\u0001\u0003\b\u0007\u000f\u001a$\u0019AB%\u0005\u0005!\u0016\u0003BB&\u0007#\u00022\u0001WB'\u0013\r\u0019y%\u0017\u0002\b\u001d>$\b.\u001b8h!\rA61K\u0005\u0004\u0007+J&aA!os\"A1\u0011L\u001a\u0005\u0002\u0004\u0019Y&\u0001\u0002g]B)\u0001l!\u0018\u0004B%\u00191qL-\u0003\u0011q\u0012\u0017P\\1nKz\nAB\\3x'R\fw-\u001a#bi\u0006$B\"a=\u0004f\r%4QNB8\u0007cBqaa\u001a5\u0001\u0004\t\u00190A\u0003ti\u0006<W\rC\u0005\u0004lQ\u0002\n\u00111\u0001\u0002 \u0006Qq/\u001b;i\t\u0016$\u0018-\u001b7\t\u0013\t\u0005B\u0007%AA\u0002\t\r\u0002\"\u0003B\u0007iA\u0005\t\u0019AAP\u0011%\u0011\t\u0002\u000eI\u0001\u0002\u0004\u0011\u0019\"\u0001\foK^\u001cF/Y4f\t\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00133\u0003YqWm^*uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\u001a\u0014A\u00068foN#\u0018mZ3ECR\fG\u0005Z3gCVdG\u000f\n\u001b\u0002-9,wo\u0015;bO\u0016$\u0015\r^1%I\u00164\u0017-\u001e7uIU\nAc\u001d;bO\u0016,\u00050Z2vi>\u00148+^7nCJLH\u0003CB@\u0007\u000f\u001bIia#\u0011\tac7\u0011\u0011\t\u0005\u0003#\u0019\u0019)\u0003\u0003\u0004\u0006\u0006M!\u0001H#yK\u000e,Ho\u001c:NKR\u0014\u0018nY:ESN$(/\u001b2vi&|gn\u001d\u0005\b\u0005/J\u0004\u0019AA;\u0011\u001d\u0011Y(\u000fa\u0001\u0003kBqA!\u0005:\u0001\u0004\u0011\u0019\"A\thKR\fV/\u00198uS2,7OV1mk\u0016$ba!%\u0004\u0018\u000em\u0005CBA\u0018\u0007'\u0013I\"\u0003\u0003\u0004\u0016\u0006\r#AC%oI\u0016DX\rZ*fc\"91\u0011\u0014\u001eA\u0002\rE\u0015A\u0002<bYV,7\u000fC\u0004\u0004\u001ej\u0002\rAa\u0005\u0002\u0013E,\u0018M\u001c;jY\u0016\u001c\u0018a\u0001:eIR!1QFBR\u0011\u001d\u0019)k\u000fa\u0001\u0003k\nQA\u001d3e\u0013\u0012\f\u0001c\u001d;sK\u0006l'\t\\8dWNd\u0015n\u001d;\u0015\u0005\r-\u0006CBA\u0018\u0003\u007f\u0019i\u000bE\u0002p\u0007_K1a!-O\u0005=\u0019FO]3b[\ncwnY6ECR\f\u0017AF8qKJ\fG/[8o\u000fJ\f\u0007\u000f\u001b$peN#\u0018mZ3\u0015\t\r]6q\u0019\t\u0005\u0007s\u001b\u0019-\u0004\u0002\u0004<*!1QXB`\u0003\u0015\u00198m\u001c9f\u0015\r\u0019\t\rU\u0001\u0003k&LAa!2\u0004<\n\t\"\u000b\u0012#Pa\u0016\u0014\u0018\r^5p]\u001e\u0013\u0018\r\u001d5\t\u000f\t]S\b1\u0001\u0002v\u0005!r\u000e]3sCRLwN\\$sCBDgi\u001c:K_\n$Ba!4\u0004XB11qZBk\u0007ok!a!5\u000b\u0007\rM\u0017,\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0004R\"9\u00111\u000f A\u0002\u0005U\u0014\u0001\u00029p_2$Ba!8\u0004dB\u0019qna8\n\u0007\r\u0005hJ\u0001\u0005Q_>dG)\u0019;b\u0011\u001d\u0019)o\u0010a\u0001\u0003;\fAA\\1nK\u0006Q\u0011\r\u001d9Tk6l\u0017M]=\u0015\u0005\r-\bcA8\u0004n&\u00191q\u001e(\u0003\u0015\u0005\u0003\boU;n[\u0006\u0014\u00180A\u0003dY>\u001cX\r\u0006\u0002\u0004vB\u0019\u0001la>\n\u0007\re\u0018L\u0001\u0003V]&$\u0018\u0001E2mK\u0006tW\u000b]*u_J,\u0007+\u0019;i\u0003U\u0019wN\\:ueV\u001cG\u000fV1tW\u0012\u000bG/\u0019'jgR$BAa2\u0005\u0002!9A1A\"A\u0002\u0011\u0015\u0011a\u0005;bg.$\u0015\r^1Xe\u0006\u0004\b/\u001a:Ji\u0016\u0014\bCBA\u0018\t\u000f!Y!\u0003\u0003\u0005\n\u0005\r#\u0001C%uKJ\f'\r\\3\u0011\u0007=$i!C\u0002\u0005\u00109\u0013q\u0002V1tW\u0012\u000bG/Y,sCB\u0004XM]\u0001\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f!\tyWi\u0005\u0003F/\u0012]\u0001\u0003\u0002C\r\t?i!\u0001b\u0007\u000b\u0007\u0011u\u0001+\u0001\u0005j]R,'O\\1m\u0013\u0011!\t\u0003b\u0007\u0003\u000f1{wmZ5oOR\u0011A1C\u0001\u0010\u0007V\u0013&+\u0012(U?Z+%kU%P\u001dV\u0011\u0011qQ\u0001\u0011\u0007V\u0013&+\u0012(U?Z+%kU%P\u001d\u0002\nqb\u0019:fCR,G*\u001b<f'R|'/\u001a\u000b\u0007\u0003\u0007!y\u0003\"\u000f\t\u000f\u0011E\u0012\n1\u0001\u00054\u0005!1m\u001c8g!\u0011\t9\u0007\"\u000e\n\u0007\u0011]\u0002KA\u0005Ta\u0006\u00148nQ8oM\"IA1H%\u0011\u0002\u0003\u0007AQH\u0001\u0010CB\u00048\u000b^1ukN\u001cv.\u001e:dKB!\u0001\f\u001cC !\ryG\u0011I\u0005\u0004\t\u0007r%aD!qaN#\u0018\r^;t'>,(oY3\u00023\r\u0014X-\u0019;f\u0019&4Xm\u0015;pe\u0016$C-\u001a4bk2$HEM\u000b\u0003\t\u0013RC\u0001\"\u0010\u00032\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"\u0001b\u0014+\u0007-\u0014\t$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\t+R3!\u001eB\u0019\u0001")
public class AppStatusStore {
    private final KVStore store;
    private final Option<AppStatusListener> listener;
    private final Option<File> storePath;

    public static Option<File> $lessinit$greater$default$3() {
        return AppStatusStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<AppStatusListener> $lessinit$greater$default$2() {
        return AppStatusStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<AppStatusSource> createLiveStore$default$2() {
        return AppStatusStore$.MODULE$.createLiveStore$default$2();
    }

    public static AppStatusStore createLiveStore(SparkConf sparkConf, Option<AppStatusSource> option) {
        return AppStatusStore$.MODULE$.createLiveStore(sparkConf, option);
    }

    public static long CURRENT_VERSION() {
        return AppStatusStore$.MODULE$.CURRENT_VERSION();
    }

    public KVStore store() {
        return this.store;
    }

    public Option<AppStatusListener> listener() {
        return this.listener;
    }

    public Option<File> storePath() {
        return this.storePath;
    }

    public ApplicationInfo applicationInfo() {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = (ApplicationInfo)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(ApplicationInfoWrapper.class).max(1L).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> ((ApplicationInfoWrapper)it.next()).info());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application information. If you are starting up Spark, please wait a while until it's ready.");
        }
        return applicationInfo;
    }

    public ApplicationEnvironmentInfo environmentInfo() {
        Class<ApplicationEnvironmentInfoWrapper> klass = ApplicationEnvironmentInfoWrapper.class;
        return ((ApplicationEnvironmentInfoWrapper)this.store().read(klass, (Object)klass.getName())).info();
    }

    public Seq<ResourceProfileInfo> resourceProfileInfo() {
        return KVUtils$.MODULE$.mapToSeq(this.store().view(ResourceProfileWrapper.class), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.rpInfo());
    }

    public Seq<JobData> jobsList(List<JobExecutionStatus> statuses) {
        Seq it = KVUtils$.MODULE$.mapToSeq(this.store().view(JobDataWrapper.class).reverse(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.info());
        if (statuses != null && !statuses.isEmpty()) {
            return (Seq)it.filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)job.status())));
        }
        return it;
    }

    public JobData job(int jobId) {
        return ((JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId))).info();
    }

    public Tuple2<JobData, Option<Object>> jobWithAssociatedSql(int jobId) {
        JobDataWrapper data = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        return new Tuple2((Object)data.info(), data.sqlExecutionId());
    }

    public Seq<ExecutorSummary> executorList(boolean activeOnly) {
        KVStoreView base = this.store().view(ExecutorSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return (Seq)((TraversableLike)KVUtils$.MODULE$.mapToSeq(filtered, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.info()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$executorList$2(x$4)))).map((Function1 & Serializable & scala.Serializable)origin -> this.replaceExec((ExecutorSummary)origin), Seq$.MODULE$.canBuildFrom());
    }

    private ExecutorSummary replaceExec(ExecutorSummary origin) {
        String string = origin.id();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.replaceDriverGcTime(origin, this.extractGcTime(origin), this.extractAppTime());
        }
        return origin;
    }

    private ExecutorSummary replaceDriverGcTime(ExecutorSummary source, Option<Object> totalGcTime, Option<Object> totalAppTime) {
        return new ExecutorSummary(source.id(), source.hostPort(), source.isActive(), source.rddBlocks(), source.memoryUsed(), source.diskUsed(), source.totalCores(), source.maxTasks(), source.activeTasks(), source.failedTasks(), source.completedTasks(), source.totalTasks(), BoxesRunTime.unboxToLong((Object)totalAppTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalDuration())), BoxesRunTime.unboxToLong((Object)totalGcTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalGCTime())), source.totalInputBytes(), source.totalShuffleRead(), source.totalShuffleWrite(), source.isBlacklisted(), source.maxMemory(), source.addTime(), source.removeTime(), source.removeReason(), source.executorLogs(), source.memoryMetrics(), source.blacklistedInStages(), source.peakMemoryMetrics(), source.attributes(), source.resources(), source.resourceProfileId(), source.isExcluded(), source.excludedInStages());
    }

    private Option<Object> extractGcTime(ExecutorSummary source) {
        return source.peakMemoryMetrics().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getMetricValue("TotalGCTime")));
    }

    private Option<Object> extractAppTime() {
        long startTime = 0L;
        long endTime = 0L;
        try {
            ApplicationInfo appInfo = this.applicationInfo();
            startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
            endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (endTime == 0L) {
            return None$.MODULE$;
        }
        if (endTime < 0L) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)));
        }
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(endTime - startTime)));
    }

    public Seq<ProcessSummary> miscellaneousProcessList(boolean activeOnly) {
        KVStoreView base = this.store().view(ProcessSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return KVUtils$.MODULE$.mapToSeq(filtered, (Function1 & Serializable & scala.Serializable)x$6 -> x$6.info());
    }

    public ExecutorSummary executorSummary(String executorId) {
        return ((ExecutorSummaryWrapper)this.store().read(ExecutorSummaryWrapper.class, (Object)executorId)).info();
    }

    public Seq<StageData> activeStages() {
        return (Seq)this.listener().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.activeStages()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<StageData> stageList(List<StageStatus> statuses, boolean details, boolean withSummaries, double[] unsortedQuantiles, List<TaskStatus> taskStatus) {
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Seq it = KVUtils$.MODULE$.mapToSeq(this.store().view(StageDataWrapper.class).reverse(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.info());
        Seq ret = statuses != null && !statuses.isEmpty() ? (Seq)it.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)s.status()))) : it;
        return (Seq)ret.map((Function1 & Serializable & scala.Serializable)s -> this.newStageData((StageData)s, details, taskStatus, withSummaries, quantiles), Seq$.MODULE$.canBuildFrom());
    }

    public boolean stageList$default$2() {
        return false;
    }

    public boolean stageList$default$3() {
        return false;
    }

    public double[] stageList$default$4() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public List<TaskStatus> stageList$default$5() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Seq<StageData> stageData(int stageId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        return KVUtils$.MODULE$.mapToSeq(this.store().view(StageDataWrapper.class).index("stageId").first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId)), (Function1 & Serializable & scala.Serializable)s -> this.newStageData(s.info(), details, taskStatus, withSummaries, unsortedQuantiles));
    }

    public boolean stageData$default$2() {
        return false;
    }

    public List<TaskStatus> stageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageData$default$4() {
        return false;
    }

    public double[] stageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public StageData lastStageAttempt(int stageId) {
        StageData stageData;
        block4: {
            try (KVStoreIterator it = this.store().view(StageDataWrapper.class).index("stageId").reverse().first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId)).closeableIterator();){
                if (it.hasNext()) {
                    stageData = ((StageDataWrapper)it.next()).info();
                    break block4;
                }
                throw new NoSuchElementException(new StringBuilder(17).append("No stage with id ").append(stageId).toString());
            }
        }
        return stageData;
    }

    public Tuple2<StageData, Seq<Object>> stageAttempt(int stageId, int stageAttemptId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        StageDataWrapper stageDataWrapper = (StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)stageKey);
        StageData stage = this.newStageData(stageDataWrapper.info(), details, taskStatus, withSummaries, unsortedQuantiles);
        return new Tuple2((Object)stage, (Object)stageDataWrapper.jobIds().toSeq());
    }

    public boolean stageAttempt$default$3() {
        return false;
    }

    public List<TaskStatus> stageAttempt$default$4() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageAttempt$default$5() {
        return false;
    }

    public double[] stageAttempt$default$6() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public long taskCount(int stageId, int stageAttemptId) {
        return this.store().count(TaskDataWrapper.class, "stage", (Object)new int[]{stageId, stageAttemptId});
    }

    public Map<String, Object> localitySummary(int stageId, int stageAttemptId) {
        return ((StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)new int[]{stageId, stageAttemptId})).locality();
    }

    public Option<TaskMetricDistributions> taskSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        long count = BoxesRunTime.unboxToLong(Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey).index("ert").first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$2(it))));
        if (count <= 0L) {
            return None$.MODULE$;
        }
        CachedQuantile[] cachedQuantiles = (CachedQuantile[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)q -> this.shouldCacheQuantile(q)))).flatMap((Function1 & Serializable & scala.Serializable)q -> AppStatusStore.$anonfun$taskSummary$4(this, stageId, stageAttemptId, count, BoxesRunTime.unboxToDouble((Object)q)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CachedQuantile.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).size()) {
            TaskMetricDistributions distributions = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.duration()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11.executorDeserializeTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.executorDeserializeCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13.executorRunTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14.executorCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble((double)x$15.resultSize()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16.jvmGcTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)x$17.resultSerializationTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToDouble((double)x$18.gettingResultTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19.schedulerDelay()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20.peakExecutionMemory()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21.memoryBytesSpilled()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.diskBytesSpilled()), cachedQuantiles), new InputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToDouble((double)x$23.bytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)x$24.recordsRead()), cachedQuantiles)), new OutputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.bytesWritten()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToDouble((double)x$26.recordsWritten()), cachedQuantiles)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToDouble((double)x$27.shuffleReadBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToDouble((double)x$28.shuffleRecordsRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToDouble((double)x$29.shuffleRemoteBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToDouble((double)x$30.shuffleLocalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToDouble((double)x$31.shuffleFetchWaitTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToDouble((double)x$32.shuffleRemoteBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToDouble((double)x$33.shuffleRemoteBytesReadToDisk()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToDouble((double)x$34.shuffleTotalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToDouble((double)x$35.shuffleRemoteReqsDuration()), cachedQuantiles), new ShufflePushReadMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToDouble((double)x$36.shuffleCorruptMergedBlockChunks()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToDouble((double)x$37.shuffleMergedFetchFallbackCount()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToDouble((double)x$38.shuffleMergedRemoteBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToDouble((double)x$39.shuffleMergedLocalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToDouble((double)x$40.shuffleMergedRemoteChunksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToDouble((double)x$41.shuffleMergedLocalChunksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToDouble((double)x$42.shuffleMergedRemoteBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToDouble((double)x$43.shuffleMergedLocalBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToDouble((double)x$44.shuffleMergedRemoteReqsDuration()), cachedQuantiles))), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToDouble((double)x$45.shuffleWriteBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToDouble((double)x$46.shuffleWriteRecords()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToDouble((double)x$47.shuffleWriteTime()), cachedQuantiles)));
            return new Some((Object)distributions);
        }
        long[] indices = (long[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)q -> package$.MODULE$.min((long)(q * (double)count), count - 1L), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        TaskMetricDistributions computedQuantiles = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)this.scanTasks$1("dur", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.duration()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("des", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dct", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ert", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorRunTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ect", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSize()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("gc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.jvmGcTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rst", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSerializationTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("grt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.gettingResultTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dly", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.schedulerDelay()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("pem", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.peakExecutionMemory()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("mbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.memoryBytesSpilled()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.diskBytesSpilled()), stageKey, indices), new InputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("is", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ir", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputRecordsRead()), stageKey, indices)), new OutputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("os", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("or", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputRecordsWritten()), stageKey, indices)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("stby", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$66(m)), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("slbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleLocalBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleFetchWaitTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srby", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesReadToDisk()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("stbl", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$73(m)), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srrd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteReqsDuration()), stageKey, indices), new ShufflePushReadMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("spcmbc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleCorruptMergedBlockChunks()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmffc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedFetchFallbackCount()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrb", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlb", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteChunksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalChunksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrrd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteReqDuration()), stageKey, indices))), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("sws", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleWriteTime()), stageKey, indices)));
        ((IterableLike)((TraversableLike)computedQuantiles.quantiles().zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$87(this, quantiles, x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AppStatusStore.$anonfun$taskSummary$88(this, stageId, stageAttemptId, count, computedQuantiles, x0$2);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)computedQuantiles);
    }

    private boolean shouldCacheQuantile(double q) {
        return package$.MODULE$.round(q * (double)100) % 5L == 0L;
    }

    private String quantileToString(double q) {
        return Long.toString(package$.MODULE$.round(q * (double)100));
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int maxTasks) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        Seq taskDataWrapperSeq = KVUtils$.MODULE$.viewToSeq(this.store().view(TaskDataWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey).reverse().max((long)maxTasks));
        return (Seq)this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperSeq).reverse();
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, TaskSorting sortBy, List<TaskStatus> statuses) {
        Tuple2 tuple2;
        TaskSorting taskSorting = sortBy;
        if (((Object)((Object)TaskSorting.ID)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.INCREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.DECREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)taskSorting);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option indexName = (Option)tuple22._1();
        boolean ascending = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)indexName, (Object)BoxesRunTime.boxToBoolean((boolean)ascending));
        Option indexName2 = (Option)tuple23._1();
        boolean ascending2 = tuple23._2$mcZ$sp();
        return this.taskList(stageId, stageAttemptId, offset, length, (Option<String>)indexName2, ascending2, statuses);
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, Option<String> sortBy, boolean ascending, List<TaskStatus> statuses) {
        Seq seq;
        KVStoreView ordered;
        KVStoreView kVStoreView;
        int[] stageKey = new int[]{stageId, stageAttemptId};
        KVStoreView base = this.store().view(TaskDataWrapper.class);
        Option<String> option = sortBy;
        if (option instanceof Some) {
            Some some = (Some)option;
            String index = (String)some.value();
            kVStoreView = base.index(index).parent((Object)stageKey);
        } else {
            kVStoreView = base.index("stage").first((Object)stageKey).last((Object)stageKey);
        }
        KVStoreView indexed = kVStoreView;
        KVStoreView kVStoreView2 = ordered = ascending ? indexed : indexed.reverse();
        if (statuses != null && !statuses.isEmpty()) {
            Set statusesStr = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.toString(), Buffer$.MODULE$.canBuildFrom())).toSet();
            seq = KVUtils$.MODULE$.viewToSeq(ordered, offset, offset + length, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statusesStr.contains((Object)s.status())));
        } else {
            seq = KVUtils$.MODULE$.viewToSeq(ordered.skip((long)offset).max((long)length));
        }
        Seq taskDataWrapperSeq = seq;
        return this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperSeq);
    }

    public List<TaskStatus> taskList$default$7() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Map<String, ExecutorStageSummary> executorSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return KVUtils$.MODULE$.mapToSeq(this.store().view(ExecutorStageSummaryWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey), (Function1 & Serializable & scala.Serializable)exec -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)exec.executorId()), (Object)exec.info())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<SpeculationStageSummary> speculationSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return this.asOption((Function0 & Serializable & scala.Serializable)() -> ((SpeculationStageSummaryWrapper)this.store().read(SpeculationStageSummaryWrapper.class, (Object)stageKey)).info());
    }

    public Seq<RDDStorageInfo> rddList(boolean cachedOnly) {
        return (Seq)KVUtils$.MODULE$.mapToSeq(this.store().view(RDDStorageInfoWrapper.class), (Function1 & Serializable & scala.Serializable)x$50 -> x$50.info()).filter((Function1 & Serializable & scala.Serializable)rdd -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$rddList$2(cachedOnly, rdd)));
    }

    public <T> Option<T> asOption(Function0<T> fn) {
        Some some;
        try {
            some = new Some(fn.apply());
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public StageData newStageData(StageData stage, boolean withDetail, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        None$ none$;
        if (!withDetail && !withSummaries) {
            return stage;
        }
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        if (withDetail) {
            Map tasks = ((TraversableOnce)this.taskList(stage.stageId(), stage.attemptId(), 0, Integer.MAX_VALUE, (Option<String>)None$.MODULE$, false, taskStatus).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)BoxesRunTime.boxToLong((long)t.taskId()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            none$ = new Some((Object)tasks);
        } else {
            none$ = None$.MODULE$;
        }
        None$ tasks = none$;
        None$ executorSummaries = withDetail ? new Some(this.executorSummary(stage.stageId(), stage.attemptId())) : None$.MODULE$;
        Option<TaskMetricDistributions> taskMetricsDistribution = withSummaries ? this.taskSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
        Option<ExecutorMetricsDistributions> executorMetricsDistributions = withSummaries ? this.stageExecutorSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
        Option<SpeculationStageSummary> speculationStageSummary = withDetail ? this.speculationSummary(stage.stageId(), stage.attemptId()) : None$.MODULE$;
        return new StageData(stage.status(), stage.stageId(), stage.attemptId(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks(), stage.numKilledTasks(), stage.numCompletedIndices(), stage.submissionTime(), stage.firstTaskLaunchedTime(), stage.completionTime(), stage.failureReason(), stage.executorDeserializeTime(), stage.executorDeserializeCpuTime(), stage.executorRunTime(), stage.executorCpuTime(), stage.resultSize(), stage.jvmGcTime(), stage.resultSerializationTime(), stage.memoryBytesSpilled(), stage.diskBytesSpilled(), stage.peakExecutionMemory(), stage.inputBytes(), stage.inputRecords(), stage.outputBytes(), stage.outputRecords(), stage.shuffleRemoteBlocksFetched(), stage.shuffleLocalBlocksFetched(), stage.shuffleFetchWaitTime(), stage.shuffleRemoteBytesRead(), stage.shuffleRemoteBytesReadToDisk(), stage.shuffleLocalBytesRead(), stage.shuffleReadBytes(), stage.shuffleReadRecords(), stage.shuffleCorruptMergedBlockChunks(), stage.shuffleMergedFetchFallbackCount(), stage.shuffleMergedRemoteBlocksFetched(), stage.shuffleMergedLocalBlocksFetched(), stage.shuffleMergedRemoteChunksFetched(), stage.shuffleMergedLocalChunksFetched(), stage.shuffleMergedRemoteBytesRead(), stage.shuffleMergedLocalBytesRead(), stage.shuffleRemoteReqsDuration(), stage.shuffleMergedRemoteReqsDuration(), stage.shuffleWriteBytes(), stage.shuffleWriteTime(), stage.shuffleWriteRecords(), stage.name(), stage.description(), stage.details(), stage.schedulingPool(), stage.rddIds(), stage.accumulatorUpdates(), (Option<Map<Object, TaskData>>)tasks, (Option<Map<String, ExecutorStageSummary>>)executorSummaries, speculationStageSummary, stage.killedTasksSummary(), stage.resourceProfileId(), stage.peakExecutorMetrics(), taskMetricsDistribution, executorMetricsDistributions, stage.isShufflePushEnabled(), stage.shuffleMergersCount());
    }

    public boolean newStageData$default$2() {
        return false;
    }

    public List<TaskStatus> newStageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean newStageData$default$4() {
        return false;
    }

    public double[] newStageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public Option<ExecutorMetricsDistributions> stageExecutorSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Map<String, ExecutorStageSummary> summary = this.executorSummary(stageId, stageAttemptId);
        if (summary.isEmpty()) {
            return None$.MODULE$;
        }
        scala.collection.immutable.IndexedSeq values = summary.values().toIndexedSeq();
        return new Some((Object)new ExecutorMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToDouble((double)x$51.taskTime()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToDouble((double)x$52.failedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToDouble((double)x$53.succeededTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToDouble((double)x$54.killedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToDouble((double)x$55.inputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToDouble((double)x$56.inputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToDouble((double)x$57.outputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$58 -> BoxesRunTime.boxToDouble((double)x$58.outputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$59 -> BoxesRunTime.boxToDouble((double)x$59.shuffleRead()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToDouble((double)x$60.shuffleReadRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToDouble((double)x$61.shuffleWrite()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToDouble((double)x$62.shuffleWriteRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToDouble((double)x$63.memoryBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), this.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$64 -> BoxesRunTime.boxToDouble((double)x$64.diskBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), new ExecutorPeakMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<ExecutorMetrics>)((IndexedSeq)values.flatMap((Function1 & Serializable & scala.Serializable)x$65 -> Option$.MODULE$.option2Iterable(x$65.peakMemoryMetrics()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())))));
    }

    public IndexedSeq<Object> getQuantilesValue(IndexedSeq<Object> values, double[] quantiles) {
        int count = values.size();
        long[] indices = (long[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)q -> package$.MODULE$.min((long)(q * (double)count), (long)(count - 1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(indices)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)values.apply((int)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toIndexedSeq();
    }

    public RDDStorageInfo rdd(int rddId) {
        return ((RDDStorageInfoWrapper)this.store().read(RDDStorageInfoWrapper.class, (Object)BoxesRunTime.boxToInteger((int)rddId))).info();
    }

    public boolean rddList$default$1() {
        return true;
    }

    public Seq<StreamBlockData> streamBlocksList() {
        return KVUtils$.MODULE$.viewToSeq(this.store().view(StreamBlockData.class));
    }

    public RDDOperationGraph operationGraphForStage(int stageId) {
        return ((RDDOperationGraphWrapper)this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)stageId))).toRDDOperationGraph();
    }

    public Seq<RDDOperationGraph> operationGraphForJob(int jobId) {
        JobDataWrapper job = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        Seq stages = (Seq)job.info().stageIds().sorted((Ordering)Ordering.Int$.MODULE$);
        return (Seq)stages.map((Function1 & Serializable & scala.Serializable)id -> AppStatusStore.$anonfun$operationGraphForJob$1(this, job, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
    }

    public PoolData pool(String name) {
        return (PoolData)this.store().read(PoolData.class, (Object)name);
    }

    public AppSummary appSummary() {
        AppSummary appSummary;
        try {
            appSummary = (AppSummary)this.store().read(AppSummary.class, (Object)AppSummary.class.getName());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application summary. If you are starting up Spark, please wait a while until it's ready.");
        }
        return appSummary;
    }

    public void close() {
        this.store().close();
        this.cleanUpStorePath();
    }

    private void cleanUpStorePath() {
        this.storePath().foreach((Function1 & Serializable & scala.Serializable)file -> {
            Utils$.MODULE$.deleteRecursively(file);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<TaskData> constructTaskDataList(Iterable<TaskDataWrapper> taskDataWrapperIter) {
        HashMap executorIdToLogs = new HashMap();
        return ((TraversableOnce)taskDataWrapperIter.map((Function1 & Serializable & scala.Serializable)taskDataWrapper -> {
            TaskData taskDataOld = taskDataWrapper.toApi();
            Map executorLogs = (Map)executorIdToLogs.getOrElseUpdate((Object)taskDataOld.executorId(), (Function0 & Serializable & scala.Serializable)() -> {
                Map map;
                try {
                    map = this.executorSummary(taskDataOld.executorId()).executorLogs();
                }
                catch (NoSuchElementException e) {
                    map = Predef$.MODULE$.Map().empty();
                }
                return map;
            });
            return new TaskData(taskDataOld.taskId(), taskDataOld.index(), taskDataOld.attempt(), taskDataOld.partitionId(), taskDataOld.launchTime(), taskDataOld.resultFetchStart(), taskDataOld.duration(), taskDataOld.executorId(), taskDataOld.host(), taskDataOld.status(), taskDataOld.taskLocality(), taskDataOld.speculative(), taskDataOld.accumulatorUpdates(), taskDataOld.errorMessage(), taskDataOld.taskMetrics(), (Map<String, String>)executorLogs, AppStatusUtils$.MODULE$.schedulerDelay(taskDataOld), AppStatusUtils$.MODULE$.gettingResultTime(taskDataOld));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$executorList$2(ExecutorSummary x$4) {
        String string = x$4.id();
        String string2 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID().executorId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ long $anonfun$taskSummary$2(KVStoreIterator it) {
        long _count = 0L;
        while (it.hasNext()) {
            ++_count;
            it.skip(1L);
        }
        return _count;
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$6(long count$1, CachedQuantile x$9) {
        return x$9.taskCount() == count$1;
    }

    public static final /* synthetic */ Iterable $anonfun$taskSummary$4(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, double q) {
        Object[] qkey = new Object[]{BoxesRunTime.boxToInteger((int)stageId$1), BoxesRunTime.boxToInteger((int)stageAttemptId$1), $this.quantileToString(q)};
        return Option$.MODULE$.option2Iterable($this.asOption((Function0 & Serializable & scala.Serializable)() -> (CachedQuantile)$this.store().read(CachedQuantile.class, (Object)qkey)).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$6(count$1, x$9))));
    }

    private static final IndexedSeq toValues$1(Function1 fn, CachedQuantile[] cachedQuantiles$1) {
        return (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles$1)).map(fn, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private final IndexedSeq scanTasks$1(String index, Function1 fn, int[] stageKey$1, long[] indices$1) {
        return (IndexedSeq)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey$1).index(index).first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> {
            DoubleRef last = DoubleRef.create((double)Double.NaN);
            LongRef currentIdx = LongRef.create((long)-1L);
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(indices$1)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)idx -> {
                if (idx == currentIdx$1.elem) {
                    return last$1.elem;
                }
                long diff = idx - currentIdx$1.elem;
                currentIdx$1.elem = idx;
                if (it.skip(diff - 1L)) {
                    last$1.elem = BoxesRunTime.unboxToLong((Object)fn.apply(it.next()));
                    return last$1.elem;
                }
                return Double.NaN;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toIndexedSeq();
        });
    }

    public static final /* synthetic */ long $anonfun$taskSummary$66(TaskDataWrapper m) {
        return m.shuffleLocalBytesRead() + m.shuffleRemoteBytesRead();
    }

    public static final /* synthetic */ long $anonfun$taskSummary$73(TaskDataWrapper m) {
        return m.shuffleLocalBlocksFetched() + m.shuffleRemoteBlocksFetched();
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$87(AppStatusStore $this, double[] quantiles$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double q = tuple2._1$mcD$sp();
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles$2)).contains((Object)BoxesRunTime.boxToDouble((double)q)) && $this.shouldCacheQuantile(q);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$taskSummary$88(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, TaskMetricDistributions computedQuantiles$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double q = tuple2._1$mcD$sp();
            int idx = tuple2._2$mcI$sp();
            CachedQuantile cached = new CachedQuantile(stageId$1, stageAttemptId$1, $this.quantileToString(q), count$1, BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.duration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorRunTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSize().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.jvmGcTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSerializationTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.gettingResultTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.schedulerDelay().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.peakExecutionMemory().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.memoryBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.diskBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().bytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().recordsRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().bytesWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().recordsWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().localBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().fetchWaitTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesReadToDisk().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().totalBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().corruptMergedBlockChunks().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().mergedFetchFallbackCount().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedChunksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedChunksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteReqsDuration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedReqsDuration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeTime().apply(idx)));
            $this.store().write((Object)cached);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$rddList$2(boolean cachedOnly$1, RDDStorageInfo rdd) {
        return !cachedOnly$1 || rdd.numCachedPartitions() > 0;
    }

    public static final /* synthetic */ RDDOperationGraph $anonfun$operationGraphForJob$1(AppStatusStore $this, JobDataWrapper job$1, int id) {
        RDDOperationGraph g;
        block0: {
            g = ((RDDOperationGraphWrapper)$this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)id))).toRDDOperationGraph();
            if (!job$1.skippedStages().contains((Object)BoxesRunTime.boxToInteger((int)id)) || g.rootCluster().name().contains("skipped")) break block0;
            g.rootCluster().setName(new StringBuilder(10).append(g.rootCluster().name()).append(" (skipped)").toString());
        }
        return g;
    }

    public AppStatusStore(KVStore store, Option<AppStatusListener> listener, Option<File> storePath) {
        this.store = store;
        this.listener = listener;
        this.storePath = storePath;
    }
}

