/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.shuffle.BlockStoreClient;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001q4QAC\u0006\u0001\u001bMA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001B\u0001B\u0003%Q\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0004=\u0001\t\u0007I\u0011B\u001f\t\ra\u0003\u0001\u0015!\u0003?\u0011\u0019I\u0006\u0001\"\u0001\u000e5\"1a\f\u0001C\u0001\u001b}Ca!\u001a\u0001\u0005\u000251'a\u0005%pgRdunY1m\t&\u0014X*\u00198bO\u0016\u0014(B\u0001\u0007\u000e\u0003\u001d\u0019Ho\u001c:bO\u0016T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u001b\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002 9\t9Aj\\4hS:<\u0017A\u00064viV\u0014X-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0004\u0001A\u00111EJ\u0007\u0002I)\u0011QEF\u0001\u000bG>t7-\u001e:sK:$\u0018BA\u0014%\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0005dC\u000eDWmU5{KB\u0011QCK\u0005\u0003WY\u00111!\u00138u\u0003A\u0011Gn\\2l'R|'/Z\"mS\u0016tG\u000f\u0005\u0002/g5\tqF\u0003\u00021c\u000591\u000f[;gM2,'B\u0001\u001a\u000e\u0003\u001dqW\r^<pe.L!\u0001N\u0018\u0003!\tcwnY6Ti>\u0014Xm\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u00038siZ\u0004C\u0001\u001d\u0001\u001b\u0005Y\u0001\"\u0002\u0011\u0005\u0001\u0004\u0011\u0003\"\u0002\u0015\u0005\u0001\u0004I\u0003\"\u0002\u0017\u0005\u0001\u0004i\u0013AG3yK\u000e,Ho\u001c:JIR{Gj\\2bY\u0012K'o]\"bG\",W#\u0001 \u0011\t}B%*V\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u0007\u0012\u000baaY8n[>t'BA#G\u0003\u00199wn\\4mK*\tq)A\u0002d_6L!!\u0013!\u0003\u000b\r\u000b7\r[3\u0011\u0005-\u0013fB\u0001'Q!\tie#D\u0001O\u0015\ty\u0015%\u0001\u0004=e>|GOP\u0005\u0003#Z\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011K\u0006\t\u0004+YS\u0015BA,\u0017\u0005\u0015\t%O]1z\u0003m)\u00070Z2vi>\u0014\u0018\n\u001a+p\u0019>\u001c\u0017\r\u001c#jeN\u001c\u0015m\u00195fA\u00051r-\u001a;DC\u000eDW\r\u001a%pgRdunY1m\t&\u00148/F\u0001\\!\u0011YELS+\n\u0005u#&aA'ba\u0006Ir-\u001a;DC\u000eDW\r\u001a%pgRdunY1m\t&\u00148OR8s)\t\u00017\rE\u0002\u0016CVK!A\u0019\f\u0003\r=\u0003H/[8o\u0011\u0015!\u0007\u00021\u0001K\u0003))\u00070Z2vi>\u0014\u0018\nZ\u0001\u0011O\u0016$\bj\\:u\u0019>\u001c\u0017\r\u001c#jeN$Ba\u001a<yuR\u0011\u0001n\u001b\t\u0003+%L!A\u001b\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y&\u0001\r!\\\u0001\tG\u0006dGNY1dWB!QC\u001c9i\u0013\tygCA\u0005Gk:\u001cG/[8ocA\u0019\u0011\u000f^.\u000e\u0003IT!a\u001d\f\u0002\tU$\u0018\u000e\\\u0005\u0003kJ\u00141\u0001\u0016:z\u0011\u00159\u0018\u00021\u0001K\u0003\u0011Awn\u001d;\t\u000beL\u0001\u0019A\u0015\u0002\tA|'\u000f\u001e\u0005\u0006w&\u0001\r!V\u0001\fKb,7-\u001e;pe&#7\u000f")
public class HostLocalDirManager
implements Logging {
    private final BlockStoreClient blockStoreClient;
    private final Cache<String, String[]> executorIdToLocalDirsCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Cache<String, String[]> executorIdToLocalDirsCache() {
        return this.executorIdToLocalDirsCache;
    }

    public Map<String, String[]> getCachedHostLocalDirs() {
        Map map;
        Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
        synchronized (cache) {
            map = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executorIdToLocalDirsCache().asMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public Option<String[]> getCachedHostLocalDirsFor(String executorId) {
        Option option;
        Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
        synchronized (cache) {
            option = Option$.MODULE$.apply(this.executorIdToLocalDirsCache().getIfPresent((Object)executorId));
        }
        return option;
    }

    public void getHostLocalDirs(String host, int port, String[] executorIds, Function1<Try<Map<String, String[]>>, BoxedUnit> callback) {
        CompletableFuture hostLocalDirsCompletable = new CompletableFuture();
        this.blockStoreClient.getHostLocalDirs(host, port, executorIds, hostLocalDirsCompletable);
        hostLocalDirsCompletable.whenComplete((hostLocalDirs, throwable) -> {
            if (hostLocalDirs != null) {
                callback.apply((Object)new Success((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(hostLocalDirs).asScala()).toMap(Predef$.MODULE$.$conforms())));
                Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
                synchronized (cache) {
                    this.executorIdToLocalDirsCache().putAll(hostLocalDirs);
                }
                return;
            }
            callback.apply((Object)new Failure(throwable));
        });
    }

    public HostLocalDirManager(ExecutionContext futureExecutionContext, int cacheSize, BlockStoreClient blockStoreClient) {
        this.blockStoreClient = blockStoreClient;
        Logging.$init$(this);
        this.executorIdToLocalDirsCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
    }
}

