/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.memory;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.HopTwoWayPasswordEncoder;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.BaseMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataSerializer;

public class MemoryMetadataProvider
extends BaseMetadataProvider
implements IHopMetadataProvider {
    public static final String DEFAULT_DESCRIPTION = "In memory metadata";
    private Map<String, IHopMetadataSerializer<IHopMetadata>> serializerMap = new HashMap<String, IHopMetadataSerializer<IHopMetadata>>();
    private ITwoWayPasswordEncoder twoWayPasswordEncoder;

    public MemoryMetadataProvider() {
        super(Variables.getADefaultVariableSpace(), DEFAULT_DESCRIPTION);
        this.twoWayPasswordEncoder = Encr.getEncoder();
        if (this.twoWayPasswordEncoder == null) {
            this.twoWayPasswordEncoder = new HopTwoWayPasswordEncoder();
        }
    }

    public MemoryMetadataProvider(ITwoWayPasswordEncoder twoWayPasswordEncoder, IVariables variables) {
        super(variables, DEFAULT_DESCRIPTION);
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
    }

    @Override
    public <T extends IHopMetadata> IHopMetadataSerializer<T> getSerializer(Class<T> managedClass) throws HopException {
        IHopMetadataSerializer<IHopMetadata> serializer = this.serializerMap.get(managedClass.getName());
        if (serializer == null) {
            HopMetadata hopMetadata = managedClass.getAnnotation(HopMetadata.class);
            String description = managedClass.getSimpleName();
            if (hopMetadata != null) {
                description = hopMetadata.name();
            }
            serializer = new MemoryMetadataSerializer<IHopMetadata>(this, managedClass, this.variables, description);
            this.serializerMap.put(managedClass.getName(), serializer);
        }
        return serializer;
    }

    @Override
    public ITwoWayPasswordEncoder getTwoWayPasswordEncoder() {
        return this.twoWayPasswordEncoder;
    }

    public Map<String, IHopMetadataSerializer<IHopMetadata>> getSerializerMap() {
        return this.serializerMap;
    }

    public void setSerializerMap(Map<String, IHopMetadataSerializer<IHopMetadata>> serializerMap) {
        this.serializerMap = serializerMap;
    }

    public void setTwoWayPasswordEncoder(ITwoWayPasswordEncoder twoWayPasswordEncoder) {
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
    }
}

