/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.DefaultOutputFormatContainer;
import org.apache.hive.hcatalog.mapreduce.FileOutputFormatContainer;
import org.apache.hive.hcatalog.mapreduce.FosterStorageHandler;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public abstract class HCatBaseOutputFormat
extends OutputFormat<WritableComparable<?>, HCatRecord> {
    public static HCatSchema getTableSchema(Configuration conf) throws IOException {
        OutputJobInfo jobInfo = HCatBaseOutputFormat.getJobInfo(conf);
        return jobInfo.getTableInfo().getDataColumns();
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.getOutputFormat(context).checkOutputSpecs(context);
    }

    protected OutputFormat<WritableComparable<?>, HCatRecord> getOutputFormat(JobContext context) throws IOException {
        OutputJobInfo jobInfo = HCatBaseOutputFormat.getJobInfo(context.getConfiguration());
        HiveStorageHandler storageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), jobInfo.getTableInfo().getStorerInfo());
        HCatBaseOutputFormat.configureOutputStorageHandler(context);
        if (storageHandler instanceof FosterStorageHandler) {
            return new FileOutputFormatContainer((org.apache.hadoop.mapred.OutputFormat)ReflectionUtils.newInstance((Class)storageHandler.getOutputFormatClass(), (Configuration)context.getConfiguration()));
        }
        return new DefaultOutputFormatContainer((org.apache.hadoop.mapred.OutputFormat<WritableComparable<?>, Writable>)((org.apache.hadoop.mapred.OutputFormat)ReflectionUtils.newInstance((Class)storageHandler.getOutputFormatClass(), (Configuration)context.getConfiguration())));
    }

    public static OutputJobInfo getJobInfo(Configuration conf) throws IOException {
        String jobString = conf.get("mapreduce.lib.hcatoutput.info");
        if (jobString == null) {
            throw new HCatException(ErrorType.ERROR_NOT_INITIALIZED);
        }
        return (OutputJobInfo)HCatUtil.deserialize(jobString);
    }

    static void configureOutputStorageHandler(JobContext jobContext) throws IOException {
        HCatBaseOutputFormat.configureOutputStorageHandler(jobContext, null);
    }

    static void configureOutputStorageHandler(JobContext jobContext, List<String> dynamicPartVals) throws IOException {
        Configuration conf = jobContext.getConfiguration();
        try {
            OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize(conf.get("mapreduce.lib.hcatoutput.info"));
            HiveStorageHandler storageHandler = HCatUtil.getStorageHandler(jobContext.getConfiguration(), jobInfo.getTableInfo().getStorerInfo());
            Map<String, String> partitionValues = jobInfo.getPartitionValues();
            String location = jobInfo.getLocation();
            if (dynamicPartVals != null) {
                List<String> dynamicPartKeys = jobInfo.getDynamicPartitioningKeys();
                if (dynamicPartVals.size() != dynamicPartKeys.size()) {
                    throw new HCatException(ErrorType.ERROR_INVALID_PARTITION_VALUES, "Unable to configure dynamic partitioning for storage handler, mismatch between number of partition values obtained[" + dynamicPartVals.size() + "] and number of partition values required[" + dynamicPartKeys.size() + "]");
                }
                for (int i = 0; i < dynamicPartKeys.size(); ++i) {
                    partitionValues.put(dynamicPartKeys.get(i), dynamicPartVals.get(i));
                }
                jobInfo.setPartitionValues(partitionValues);
            }
            HCatUtil.configureOutputStorageHandler(storageHandler, conf, jobInfo);
        }
        catch (Exception e) {
            if (e instanceof HCatException) {
                throw (HCatException)e;
            }
            throw new HCatException(ErrorType.ERROR_INIT_STORAGE_HANDLER, (Throwable)e);
        }
    }

    protected static void configureOutputStorageHandler(JobContext context, OutputJobInfo jobInfo, Map<String, String> fullPartSpec) throws IOException {
        List<String> dynamicPartKeys = jobInfo.getDynamicPartitioningKeys();
        if (dynamicPartKeys == null || dynamicPartKeys.isEmpty()) {
            HCatBaseOutputFormat.configureOutputStorageHandler(context, null);
        } else {
            ArrayList<String> dynKeyVals = new ArrayList<String>();
            for (String dynamicPartKey : dynamicPartKeys) {
                dynKeyVals.add(fullPartSpec.get(dynamicPartKey));
            }
            HCatBaseOutputFormat.configureOutputStorageHandler(context, dynKeyVals);
        }
    }

    protected static void setPartDetails(OutputJobInfo jobInfo, HCatSchema schema, Map<String, String> partMap) throws HCatException, IOException {
        Integer idx;
        ArrayList<Integer> posOfPartCols = new ArrayList<Integer>();
        ArrayList<Integer> posOfDynPartCols = new ArrayList<Integer>();
        HCatSchema schemaWithoutParts = new HCatSchema(schema.getFields());
        for (String partKey : partMap.keySet()) {
            idx = schema.getPosition(partKey);
            if (idx == null) continue;
            posOfPartCols.add(idx);
            schemaWithoutParts.remove(schema.get(partKey));
        }
        if (jobInfo.isDynamicPartitioningUsed()) {
            for (String partKey : jobInfo.getDynamicPartitioningKeys()) {
                idx = schema.getPosition(partKey);
                if (idx == null) continue;
                posOfPartCols.add(idx);
                posOfDynPartCols.add(idx);
                schemaWithoutParts.remove(schema.get(partKey));
            }
        }
        HCatUtil.validatePartitionSchema(new Table(jobInfo.getTableInfo().getTable()), schemaWithoutParts);
        jobInfo.setPosOfPartCols(posOfPartCols);
        jobInfo.setPosOfDynPartCols(posOfDynPartCols);
        jobInfo.setOutputSchema(schemaWithoutParts);
    }
}

