/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.evaluatetablecontent;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="EVAL_TABLE_CONTENT", name="i18n::ActionEvalTableContent.Name", description="i18n::ActionEvalTableContent.Description", image="EvalTableContent.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionEvalTableContent.keyword"}, documentationUrl="/workflow/actions/evaluatetablecontent.html")
public class ActionEvalTableContent
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionEvalTableContent.class;
    private boolean addRowsResult = false;
    private boolean clearResultList = true;
    private boolean useVars = false;
    private boolean useCustomSql = false;
    private String customSql = null;
    private DatabaseMeta connection = null;
    private String tableName = null;
    private String schemaname = null;
    private String limit = "0";
    private int successCondition = 4;
    private static final String selectCount = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0])};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;

    public ActionEvalTableContent(String n) {
        super(n, "");
    }

    public ActionEvalTableContent() {
        this("");
    }

    public Object clone() {
        ActionEvalTableContent je = (ActionEvalTableContent)super.clone();
        return je;
    }

    public int getSuccessCondition() {
        return this.successCondition;
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalTableContent.getSuccessConditionByCode(tt);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)ActionEvalTableContent.getSuccessConditionCode(this.successCondition)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"limit", (String)this.limit));
        retval.append("      ").append(XmlHandler.addTagValue((String)"is_custom_sql", (boolean)this.useCustomSql));
        retval.append("      ").append(XmlHandler.addTagValue((String)"is_usevars", (boolean)this.useVars));
        retval.append("      ").append(XmlHandler.addTagValue((String)"custom_sql", (String)this.customSql));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_rows_result", (boolean)this.addRowsResult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"clear_result_rows", (boolean)this.clearResultList));
        return retval.toString();
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    private static int getSucessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            this.schemaname = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.successCondition = ActionEvalTableContent.getSucessConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)""));
            this.limit = Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"limit"), (String)"0");
            this.useCustomSql = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"is_custom_sql"));
            this.useVars = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"is_usevars"));
            this.customSql = XmlHandler.getTagValue((Node)entrynode, (String)"custom_sql");
            this.addRowsResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_rows_result"));
            this.clearResultList = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"clear_result_rows"));
        }
        catch (HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionEvalTableContent.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        block37: {
            result = previousResult;
            result.setResult(false);
            countSqlStatement = null;
            rowsCount = 0L;
            errCount = 0L;
            successOK = false;
            nrRowsLimit = Const.toInt((String)this.resolve(this.limit), (int)0);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
            }
            if (this.connection != null) {
                try {
                    db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
                    try {
                        db.connect();
                        if (this.useCustomSql) {
                            realCustomSql = this.customSql;
                            if (this.useVars) {
                                realCustomSql = this.resolve(realCustomSql);
                            }
                            if (this.log.isDebug()) {
                                this.logDebug(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.EnteredCustomSQL", (String[])new String[]{realCustomSql}));
                            }
                            if (!Utils.isEmpty((CharSequence)realCustomSql)) {
                                countSqlStatement = realCustomSql;
                            } else {
                                ++errCount;
                                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.NoCustomSQL", (String[])new String[0]));
                            }
                        } else {
                            realTablename = this.resolve(this.tableName);
                            realSchemaname = this.resolve(this.schemaname);
                            if (!Utils.isEmpty((CharSequence)realTablename)) {
                                countSqlStatement = !Utils.isEmpty((CharSequence)realSchemaname) ? "SELECT count(*) FROM " + db.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, realSchemaname, realTablename) : "SELECT count(*) FROM " + db.getDatabaseMeta().quoteField(realTablename);
                            } else {
                                ++errCount;
                                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.NoTableName", (String[])new String[0]));
                            }
                        }
                        if (countSqlStatement == null) break block37;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.RunSQLStatement", (String[])new String[]{countSqlStatement}));
                        }
                        if (this.useCustomSql) {
                            if (this.clearResultList) {
                                result.getRows().clear();
                            }
                            if ((ar = db.getRows((String)countSqlStatement, 0)) != null) {
                                rowsCount = ar.size();
                                rowMeta = db.getQueryFields((String)countSqlStatement, false);
                                rows = new ArrayList<RowMetaAndData>();
                                for (i = 0; i < ar.size(); ++i) {
                                    rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
                                }
                                if (this.addRowsResult && this.useCustomSql && rows != null) {
                                    result.getRows().addAll(rows);
                                }
                            } else if (this.log.isDebug()) {
                                this.logDebug(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.customSQLreturnedNothing", (String[])new String[]{countSqlStatement}));
                            }
                        } else {
                            row = db.getOneRow((String)countSqlStatement);
                            if (row != null) {
                                rowsCount = row.getInteger(0);
                            }
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                        }
                        switch (this.successCondition) {
                            case 0: {
                                successOK = rowsCount == (long)nrRowsLimit;
                                ** break;
lbl64:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                successOK = rowsCount != (long)nrRowsLimit;
                                ** break;
lbl68:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                successOK = rowsCount < (long)nrRowsLimit;
                                ** break;
lbl72:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                successOK = rowsCount <= (long)nrRowsLimit;
                                ** break;
lbl76:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                successOK = rowsCount > (long)nrRowsLimit;
                                ** break;
lbl80:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                successOK = rowsCount >= (long)nrRowsLimit;
                                ** break;
lbl84:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl86:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        db.close();
                    }
                }
                catch (HopException dbe) {
                    ++errCount;
                    this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
                }
            } else {
                ++errCount;
                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.NoDbConnection", (String[])new String[0]));
            }
        }
        result.setResult(successOK);
        result.setNrLinesRead(rowsCount);
        result.setNrErrors(errCount);
        return result;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "WaitForSQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public boolean isAddRowsResult() {
        return this.addRowsResult;
    }

    public void setAddRowsResult(boolean addRowsResult) {
        this.addRowsResult = addRowsResult;
    }

    public boolean isClearResultList() {
        return this.clearResultList;
    }

    public void setClearResultList(boolean clearResultList) {
        this.clearResultList = clearResultList;
    }

    public boolean isUseVars() {
        return this.useVars;
    }

    public void setUseVars(boolean useVars) {
        this.useVars = useVars;
    }

    public boolean isUseCustomSql() {
        return this.useCustomSql;
    }

    public void setUseCustomSql(boolean useCustomSql) {
        this.useCustomSql = useCustomSql;
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    public DatabaseMeta getConnection() {
        return this.connection;
    }

    public void setConnection(DatabaseMeta connection) {
        this.connection = connection;
    }

    public String getTablename() {
        return this.tableName;
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setSuccessCondition(int successCondition) {
        this.successCondition = successCondition;
    }
}

