/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.samplerows;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.samplerows.SampleRows;
import org.apache.hop.pipeline.transforms.samplerows.SampleRowsData;
import org.w3c.dom.Node;

@Transform(id="SampleRows", image="samplerows.svg", name="i18n::SampleRows.Name", description="i18n::SampleRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", keywords={"i18n::SampleRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/samplerows.html")
public class SampleRowsMeta
extends BaseTransformMeta<SampleRows, SampleRowsData> {
    private static final Class<?> PKG = SampleRowsMeta.class;
    private String linesrange;
    private String linenumfield;
    public static String DEFAULT_RANGE = "1";

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.linenumfield)) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.linenumfield));
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.linesrange = XmlHandler.getTagValue((Node)transformNode, (String)"linesrange");
            this.linenumfield = XmlHandler.getTagValue((Node)transformNode, (String)"linenumfield");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SampleRowsMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getLinesRange() {
        return this.linesrange;
    }

    public void setLinesRange(String linesrange) {
        this.linesrange = linesrange;
    }

    public String getLineNumberField() {
        return this.linenumfield;
    }

    public void setLineNumberField(String linenumfield) {
        this.linenumfield = linenumfield;
    }

    public void setDefault() {
        this.linesrange = DEFAULT_RANGE;
        this.linenumfield = null;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"linesrange", (String)this.linesrange));
        retval.append("    " + XmlHandler.addTagValue((String)"linenumfield", (String)this.linenumfield));
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.linesrange) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }
}

